/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.RegexASTVisitorIterable;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class Group
extends QuantifiableTerm
implements RegexASTVisitorIterable {
    private ArrayList<Sequence> alternatives = new ArrayList();
    private short visitorIterationIndex = 0;
    private short groupNumber = (short)-1;
    private short groupsWithGuardsIndex = (short)-1;
    private int enclosedCaptureGroupsLo;
    private int enclosedCaptureGroupsHi;
    private int enclosedZeroWidthGroupsLo;
    private int enclosedZeroWidthGroupsHi;

    Group() {
    }

    Group(int groupNumber) {
        this.setGroupNumber(groupNumber);
    }

    protected Group(Group copy) {
        super(copy);
        this.groupNumber = copy.groupNumber;
        this.enclosedCaptureGroupsLo = copy.enclosedCaptureGroupsLo;
        this.enclosedCaptureGroupsHi = copy.enclosedCaptureGroupsHi;
    }

    @Override
    public Group copy(RegexAST ast) {
        Group copy = new Group(this);
        if (this.isCapturing()) {
            ast.registerCaptureGroupCopy(copy);
        }
        return ast.register(copy);
    }

    @Override
    public Group copyRecursive(RegexAST ast, CompilationBuffer compilationBuffer) {
        Group copy = this.copy(ast);
        for (Sequence s : this.alternatives) {
            copy.add(s.copyRecursive(ast, compilationBuffer));
        }
        return copy;
    }

    public boolean isLoop() {
        return this.isFlagSet(4096);
    }

    public void setLoop(boolean loop) {
        this.setFlag(4096, loop);
    }

    public boolean isLocalFlags() {
        return this.isFlagSet(131072);
    }

    public void setLocalFlags(boolean loop) {
        this.setFlag(131072, loop);
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public int getBoundaryIndexStart() {
        assert (this.isCapturing());
        return Group.groupNumberToBoundaryIndexStart(this.groupNumber);
    }

    public int getBoundaryIndexEnd() {
        assert (this.isCapturing());
        return Group.groupNumberToBoundaryIndexEnd(this.groupNumber);
    }

    public static int groupNumberToBoundaryIndexStart(int groupNumber) {
        return groupNumber * 2;
    }

    public static int groupNumberToBoundaryIndexEnd(int groupNumber) {
        return groupNumber * 2 + 1;
    }

    public boolean isCapturing() {
        return this.groupNumber >= 0;
    }

    public void setGroupNumber(int groupNumber) {
        assert (groupNumber <= Short.MAX_VALUE);
        this.groupNumber = (short)groupNumber;
    }

    public boolean hasGroupWithGuardsIndex() {
        return this.groupsWithGuardsIndex >= 0;
    }

    public int getGroupsWithGuardsIndex() {
        return this.groupsWithGuardsIndex;
    }

    public void setGroupsWithGuardsIndex(int groupsWithGuardsIndex) {
        assert (groupsWithGuardsIndex <= Short.MAX_VALUE);
        this.groupsWithGuardsIndex = (short)groupsWithGuardsIndex;
    }

    public void clearGroupNumber() {
        this.groupNumber = (short)-1;
    }

    public int getEnclosedCaptureGroupsLo() {
        return this.enclosedCaptureGroupsLo;
    }

    public int getCaptureGroupsLo() {
        return this.isCapturing() ? this.getGroupNumber() : this.enclosedCaptureGroupsLo;
    }

    public void setEnclosedCaptureGroupsLo(int enclosedCaptureGroupsLo) {
        assert (enclosedCaptureGroupsLo <= Short.MAX_VALUE);
        this.enclosedCaptureGroupsLo = (short)enclosedCaptureGroupsLo;
    }

    public int getEnclosedCaptureGroupsHi() {
        return this.enclosedCaptureGroupsHi;
    }

    public int getCaptureGroupsHi() {
        return this.enclosedCaptureGroupsHi;
    }

    public void setEnclosedCaptureGroupsHi(int enclosedCaptureGroupsHi) {
        assert (enclosedCaptureGroupsHi <= Short.MAX_VALUE);
        this.enclosedCaptureGroupsHi = (short)enclosedCaptureGroupsHi;
    }

    public boolean hasEnclosedCaptureGroups() {
        return this.enclosedCaptureGroupsHi > this.enclosedCaptureGroupsLo;
    }

    public int getEnclosedZeroWidthGroupsLo() {
        return this.enclosedZeroWidthGroupsLo;
    }

    public void setEnclosedZeroWidthGroupsLo(int enclosedZeroWidthGroupsLo) {
        this.enclosedZeroWidthGroupsLo = enclosedZeroWidthGroupsLo;
    }

    public int getEnclosedZeroWidthGroupsHi() {
        return this.enclosedZeroWidthGroupsHi;
    }

    public void setEnclosedZeroWidthGroupsHi(int enclosedZeroWidthGroupsHi) {
        this.enclosedZeroWidthGroupsHi = enclosedZeroWidthGroupsHi;
    }

    public boolean isAlwaysZeroWidth() {
        for (Sequence s : this.alternatives) {
            for (Term t : s.getTerms()) {
                if (t.isPositionAssertion() || t.isLookAroundAssertion() || t.isGroup() && t.asGroup().isAlwaysZeroWidth() || t.isAtomicGroup() && t.asAtomicGroup().getGroup().isAlwaysZeroWidth()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isUnrollingCandidate() {
        return this.hasQuantifier() && this.getQuantifier().isWithinThreshold(6);
    }

    public ArrayList<Sequence> getAlternatives() {
        return this.alternatives;
    }

    public void setAlternatives(ArrayList<Sequence> alternatives) {
        for (Sequence s : alternatives) {
            s.setParent(this);
        }
        this.alternatives = alternatives;
    }

    public Sequence getFirstAlternative() {
        return this.alternatives.get(0);
    }

    public int size() {
        return this.alternatives.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void add(Sequence sequence) {
        sequence.setParent(this);
        this.alternatives.add(sequence);
        this.checkMaxSize();
    }

    public void insertFirst(Sequence sequence) {
        sequence.setParent(this);
        this.alternatives.add(0, sequence);
        this.checkMaxSize();
    }

    private void checkMaxSize() {
        if (this.alternatives.size() > Short.MAX_VALUE) {
            throw new UnsupportedRegexException("too many sequences in a single group");
        }
    }

    public Sequence addSequence(RegexAST ast) {
        Sequence sequence = ast.createSequence();
        this.add(sequence);
        return sequence;
    }

    public Sequence getLastAlternative() {
        return this.alternatives.get(this.size() - 1);
    }

    public void removeLastSequence() {
        this.alternatives.remove(this.alternatives.size() - 1);
    }

    public boolean isLiteral() {
        return this.alternatives.size() == 1 && this.alternatives.get(0).isLiteral();
    }

    @Override
    public boolean visitorHasNext() {
        return this.visitorIterationIndex < this.alternatives.size();
    }

    @Override
    public RegexASTNode visitorGetNext(boolean reverse) {
        short s = this.visitorIterationIndex;
        this.visitorIterationIndex = (short)(s + 1);
        return this.alternatives.get(s);
    }

    @Override
    public void resetVisitorIterator() {
        this.visitorIterationIndex = 0;
    }

    @CompilerDirectives.TruffleBoundary
    public String alternativesToString() {
        return this.alternatives.stream().map(Sequence::toString).collect(Collectors.joining("|"));
    }

    public String loopToString() {
        return this.isLoop() ? "*" : this.quantifierToString();
    }

    @Override
    public boolean equalsSemantic(RegexASTNode obj, boolean ignoreQuantifier) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != Group.class) {
            return false;
        }
        Group o = (Group)obj;
        if (this.size() != o.size() || this.groupNumber != o.groupNumber || this.isLoop() != o.isLoop() || !ignoreQuantifier && !this.quantifierEquals(o)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.alternatives.get(i).equalsSemantic(o.alternatives.get(i))) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "(" + (this.isCapturing() ? "" : "?:") + this.alternativesToString() + ")" + this.loopToString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return this.toJson("Group").append(Json.prop("groupNumber", this.groupNumber), Json.prop("isCapturing", this.isCapturing()), Json.prop("isLoop", this.isLoop()), Json.prop("isExpandedLoop", this.isExpandedQuantifier()), Json.prop("alternatives", this.alternatives));
    }
}

