/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.errors.JsErrorMessages;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.flavors.ECMAScriptFlavor;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public final class JSRegexLexer
extends RegexLexer {
    private static final CodePointSet ID_START = ECMAScriptFlavor.UNICODE.getProperty("ID_Start").union(CodePointSet.createNoDedup(36, 36, 95, 95));
    private static final CodePointSet ID_CONTINUE = ECMAScriptFlavor.UNICODE.getProperty("ID_Continue").union(CodePointSet.createNoDedup(36, 36, 8204, 8205));
    private static final TBitSet SYNTAX_CHARS = TBitSet.valueOf(36, 40, 41, 42, 43, 46, 47, 63, 91, 92, 93, 94, 123, 124, 125);
    private static final TBitSet CLASS_SET_SYNTAX_CHARS = TBitSet.valueOf(40, 41, 45, 47, 91, 92, 93, 123, 124, 125);
    private static final TBitSet CLASS_SET_RESERVED_PUNCTUATORS = TBitSet.valueOf(33, 35, 37, 38, 44, 45, 58, 59, 60, 61, 62, 64, 96, 126);
    private static final TBitSet CLASS_SET_RESERVED_DOUBLE_PUNCTUATORS = TBitSet.valueOf(33, 35, 36, 37, 38, 42, 43, 44, 46, 58, 59, 60, 61, 62, 63, 64, 94, 96, 126);
    private final Deque<RegexFlags> flagsStack = new ArrayDeque<RegexFlags>();
    private RegexFlags globalFlags;

    public JSRegexLexer(RegexSource source, RegexFlags flags, CompilationBuffer compilationBuffer) {
        super(source, compilationBuffer);
        this.globalFlags = flags;
    }

    public RegexFlags getGlobalFlags() {
        return this.globalFlags;
    }

    public RegexFlags getLocalFlags() {
        return this.flagsStack.isEmpty() ? this.globalFlags : this.flagsStack.peek();
    }

    public void pushLocalFlags(RegexFlags localFlags) {
        this.flagsStack.push(localFlags);
    }

    public void popLocalFlags() {
        this.flagsStack.pop();
    }

    @Override
    protected boolean featureEnabledIgnoreCase() {
        return this.getLocalFlags().isIgnoreCase();
    }

    @Override
    protected boolean featureEnabledAZPositionAssertions() {
        return false;
    }

    @Override
    protected boolean featureEnabledZLowerCaseAssertion() {
        return false;
    }

    @Override
    protected boolean featureEnabledBoundedQuantifierEmptyMin() {
        return false;
    }

    @Override
    protected boolean featureEnabledPossessiveQuantifiers() {
        return false;
    }

    @Override
    protected boolean featureEnabledCharClassFirstBracketIsLiteral() {
        return false;
    }

    @Override
    protected boolean featureEnabledCCRangeWithPredefCharClass() {
        return true;
    }

    @Override
    protected boolean featureEnabledNestedCharClasses() {
        return false;
    }

    @Override
    protected boolean featureEnabledPOSIXCharClasses() {
        return false;
    }

    @Override
    protected boolean featureEnabledForwardReferences() {
        return true;
    }

    @Override
    protected boolean featureEnabledGroupComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledLineComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledIgnoreWhiteSpace() {
        return false;
    }

    @Override
    protected TBitSet getWhitespace() {
        return DEFAULT_WHITESPACE;
    }

    @Override
    protected boolean featureEnabledOctalEscapes() {
        return !this.getLocalFlags().isEitherUnicode();
    }

    @Override
    protected boolean featureEnabledSpecialGroups() {
        return true;
    }

    @Override
    protected boolean featureEnabledUnicodePropertyEscapes() {
        return this.getLocalFlags().isEitherUnicode();
    }

    @Override
    protected boolean featureEnabledClassSetExpressions() {
        return this.getLocalFlags().isUnicodeSets();
    }

    @Override
    protected void caseFoldUnfold(CodePointSetAccumulator charClass) {
        CaseFoldData.CaseFoldUnfoldAlgorithm caseFolding = this.getLocalFlags().isEitherUnicode() ? CaseFoldData.CaseFoldUnfoldAlgorithm.ECMAScriptUnicode : CaseFoldData.CaseFoldUnfoldAlgorithm.ECMAScriptNonUnicode;
        CodePointSetAccumulator tmp = this.compilationBuffer.getCodePointSetAccumulator1();
        CaseFoldData.applyCaseFoldUnfold(charClass, tmp, caseFolding);
    }

    @Override
    protected CodePointSet complementClassSet(CodePointSet codePointSet) {
        if (this.getLocalFlags().isUnicodeSets() && this.getLocalFlags().isIgnoreCase()) {
            return codePointSet.createInverse(CaseFoldData.FOLDED_CHARACTERS, this.compilationBuffer);
        }
        return codePointSet.createInverse(this.source.getEncoding());
    }

    @Override
    protected ClassSetContents caseFoldClassSetAtom(ClassSetContents classSetContents) {
        if (this.getLocalFlags().isUnicodeSets() && this.getLocalFlags().isIgnoreCase()) {
            return classSetContents.caseFold(this.compilationBuffer.getCodePointSetAccumulator1());
        }
        return classSetContents;
    }

    @Override
    protected CodePointSet getDotCodePointSet() {
        return this.getLocalFlags().isDotAll() ? Constants.DOT_ALL : Constants.DOT;
    }

    @Override
    protected CodePointSet getIdContinue() {
        return ID_CONTINUE;
    }

    @Override
    protected CodePointSet getIdStart() {
        return ID_START;
    }

    @Override
    protected int getMaxBackReferenceDigits() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected CodePointSet getPredefinedCharClass(char c) {
        CodePointSet predefinedCharClass = this.getPredefinedCharClassCPS(c);
        if (this.featureEnabledIgnoreCase()) {
            return this.caseFoldUnfold(predefinedCharClass);
        }
        return predefinedCharClass;
    }

    private CodePointSet getPredefinedCharClassCPS(char c) {
        switch (c) {
            case 's': {
                if (this.source.getOptions().isU180EWhitespace()) {
                    return Constants.LEGACY_WHITE_SPACE;
                }
                return Constants.WHITE_SPACE;
            }
            case 'S': {
                if (this.source.getOptions().isU180EWhitespace()) {
                    return Constants.LEGACY_NON_WHITE_SPACE;
                }
                return Constants.NON_WHITE_SPACE;
            }
            case 'd': {
                return Constants.DIGITS;
            }
            case 'D': {
                return Constants.NON_DIGITS;
            }
            case 'w': {
                if (this.getLocalFlags().isUnicodeSets() && this.getLocalFlags().isIgnoreCase()) {
                    return Constants.WORD_CHARS_UNICODE_SETS_IGNORE_CASE;
                }
                if (this.getLocalFlags().isUnicode() && this.getLocalFlags().isIgnoreCase()) {
                    return Constants.WORD_CHARS_UNICODE_IGNORE_CASE;
                }
                return Constants.WORD_CHARS;
            }
            case 'W': {
                if (this.getLocalFlags().isUnicodeSets() && this.getLocalFlags().isIgnoreCase()) {
                    return Constants.NON_WORD_CHARS_UNICODE_SETS_IGNORE_CASE;
                }
                if (this.getLocalFlags().isUnicode() && this.getLocalFlags().isIgnoreCase()) {
                    return Constants.NON_WORD_CHARS_UNICODE_IGNORE_CASE;
                }
                return Constants.NON_WORD_CHARS;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void checkClassSetCharacter(int codePoint) throws RegexSyntaxException {
        String punctuator;
        if (CLASS_SET_SYNTAX_CHARS.get(codePoint)) {
            throw this.syntaxError(JsErrorMessages.unexpectedCharacterInClassSet(codePoint), RegexSyntaxException.ErrorCode.InvalidCharacterClass);
        }
        if (CLASS_SET_RESERVED_DOUBLE_PUNCTUATORS.get(codePoint) && this.lookahead(punctuator = Character.toString(codePoint))) {
            throw this.syntaxError(JsErrorMessages.unexpectedDoublePunctuatorInClassSet(punctuator), RegexSyntaxException.ErrorCode.InvalidCharacterClass);
        }
    }

    @Override
    protected long boundedQuantifierMaxValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected RegexSyntaxException handleBoundedQuantifierOutOfOrder() {
        return this.syntaxError("Numbers out of order in {} quantifier", RegexSyntaxException.ErrorCode.InvalidQuantifier);
    }

    @Override
    protected Token handleBoundedQuantifierEmptyOrMissingMin() throws RegexSyntaxException {
        if (this.getLocalFlags().isEitherUnicode()) {
            throw this.syntaxError("Incomplete quantifier", RegexSyntaxException.ErrorCode.InvalidQuantifier);
        }
        this.position = this.getLastTokenPosition() + 1;
        return this.literalChar(123);
    }

    @Override
    protected Token handleBoundedQuantifierInvalidCharacter() {
        return this.handleBoundedQuantifierEmptyOrMissingMin();
    }

    @Override
    protected Token handleBoundedQuantifierOverflow(long min, long max) {
        return null;
    }

    @Override
    protected Token handleBoundedQuantifierOverflowMin(long min, long max) {
        return null;
    }

    @Override
    protected RegexSyntaxException handleCCRangeOutOfOrder(int startPos) {
        return this.syntaxError("Range out of order in character class", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
    }

    @Override
    protected void handleCCRangeWithPredefCharClass(int startPos, ClassSetContents firstAtom, ClassSetContents secondAtom) {
        if (this.getLocalFlags().isEitherUnicode()) {
            throw this.syntaxError("Invalid character class", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
        }
    }

    @Override
    protected CodePointSet getPOSIXCharClass(String name) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void validatePOSIXCollationElement(String sequence) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void validatePOSIXEquivalenceClass(String sequence) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleComplementOfStringSet() {
        return this.syntaxError(JsErrorMessages.invalidRegularExpression(this.source, "Negated character class may contain strings"), RegexSyntaxException.ErrorCode.InvalidCharacterClass);
    }

    @Override
    protected void handleGroupRedefinition(String name, int newId, int oldId) {
    }

    @Override
    protected void handleIncompleteEscapeX() {
        if (this.getLocalFlags().isEitherUnicode()) {
            throw this.syntaxError("Invalid escape", RegexSyntaxException.ErrorCode.InvalidEscape);
        }
    }

    @Override
    protected Token handleInvalidBackReference(int reference) {
        if (this.getLocalFlags().isEitherUnicode()) {
            throw this.syntaxError("Missing capture group for backreference", RegexSyntaxException.ErrorCode.InvalidBackReference);
        }
        return null;
    }

    @Override
    protected RegexSyntaxException handleInvalidCharInCharClass() {
        return this.syntaxError("Invalid character in character class", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
    }

    private int handleInvalidEscape(int c) {
        if (this.getLocalFlags().isEitherUnicode()) {
            throw this.syntaxError("Invalid escape", RegexSyntaxException.ErrorCode.InvalidEscape);
        }
        return c;
    }

    @Override
    protected RegexSyntaxException handleInvalidGroupBeginQ() {
        return this.syntaxError("Invalid group", RegexSyntaxException.ErrorCode.InvalidGroup);
    }

    @Override
    protected RegexSyntaxException handleMixedClassSetOperators(RegexLexer.ClassSetOperator leftOperator, RegexLexer.ClassSetOperator rightOperator) {
        return this.syntaxError(JsErrorMessages.mixedOperatorsInClassSet(leftOperator, rightOperator), RegexSyntaxException.ErrorCode.InvalidCharacterClass);
    }

    @Override
    protected RegexSyntaxException handleMissingClassSetOperand(RegexLexer.ClassSetOperator operator) {
        return this.syntaxError(JsErrorMessages.missingClassSetOperand(operator), RegexSyntaxException.ErrorCode.InvalidCharacterClass);
    }

    @Override
    protected void handleOctalOutOfRange() {
    }

    @Override
    protected RegexSyntaxException handleRangeAsClassSetOperand(RegexLexer.ClassSetOperator operator) {
        return this.syntaxError(JsErrorMessages.rangeAsClassSetOperand(operator), RegexSyntaxException.ErrorCode.InvalidCharacterClass);
    }

    @Override
    protected void handleUnfinishedEscape() {
        throw this.syntaxError("Ends with an unfinished escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
    }

    @Override
    protected void handleUnfinishedGroupComment() {
    }

    @Override
    protected RegexSyntaxException handleUnfinishedGroupQ() {
        return this.syntaxError("Invalid group", RegexSyntaxException.ErrorCode.InvalidGroup);
    }

    @Override
    protected RegexSyntaxException handleUnfinishedRangeInClassSet() {
        return this.syntaxError("Unterminated character range", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
    }

    @Override
    protected void handleUnmatchedRightBrace() {
        if (this.getLocalFlags().isEitherUnicode()) {
            throw this.syntaxError("Unmatched '}'", RegexSyntaxException.ErrorCode.InvalidQuantifier);
        }
    }

    @Override
    protected RegexSyntaxException handleUnmatchedLeftBracket() {
        return this.syntaxError("Unterminated character class", RegexSyntaxException.ErrorCode.UnmatchedBracket);
    }

    @Override
    protected void handleUnmatchedRightBracket() {
        if (this.getLocalFlags().isEitherUnicode()) {
            throw this.syntaxError("Unmatched ']'", RegexSyntaxException.ErrorCode.UnmatchedBracket);
        }
    }

    @Override
    protected int parseCodePointInGroupName() throws RegexSyntaxException {
        if (this.consumingLookahead("\\u")) {
            int unicodeEscape = this.parseUnicodeEscapeChar(true);
            if (unicodeEscape < 0) {
                throw this.syntaxError("Invalid Unicode escape", RegexSyntaxException.ErrorCode.InvalidEscape);
            }
            return unicodeEscape;
        }
        int c = this.consumeChar();
        return Character.isHighSurrogate((char)c) ? this.finishSurrogatePair((char)c) : c;
    }

    private String jsParseGroupName() {
        RegexLexer.ParseGroupNameResult result = this.parseGroupName('>');
        switch (result.state) {
            case empty: {
                throw this.syntaxError("Empty named capture group name", RegexSyntaxException.ErrorCode.InvalidNamedGroup);
            }
            case unterminated: {
                throw this.syntaxError("Unterminated group name", RegexSyntaxException.ErrorCode.InvalidNamedGroup);
            }
            case invalidStart: {
                throw this.syntaxError("Invalid character at start of group name", RegexSyntaxException.ErrorCode.InvalidNamedGroup);
            }
            case invalidRest: {
                throw this.syntaxError("Invalid character in group name", RegexSyntaxException.ErrorCode.InvalidNamedGroup);
            }
            case valid: {
                return result.groupName;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token parseCustomEscape(char c) {
        if (c == 'b') {
            return Token.createWordBoundary();
        }
        if (c == 'B') {
            return Token.createNonWordBoundary();
        }
        if (c == 'k') {
            if (this.getLocalFlags().isEitherUnicode() || this.hasNamedCaptureGroups()) {
                if (this.atEnd()) {
                    this.handleUnfinishedEscape();
                }
                if (this.consumeChar() != '<') {
                    throw this.syntaxError("Missing group name in named capture group reference", RegexSyntaxException.ErrorCode.InvalidNamedGroup);
                }
                String groupName = this.jsParseGroupName();
                if (this.namedCaptureGroups.containsKey(groupName)) {
                    return Token.createBackReference(((List)this.namedCaptureGroups.get(groupName)).stream().mapToInt(x -> x).toArray(), false);
                }
                Map<String, List<Integer>> allNamedCaptureGroups = this.getNamedCaptureGroups();
                if (allNamedCaptureGroups != null && allNamedCaptureGroups.containsKey(groupName)) {
                    return Token.createBackReference(allNamedCaptureGroups.get(groupName).stream().mapToInt(x -> x).toArray(), false);
                }
                throw this.syntaxError("Missing capture group for backreference", RegexSyntaxException.ErrorCode.InvalidBackReference);
            }
            return this.literalChar(c);
        }
        return null;
    }

    @Override
    protected int parseCustomEscapeChar(char c, boolean inCharClass) {
        switch (c) {
            case 48: {
                if (this.getLocalFlags().isEitherUnicode() && this.lookahead(RegexLexer::isDecimalDigit, 1)) {
                    throw this.syntaxError("Invalid escape", RegexSyntaxException.ErrorCode.InvalidEscape);
                }
                if (!this.getLocalFlags().isEitherUnicode() && this.lookahead(RegexLexer::isOctalDigit, 1)) {
                    return this.parseOctal(0, 2);
                }
                return 0;
            }
            case 99: {
                if (this.atEnd()) {
                    this.retreat();
                    return this.handleInvalidControlEscape();
                }
                char controlLetter = this.curChar();
                if (!this.getLocalFlags().isEitherUnicode() && (JSRegexLexer.isDecimalDigit(controlLetter) || controlLetter == '_') && inCharClass) {
                    this.advance();
                    return controlLetter % 32;
                }
                if (!('a' <= controlLetter && controlLetter <= 'z' || 'A' <= controlLetter && controlLetter <= 'Z')) {
                    this.retreat();
                    return this.handleInvalidControlEscape();
                }
                this.advance();
                return Character.toUpperCase(controlLetter) - 64;
            }
            case 117: {
                int unicodeEscape = this.parseUnicodeEscapeChar(this.getLocalFlags().isEitherUnicode());
                return unicodeEscape < 0 ? c : unicodeEscape;
            }
        }
        return -1;
    }

    @Override
    protected int parseCustomEscapeCharFallback(int c, boolean inCharClass) {
        if (inCharClass && this.getLocalFlags().isUnicodeSets() ? !SYNTAX_CHARS.get(c) && !CLASS_SET_RESERVED_PUNCTUATORS.get(c) : (inCharClass ? !SYNTAX_CHARS.get(c) && c != 45 : !SYNTAX_CHARS.get(c))) {
            return this.handleInvalidEscape(c);
        }
        return c;
    }

    private char handleInvalidControlEscape() throws RegexSyntaxException {
        if (this.getLocalFlags().isEitherUnicode()) {
            throw this.syntaxError("Invalid control char escape", RegexSyntaxException.ErrorCode.InvalidEscape);
        }
        return '\\';
    }

    @Override
    protected Token parseCustomGroupBeginQ(char charAfterQuestionMark) {
        if (RegexFlags.isValidFlagChar(charAfterQuestionMark) || charAfterQuestionMark == '-') {
            return this.parseFlagModifier(charAfterQuestionMark);
        }
        return null;
    }

    private RegexFlags parseLocalFlags(char firstChar) {
        char ch = firstChar;
        RegexFlags flags = RegexFlags.DEFAULT;
        while (RegexFlags.isValidFlagChar(ch)) {
            if (!RegexFlags.isValidLocalFlagChar(ch)) {
                throw this.syntaxError(JsErrorMessages.flagNotAllowedInModifier(ch), RegexSyntaxException.ErrorCode.InvalidInlineFlag);
            }
            flags = flags.addNewFlagModifier(this.source, ch);
            if (this.atEnd()) {
                throw this.syntaxError("Incomplete modifier", RegexSyntaxException.ErrorCode.InvalidInlineFlag);
            }
            ch = this.consumeChar();
        }
        return flags;
    }

    private Token parseFlagModifier(char charAfterQuestionMark) {
        RegexFlags addFlags = this.parseLocalFlags(charAfterQuestionMark);
        char ch = this.prevChar();
        switch (ch) {
            case ':': {
                return this.finishFlagModifier(addFlags, RegexFlags.DEFAULT);
            }
            case '-': {
                if (this.atEnd()) {
                    throw this.syntaxError("Incomplete modifier", RegexSyntaxException.ErrorCode.InvalidInlineFlag);
                }
                ch = this.consumeChar();
                RegexFlags removeFlags = this.parseLocalFlags(ch);
                ch = this.prevChar();
                if (ch != ':') {
                    if (Character.isAlphabetic(ch)) {
                        throw this.syntaxError("Invalid regular expression flag in modifier", RegexSyntaxException.ErrorCode.InvalidInlineFlag);
                    }
                    throw this.syntaxError("Invalid modifier", RegexSyntaxException.ErrorCode.InvalidInlineFlag);
                }
                return this.finishFlagModifier(addFlags, removeFlags);
            }
        }
        if (Character.isAlphabetic(ch)) {
            throw this.syntaxError("Invalid regular expression flag in modifier", RegexSyntaxException.ErrorCode.InvalidInlineFlag);
        }
        throw this.syntaxError("Invalid modifier", RegexSyntaxException.ErrorCode.InvalidInlineFlag);
    }

    private Token finishFlagModifier(RegexFlags addFlags, RegexFlags removeFlags) {
        if (addFlags.overlaps(removeFlags)) {
            throw this.syntaxError("Modifier is both adding and removing the same flag", RegexSyntaxException.ErrorCode.InvalidInlineFlag);
        }
        if (addFlags.isNone() && removeFlags.isNone()) {
            throw this.syntaxError("No flags in modifier", RegexSyntaxException.ErrorCode.InvalidInlineFlag);
        }
        RegexFlags newFlags = this.getLocalFlags().addFlags(addFlags).delFlags(removeFlags);
        return Token.createInlineFlags(newFlags, false);
    }

    @Override
    protected Token parseGroupLt() {
        this.registerNamedCaptureGroup(this.jsParseGroupName());
        return Token.createCaptureGroupBegin();
    }

    private int parseUnicodeEscapeChar(boolean unicodeMode) throws RegexSyntaxException {
        if (unicodeMode && this.consumingLookahead("{")) {
            int value = this.parseHexUnicode(1, Integer.MAX_VALUE, 0x10FFFF);
            if (!this.consumingLookahead("}")) {
                throw this.syntaxError("Invalid Unicode escape", RegexSyntaxException.ErrorCode.InvalidEscape);
            }
            return value;
        }
        int value = this.parseHexUnicode(4, 4, 65535);
        if (unicodeMode && Character.isHighSurrogate((char)value)) {
            int resetIndex = this.position;
            if (this.consumingLookahead("\\u") && !this.lookahead("{")) {
                char lead = (char)value;
                char trail = (char)this.parseHexUnicode(4, 4, 65535);
                if (Character.isLowSurrogate(trail)) {
                    return Character.toCodePoint(lead, trail);
                }
                this.position = resetIndex;
            } else {
                this.position = resetIndex;
            }
        }
        return value;
    }

    private int parseHexUnicode(int minDigits, int maxDigits, int maxValue) {
        return this.parseHex(minDigits, maxDigits, maxValue, () -> {
            if (this.getLocalFlags().isEitherUnicode()) {
                throw this.syntaxError("Invalid Unicode escape", RegexSyntaxException.ErrorCode.InvalidEscape);
            }
        }, () -> {
            throw this.syntaxError("Invalid Unicode escape", RegexSyntaxException.ErrorCode.InvalidEscape);
        });
    }
}

