/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.validation.SignatureAttributeIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.cms.Attribute;

public class CAdESAttributeIdentifier
extends SignatureAttributeIdentifier {
    private static final long serialVersionUID = -1244583446667611418L;

    CAdESAttributeIdentifier(byte[] data) {
        super(data);
    }

    @Deprecated
    public static CAdESAttributeIdentifier build(Attribute attribute) {
        return CAdESAttributeIdentifier.build(attribute, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static CAdESAttributeIdentifier build(Attribute attribute, Integer order) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            CAdESAttributeIdentifier cAdESAttributeIdentifier;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                if (attribute != null) {
                    dos.write(attribute.getEncoded());
                }
                if (order != null) {
                    dos.write(order);
                }
                dos.flush();
                cAdESAttributeIdentifier = new CAdESAttributeIdentifier(baos.toByteArray());
            }
            return cAdESAttributeIdentifier;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to build a CAdESAttributeIdentifier. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }
}

