/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CAdESSignatureExtension
implements SignatureExtension<CAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignatureExtension.class);
    protected final TSPSource tspSource;
    protected final CertificateVerifier certificateVerifier;

    protected CAdESSignatureExtension(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(tspSource, "Missing TSPSource");
        this.tspSource = tspSource;
        this.certificateVerifier = certificateVerifier;
    }

    public CMSSignedDocument extendSignatures(DSSDocument signatureToExtend, CAdESSignatureParameters parameters) {
        LOG.trace("EXTEND SIGNATURES.");
        CMSSignedData cmsSignedData = this.getCMSSignedData(signatureToExtend);
        CMSSignedData extendCMSSignedData = this.extendCMSSignatures(cmsSignedData, parameters);
        return new CMSSignedDocument(extendCMSSignedData);
    }

    private CMSSignedData getCMSSignedData(DSSDocument document) {
        CMSSignedData cMSSignedData;
        block9: {
            if (document instanceof CMSSignedDocument) {
                return ((CMSSignedDocument)document).getCMSSignedData();
            }
            InputStream inputStream = document.openStream();
            try {
                cMSSignedData = new CMSSignedData(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CMSException e) {
                    throw new IllegalInputException(String.format("Cannot parse CMS data. Reason : %s", e.getMessage()), e);
                }
            }
            inputStream.close();
        }
        return cMSSignedData;
    }

    public CMSSignedData extendCMSSignatures(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        return this.extendCMSSignatures(cmsSignedData, cmsSignedData.getSignerInfos().getSigners(), parameters);
    }

    public CMSSignedData extendCMSSignatures(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) {
        return this.extendCMSSignatures(cmsSignedData, Collections.singletonList(signerInformation), parameters);
    }

    protected CMSSignedData extendCMSSignatures(CMSSignedData cmsSignedData, Collection<SignerInformation> signerInformationsToExtend, CAdESSignatureParameters parameters) {
        LOG.info("EXTEND CMS SIGNATURES.");
        this.assertCMSSignaturesValid(cmsSignedData, signerInformationsToExtend, parameters);
        Collection signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
        if (Utils.isCollectionEmpty((Collection)signerInformationCollection)) {
            throw new IllegalInputException("Unable to extend the document! No signatures found.");
        }
        ArrayList<String> signatureIdsToExtend = new ArrayList<String>();
        CMSDocumentValidator validator = this.getDocumentValidator(cmsSignedData, parameters);
        List signatures = validator.getSignatures();
        for (AdvancedSignature signature : signatures) {
            CAdESSignature cadesSignature = (CAdESSignature)signature;
            if (!signerInformationsToExtend.contains(cadesSignature.getSignerInformation())) continue;
            signatureIdsToExtend.add(cadesSignature.getId());
        }
        return this.extendCMSSignatures(cmsSignedData, parameters, signatureIdsToExtend);
    }

    protected abstract CMSSignedData extendCMSSignatures(CMSSignedData var1, CAdESSignatureParameters var2, List<String> var3);

    protected CMSSignedData replaceSigners(CMSSignedData cmsSignedData, List<SignerInformation> newSignerInformationList) {
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        CMSSignedData updatedCmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)cmsSignedData, (SignerInformationStore)newSignerStore);
        return CMSUtils.populateDigestAlgorithmSet(updatedCmsSignedData, cmsSignedData);
    }

    protected CAdESSignature newCAdESSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, List<DSSDocument> detachedContents) {
        CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
        cadesSignature.setDetachedContents(detachedContents);
        cadesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
        return cadesSignature;
    }

    protected ASN1Object getTimeStampAttributeValue(DSSMessageDigest timestampMessageDigest, DigestAlgorithm timestampDigestAlgorithm, Attribute ... attributesForTimestampToken) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Message to timestamp is {}", (Object)timestampMessageDigest);
            }
            TimestampBinary timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, timestampMessageDigest.getValue());
            CMSSignedData cmsSignedDataTimeStampToken = new CMSSignedData(timeStampToken.getBytes());
            if (attributesForTimestampToken != null) {
                SignerInformation signerInformation = (SignerInformation)cmsSignedDataTimeStampToken.getSignerInfos().getSigners().iterator().next();
                AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
                for (Attribute attributeToAdd : attributesForTimestampToken) {
                    ASN1ObjectIdentifier attrType = attributeToAdd.getAttrType();
                    ASN1Encodable objectAt = attributeToAdd.getAttrValues().getObjectAt(0);
                    unsignedAttributes = unsignedAttributes.add(attrType, objectAt);
                }
                if (unsignedAttributes.size() == 0) {
                    unsignedAttributes = null;
                }
                SignerInformation newSignerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
                ArrayList<SignerInformation> signerInformationList = new ArrayList<SignerInformation>();
                signerInformationList.add(newSignerInformation);
                SignerInformationStore newSignerStore = new SignerInformationStore(signerInformationList);
                cmsSignedDataTimeStampToken = CMSSignedData.replaceSigners((CMSSignedData)cmsSignedDataTimeStampToken, (SignerInformationStore)newSignerStore);
            }
            byte[] newTimeStampTokenBytes = cmsSignedDataTimeStampToken.getEncoded();
            return DSSASN1Utils.toASN1Primitive((byte[])newTimeStampTokenBytes);
        }
        catch (IOException | CMSException e) {
            throw new DSSException("Cannot obtain timestamp attribute value.", e);
        }
    }

    private void assertCMSSignaturesValid(CMSSignedData cmsSignedData, Collection<SignerInformation> signerInformationsToExtend, CAdESSignatureParameters parameters) {
        if (!SignatureForm.PAdES.equals((Object)parameters.getSignatureLevel().getSignatureForm())) {
            Collection signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
            for (SignerInformation signerInformation : signerInformationCollection) {
                if (!signerInformationsToExtend.contains(signerInformation)) continue;
                CAdESSignature cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
                this.assertSignatureValid(cadesSignature, parameters);
            }
        }
    }

    private void assertSignatureValid(CAdESSignature cadesSignature, CAdESSignatureParameters parameters) {
        if (parameters.isGenerateTBSWithoutCertificate() && cadesSignature.getCertificateSource().getNumberOfCertificates() == 0) {
            LOG.debug("Extension of a signature without TBS certificate. Signature validity is not checked.");
            return;
        }
        SignatureCryptographicVerification signatureCryptographicVerification = cadesSignature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }

    protected CMSDocumentValidator getDocumentValidator(CMSSignedData signedData, CAdESSignatureParameters parameters) {
        CMSDocumentValidator documentValidator = new CMSDocumentValidator(signedData);
        documentValidator.setCertificateVerifier(this.certificateVerifier);
        documentValidator.setDetachedContents(parameters.getDetachedContents());
        return documentValidator;
    }
}

