/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.util;

import de.governikus.csl.transport.ApacheHttpClient;
import de.governikus.csl.transport.TransportFactoryConfiguration;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import de.governikus.csl.uom.configuration.ProxyConfigurationImpl;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;

public class ApacheHttpClientBuilder {
    private final TransportFactoryConfiguration config = new TransportFactoryConfiguration();
    private final List<Certificate> trustedServerCerts = new ArrayList<Certificate>();
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private HttpRequestInterceptor requestInterceptor;
    private HttpResponseInterceptor responseInterceptor;

    public ApacheHttpClientBuilder clientKeyAlias(String clientKeyAlias) {
        this.config.setClientKeyAlias(clientKeyAlias);
        return this;
    }

    public ApacheHttpClientBuilder clientKeyPassword(String clientKeyPassword) {
        this.config.setClientKeyPassword(clientKeyPassword);
        return this;
    }

    public ApacheHttpClientBuilder clientKeystore(KeyStore clientKeystore) {
        this.config.setClientKeystore(clientKeystore);
        return this;
    }

    public ApacheHttpClientBuilder maxConnectionsPerHost(int maxConnectionsPerHost) {
        this.config.setMaxConnectionsPerHost(maxConnectionsPerHost);
        return this;
    }

    public ApacheHttpClientBuilder connectionManagerTimeout(int connectionManagerTimeout) {
        this.config.setConnectionManagerTimeout(connectionManagerTimeout);
        return this;
    }

    public ApacheHttpClientBuilder connectionTimeout(int connectionTimeout) {
        this.config.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public ApacheHttpClientBuilder socketTimeout(int socketTimeout) {
        this.config.setSocketTimeout(socketTimeout);
        return this;
    }

    public ApacheHttpClientBuilder connectionManagerShared(boolean connectionManagerShared) {
        this.config.setConnectionManagerShared(connectionManagerShared);
        return this;
    }

    public ApacheHttpClientBuilder trustedServerCert(Certificate trustedServerCert) {
        this.trustedServerCerts.add(trustedServerCert);
        return this;
    }

    public ApacheHttpClientBuilder acceptAllSSLServerCertificates(boolean acceptAllSSLServerCertificates) {
        this.config.setAcceptAllSSLServerCertificates(acceptAllSSLServerCertificates);
        return this;
    }

    public ProxyConfigurationBuilder proxyConfiguration() {
        return new ProxyConfigurationBuilder(this);
    }

    public ApacheHttpClientBuilder requestInterceptor(HttpRequestInterceptor requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
        return this;
    }

    public ApacheHttpClientBuilder responseInterceptor(HttpResponseInterceptor responseInterceptor) {
        this.responseInterceptor = responseInterceptor;
        return this;
    }

    private void proxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.config.setProxyConfiguration(proxyConfiguration);
    }

    public ApacheHttpClientBuilder defaultHeader(String name, String value) {
        this.defaultHeaders.put(name, value);
        return this;
    }

    public ApacheHttpClient build() {
        this.config.setTrustedServerCerts(this.trustedServerCerts);
        return new ApacheHttpClient(this.config, this.requestInterceptor, this.responseInterceptor);
    }

    public static class ProxyConfigurationBuilder {
        private final ApacheHttpClientBuilder parent;
        private final ProxyConfigurationImpl proxyConfiguration = new ProxyConfigurationImpl();

        public ProxyConfigurationBuilder(ApacheHttpClientBuilder parent) {
            this.parent = parent;
        }

        public ProxyConfigurationBuilder proxyHost(String proxyHost) {
            this.proxyConfiguration.setProxyHost(proxyHost);
            return this;
        }

        public ProxyConfigurationBuilder proxyPort(int proxyPort) {
            this.proxyConfiguration.setProxyPort(proxyPort);
            return this;
        }

        public ProxyConfigurationBuilder proxyException(String proxyException) {
            this.proxyConfiguration.getProxyExceptions().add(proxyException);
            return this;
        }

        public ApacheHttpClientBuilder and() {
            this.parent.proxyConfiguration((ProxyConfiguration)this.proxyConfiguration);
            return this.parent;
        }
    }
}

