/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedCertTrustStrategy
implements TrustStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedCertTrustStrategy.class);
    private List<Certificate> trustedServerCerts;

    public TrustedCertTrustStrategy(List<Certificate> trustedServerCerts) {
        this.trustedServerCerts = trustedServerCerts;
    }

    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509Certificate x509Certificate : chain) {
            if (!this.trustedServerCerts.contains(x509Certificate)) continue;
            LOG.debug("matched certificate: {}", (Object)x509Certificate);
            return true;
        }
        return false;
    }
}

