/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedCertHostnameVerifier
implements HostnameVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedCertHostnameVerifier.class);
    private List<Certificate> trustedServerCerts;
    private HostnameVerifier defaultHostnameVerifier;

    public TrustedCertHostnameVerifier(List<Certificate> trustedServerCerts) {
        this.trustedServerCerts = trustedServerCerts;
        this.defaultHostnameVerifier = new DefaultHostnameVerifier();
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        try {
            for (Certificate certificate : session.getPeerCertificates()) {
                if (!this.trustedServerCerts.contains(certificate)) continue;
                return true;
            }
        }
        catch (SSLPeerUnverifiedException e) {
            LOG.error("could not verify hostname", (Throwable)e);
        }
        return this.defaultHostnameVerifier.verify(hostname, session);
    }
}

