/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.transport.ApacheHttpClient;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.LDAPSocketFactory;
import de.governikus.csl.transport.TracingApacheHttpClient;
import de.governikus.csl.transport.TransportFactoryConfiguration;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportFactoryInitializer {
    private static final String SOCKET_FACTORY_PROPERTY = "java.naming.ldap.factory.socket";
    private static final String CONNECT_TIMEOUT_PROPERTY = "com.sun.jndi.ldap.connect.timeout";
    private static final String READ_TIMEOUT_PROPERTY = "com.sun.jndi.ldap.read.timeout";
    private static final Logger LOG = LoggerFactory.getLogger(TransportFactoryInitializer.class);

    private TransportFactoryInitializer() {
    }

    public static TransportFactoryConfiguration initializeTransportConfiguration(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String bypassedHostsString) {
        ArrayList<String> noProxyHosts = new ArrayList<String>();
        if (bypassedHostsString != null) {
            for (String host : bypassedHostsString.split(";")) {
                noProxyHosts.add(host);
            }
        }
        return new TransportFactoryConfiguration(proxyHost, proxyPort.intValue(), proxyUser, proxyPassword, noProxyHosts);
    }

    public static TransportFactoryConfiguration initializeTransportConfiguration(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, List<String> bypassedHosts) {
        return TransportFactoryInitializer.initializeTransportConfiguration(proxyHost, proxyPort, proxyUser, proxyPassword, TransportFactoryInitializer.createBypassedHostsString(bypassedHosts));
    }

    public static TransportFactoryConfiguration initializeTransportConfiguration(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String ... bypassedHosts) {
        String byPassedHostsString = TransportFactoryInitializer.createBypassedHostsString(bypassedHosts);
        return TransportFactoryInitializer.initializeTransportConfiguration(proxyHost, proxyPort, proxyUser, proxyPassword, byPassedHostsString);
    }

    private static String createBypassedHostsString(List<String> bypassedHosts) {
        String byPassedHostsString = null;
        if (bypassedHosts != null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String bph : bypassedHosts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(";");
                }
                sb.append(bph);
            }
            byPassedHostsString = sb.toString();
        }
        return byPassedHostsString;
    }

    private static String createBypassedHostsString(String ... bypassedHosts) {
        String byPassedHostsString = null;
        if (bypassedHosts != null && bypassedHosts.length > 0) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String bph : bypassedHosts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(";");
                }
                sb.append(bph);
            }
            byPassedHostsString = sb.toString();
        }
        return byPassedHostsString;
    }

    public static HttpClient initialiseTransportFactory(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String byPassedHostsString) {
        ArrayList<String> noProxyHosts = new ArrayList<String>();
        for (String host : byPassedHostsString.split(";")) {
            noProxyHosts.add(host);
        }
        return new ApacheHttpClient(new TransportFactoryConfiguration(proxyHost, proxyPort.intValue(), proxyUser, proxyPassword, noProxyHosts));
    }

    public static HttpClient initialiseTransportFactory(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, List<String> byPassedHosts) {
        return new ApacheHttpClient(new TransportFactoryConfiguration(proxyHost, proxyPort.intValue(), proxyUser, proxyPassword, byPassedHosts));
    }

    public static HttpClient initialiseTransportFactory(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String ... byPassedHosts) {
        ArrayList<String> noProxyHosts = new ArrayList<String>();
        for (String host : byPassedHosts) {
            noProxyHosts.add(host);
        }
        return new ApacheHttpClient(new TransportFactoryConfiguration(proxyHost, proxyPort.intValue(), proxyUser, proxyPassword, noProxyHosts));
    }

    public static HttpClient initialiseTransportFactory(ProxyConfiguration proxyConfig) {
        return TransportFactoryInitializer.initialiseTransportFactory(proxyConfig, 15);
    }

    public static HttpClient initialiseTransportFactory(ProxyConfiguration proxyConfig, int maxConnectionsPerHost) {
        TransportFactoryConfiguration conf = proxyConfig != null ? new TransportFactoryConfiguration(proxyConfig.getProxyHost(), proxyConfig.getProxyPort(), proxyConfig.getUsername(), proxyConfig.getPassword(), proxyConfig.getProxyExceptions()) : new TransportFactoryConfiguration();
        conf.setMaxConnectionsPerHost(maxConnectionsPerHost);
        LDAPSocketFactory.configure(proxyConfig);
        ApacheHttpClient factory = new ApacheHttpClient(conf);
        return factory;
    }

    public static HttpClient initialiseTracingTransportFactory(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String byPassedHostsString) {
        return TransportFactoryInitializer.initialiseTracingTransportFactory(proxyHost, proxyPort, proxyUser, proxyPassword, byPassedHostsString, false);
    }

    public static HttpClient initialiseTracingTransportFactory(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, List<String> byPassedHosts) {
        return TransportFactoryInitializer.initialiseTracingTransportFactory(proxyHost, proxyPort, proxyUser, proxyPassword, byPassedHosts, false);
    }

    public static HttpClient initialiseTracingTransportFactory(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String ... byPassedHosts) {
        return TransportFactoryInitializer.initialiseTracingTransportFactory(false, proxyHost, proxyPort, proxyUser, proxyPassword, byPassedHosts);
    }

    public static HttpClient initialiseTracingTransportFactory(ProxyConfiguration proxyConfig) {
        return TransportFactoryInitializer.initialiseTracingTransportFactory(proxyConfig, false);
    }

    public static HttpClient initialiseTracingTransportFactory(ProxyConfiguration proxyConfig, int maxConnectionsPerHost) {
        return TransportFactoryInitializer.initialiseTracingTransportFactory(proxyConfig, maxConnectionsPerHost, false);
    }

    public static HttpClient initialiseTracingTransportFactory(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String byPassedHostsString, boolean keepSpan) {
        ArrayList<String> noProxyHosts = new ArrayList<String>();
        for (String host : byPassedHostsString.split(";")) {
            noProxyHosts.add(host);
        }
        return new TracingApacheHttpClient(new TransportFactoryConfiguration(proxyHost, proxyPort.intValue(), proxyUser, proxyPassword, noProxyHosts), keepSpan);
    }

    public static HttpClient initialiseTracingTransportFactory(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, List<String> byPassedHosts, boolean keepSpan) {
        return new TracingApacheHttpClient(new TransportFactoryConfiguration(proxyHost, proxyPort.intValue(), proxyUser, proxyPassword, byPassedHosts), keepSpan);
    }

    public static HttpClient initialiseTracingTransportFactory(boolean keepSpan, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String ... byPassedHosts) {
        ArrayList<String> noProxyHosts = new ArrayList<String>();
        for (String host : byPassedHosts) {
            noProxyHosts.add(host);
        }
        return new TracingApacheHttpClient(new TransportFactoryConfiguration(proxyHost, proxyPort.intValue(), proxyUser, proxyPassword, noProxyHosts), keepSpan);
    }

    public static HttpClient initialiseTracingTransportFactory(ProxyConfiguration proxyConfig, boolean keepSpan) {
        return TransportFactoryInitializer.initialiseTracingTransportFactory(proxyConfig, 15, keepSpan);
    }

    public static HttpClient initialiseTracingTransportFactory(ProxyConfiguration proxyConfig, int maxConnectionsPerHost, boolean keepSpan) {
        TransportFactoryConfiguration conf = proxyConfig != null ? new TransportFactoryConfiguration(proxyConfig.getProxyHost(), proxyConfig.getProxyPort(), proxyConfig.getUsername(), proxyConfig.getPassword(), proxyConfig.getProxyExceptions()) : new TransportFactoryConfiguration();
        conf.setMaxConnectionsPerHost(maxConnectionsPerHost);
        LDAPSocketFactory.configure(proxyConfig);
        TracingApacheHttpClient factory = new TracingApacheHttpClient(conf, keepSpan);
        return factory;
    }

    public static Hashtable<String, String> getLDAPEnv(ProxyConfiguration proxyConfig) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (LDAPSocketFactory.useLDAPTunnel(proxyConfig)) {
            LOG.info("Configuring LDAP for using LDAPSocketFactory");
            env.put(SOCKET_FACTORY_PROPERTY, LDAPSocketFactory.class.getName());
            LDAPSocketFactory.configure(proxyConfig);
        } else {
            LOG.info("Configuring LDAP for using default socket factory");
            env.put(READ_TIMEOUT_PROPERTY, "3000");
            env.put(CONNECT_TIMEOUT_PROPERTY, "2000");
        }
        return env;
    }
}

