/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.jeebackend.trace.TraceContext;
import de.governikus.csl.transport.ApacheHttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.TransportFactoryConfiguration;
import java.net.URI;
import java.util.Map;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingApacheHttpClient
extends ApacheHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(TracingApacheHttpClient.class);

    public TracingApacheHttpClient(TransportFactoryConfiguration config) {
        super(config);
    }

    public TracingApacheHttpClient(TransportFactoryConfiguration config, boolean keepSpan) {
        super(config);
        config.setKeepSpan(true);
    }

    @Override
    protected void addHeader(HttpUriRequest request, HttpHeader[] headers, URI uri) {
        boolean hasTraceparent = false;
        if (headers != null) {
            for (HttpHeader header : headers) {
                String name = header.getName();
                request.addHeader(name, header.getValue());
                if (!"traceparent".equalsIgnoreCase(name)) continue;
                hasTraceparent = true;
            }
        }
        if (this.defaultHeader != null) {
            for (Map.Entry entry : this.defaultHeader.entrySet()) {
                String name = (String)entry.getKey();
                request.addHeader(name, (String)entry.getValue());
                if (!"traceparent".equalsIgnoreCase(name)) continue;
                hasTraceparent = true;
            }
        }
        if (!hasTraceparent) {
            this.addTraceHeaders(request, uri);
        }
    }

    private void addTraceHeaders(HttpUriRequest request, URI uri) {
        TraceContext traceContext = TraceContext.restore();
        String traceId = traceContext.getTraceId();
        boolean restoreFail = false;
        restoreFail = traceId == null;
        if (restoreFail) {
            traceContext = new TraceContext();
            traceId = traceContext.traceId;
            LOG.trace("Generated new trace context for request to {}", (Object)uri);
        }
        String spanId = traceContext.spanId;
        if (!this.config.isKeepSpan()) {
            spanId = TraceContext.generateRandomSpanId();
            LOG.trace("Opening new span {}-{} to {}", new Object[]{traceId, spanId, uri});
        } else if (!restoreFail) {
            LOG.trace("Extending span {}-{} to {}", new Object[]{traceId, spanId, uri});
        } else {
            LOG.trace("Fallback to openening new span {}-{} to {}", new Object[]{traceId, spanId, uri});
        }
        request.addHeader("traceparent", TraceContext.generateTraceparent((String)traceId, (String)spanId));
        String tracestate = traceContext.getTracestate();
        if (tracestate != null) {
            request.addHeader("tracestate", tracestate);
        }
    }
}

