/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.transport.EmptyCredentials;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import javax.net.SocketFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.ProxyClient;

public class LDAPSocketFactory
extends SocketFactory {
    private static final LDAPSocketFactory DEFAULT = new LDAPSocketFactory();
    private static CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    private static RequestConfig defaultRequestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setProxyPreferredAuthSchemes(Arrays.asList("Basic", "NTLM")).setSocketTimeout(3000).setConnectTimeout(2000).build();
    private static String proxyHost = null;
    private static Integer proxyPort = null;

    public static SocketFactory getDefault() {
        return DEFAULT;
    }

    public static boolean useLDAPTunnel(ProxyConfiguration proxyDto) {
        return proxyDto != null && proxyDto.getProxyHost() != null && !proxyDto.getProxyHost().isEmpty() && proxyDto.isLDAPProxy();
    }

    public static void configure(ProxyConfiguration proxyDto) {
        if (LDAPSocketFactory.useLDAPTunnel(proxyDto)) {
            proxyHost = proxyDto.getProxyHost();
            proxyPort = proxyDto.getProxyPort();
            String username = proxyDto.getUsername();
            if (username != null && !username.isEmpty()) {
                String[] split = username.split("\\\\");
                if (split.length == 2) {
                    credentialsProvider.setCredentials(new AuthScope(proxyDto.getProxyHost(), proxyDto.getProxyPort()), (Credentials)new NTCredentials(split[1], proxyDto.getPassword(), "", split[0]));
                } else {
                    credentialsProvider.setCredentials(new AuthScope(proxyDto.getProxyHost(), proxyDto.getProxyPort()), (Credentials)new UsernamePasswordCredentials(username, proxyDto.getPassword()));
                }
            } else {
                credentialsProvider.setCredentials(new AuthScope(proxyDto.getProxyHost(), proxyDto.getProxyPort()), (Credentials)new EmptyCredentials());
            }
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        if (proxyHost == null || proxyHost.isEmpty()) {
            return SocketFactory.getDefault().createSocket(host, port);
        }
        HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
        HttpHost target = null;
        if (host != null) {
            target = new HttpHost(host, port);
        }
        ProxyClient proxyClient = new ProxyClient(defaultRequestConfig);
        Socket socket = null;
        try {
            socket = proxyClient.tunnel(proxy, target, credentialsProvider.getCredentials(new AuthScope(proxy)));
        }
        catch (HttpException e) {
            throw new IOException(e);
        }
        return socket;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.createSocket((String)null, 0);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return null;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return null;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return null;
    }

    private LDAPSocketFactory() {
    }
}

