/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.util.EntityUtils;

public class ApacheHttpResponse
implements HttpResponse {
    private CloseableHttpResponse delegate;
    private HttpEntity entity;

    public ApacheHttpResponse(CloseableHttpResponse response) {
        this.delegate = response;
        this.entity = response.getEntity();
    }

    public void close() throws IOException {
        HttpClientUtils.closeQuietly((CloseableHttpResponse)this.delegate);
    }

    public InputStream getContent() throws IOException {
        if (this.entity != null) {
            return this.entity.getContent();
        }
        return null;
    }

    public String getContentType() {
        Header contentType;
        if (this.entity != null && (contentType = this.entity.getContentType()) != null) {
            return contentType.getValue();
        }
        return null;
    }

    public String getContentEncoding() {
        Header contentType;
        if (this.entity != null && (contentType = this.entity.getContentEncoding()) != null) {
            return contentType.getValue();
        }
        return null;
    }

    public int getStatus() {
        StatusLine statusLine = this.delegate.getStatusLine();
        if (statusLine != null) {
            return statusLine.getStatusCode();
        }
        return -1;
    }

    public String getStatusReason() {
        StatusLine statusLine = this.delegate.getStatusLine();
        if (statusLine != null) {
            return statusLine.getReasonPhrase();
        }
        return null;
    }

    public List<HttpHeader> getHeader() {
        Header[] allHeaders = this.delegate.getAllHeaders();
        if (allHeaders == null) {
            return Collections.emptyList();
        }
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>(allHeaders.length);
        for (Header h : allHeaders) {
            headers.add(new HttpHeader(h.getName(), h.getValue()));
        }
        return headers;
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public void consumeContent() throws IOException {
        EntityUtils.consume((HttpEntity)this.entity);
    }

    public void consumeContentQuietly() {
        EntityUtils.consumeQuietly((HttpEntity)this.entity);
    }
}

