/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.transport.AbstractHttpClient;
import de.governikus.csl.transport.AcceptAllTrustStrategy;
import de.governikus.csl.transport.ApacheHttpEntityFacade;
import de.governikus.csl.transport.ApacheHttpResponse;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.TransportFactoryConfiguration;
import de.governikus.csl.transport.TrustedCertHostnameVerifier;
import de.governikus.csl.transport.TrustedCertTrustStrategy;
import de.governikus.csl.transport.exception.ConnectionException;
import de.governikus.csl.transport.proxy.ProxyExceptionsResolver;
import de.governikus.csl.transport.util.ApacheHttpClientBuilder;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClient
extends AbstractHttpClient {
    private static final int MAX_CONNECTIONS = 16384;
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpClient.class);
    protected CloseableHttpClient httpclient;
    protected TransportFactoryConfiguration config;
    private final List<String> proxyAuthPrefs;
    private HttpHost proxy;
    private BasicCredentialsProvider proxyCredsProvider;
    private ProxyExceptionsResolver proxyExceptionResolver = new ProxyExceptionsResolver();

    public ApacheHttpClient(TransportFactoryConfiguration config) {
        this(config, null, null);
    }

    public ApacheHttpClient(TransportFactoryConfiguration config, HttpRequestInterceptor requestInterceptor, HttpResponseInterceptor responseInterceptor) {
        this.config = config;
        this.proxyAuthPrefs = new ArrayList<String>();
        this.proxyAuthPrefs.add("Basic");
        this.proxyAuthPrefs.add("NTLM");
        SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
        Object hostNameVerifier = new DefaultHostnameVerifier();
        if (!config.getTrustedServerCerts().isEmpty()) {
            LOG.debug("trying to add trusted certificate(s)");
            try {
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustedCertTrustStrategy(config.getTrustedServerCerts()));
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                LOG.error("Couldn't add trusted certificates", (Throwable)e);
            }
            hostNameVerifier = new TrustedCertHostnameVerifier(config.getTrustedServerCerts());
        } else if (config.isAcceptAllSSLServerCertificates()) {
            LOG.warn("All server certificates are accepted for ssl connections. This is a security breach");
            try {
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new AcceptAllTrustStrategy());
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                LOG.error("Couldn't add AcceptAllTrustStrategy", (Throwable)e);
            }
            hostNameVerifier = new NoopHostnameVerifier();
        }
        KeyStore clientKeystore = config.getClientKeystore();
        if (clientKeystore != null) {
            LOG.debug("trying to add keymaterial");
            try {
                String clientKeyAlias;
                PrivateKeyStrategy keySelector = null;
                char[] keyPw = null;
                String clientKeyPassword = config.getClientKeyPassword();
                if (clientKeyPassword != null) {
                    keyPw = clientKeyPassword.toCharArray();
                }
                if ((clientKeyAlias = config.getClientKeyAlias()) != null) {
                    keySelector = (x, y) -> clientKeyAlias;
                }
                sslContextBuilder.loadKeyMaterial(clientKeystore, keyPw, keySelector);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                LOG.error("Couldn't add keymaterial", (Throwable)e);
            }
        }
        SSLContext sslContext = null;
        try {
            sslContext = sslContextBuilder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LOG.error("Couldnt' create SSLContex", (Throwable)e);
        }
        ProxyConfiguration proxyConfiguration = config.getProxyConfiguration();
        if (proxyConfiguration != null) {
            this.prepareProxySettings(proxyConfiguration);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostNameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(16384);
        connManager.setDefaultMaxPerRoute(config.getMaxConnectionsPerHost());
        UserTokenHandler userTokenHandler = new UserTokenHandler(){

            public Object getUserToken(HttpContext context) {
                return null;
            }
        };
        HttpClientBuilder builder = HttpClients.custom().disableAutomaticRetries().setDefaultCredentialsProvider((CredentialsProvider)this.proxyCredsProvider).setUserTokenHandler(userTokenHandler).setConnectionManager((HttpClientConnectionManager)connManager).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setConnectionManagerShared(config.isConnectionManagerShared());
        if (requestInterceptor != null) {
            builder.addInterceptorFirst(requestInterceptor);
        }
        if (responseInterceptor != null) {
            builder.addInterceptorLast(responseInterceptor);
        }
        this.httpclient = builder.build();
    }

    private void prepareProxySettings(ProxyConfiguration proxyConfiguration) {
        List proxyExceptions;
        String proxyHost = proxyConfiguration.getProxyHost();
        if (proxyHost == null || proxyHost.isEmpty()) {
            return;
        }
        int proxyPort = proxyConfiguration.getProxyPort();
        this.proxy = new HttpHost(proxyHost, proxyPort);
        String proxyUser = proxyConfiguration.getUsername();
        String proxyPassword = proxyConfiguration.getPassword();
        if (proxyUser != null) {
            this.proxyCredsProvider = new BasicCredentialsProvider();
            this.proxyCredsProvider.setCredentials(new AuthScope(proxyHost, proxyPort, AuthScope.ANY_REALM, "Basic"), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            this.proxyCredsProvider.setCredentials(new AuthScope(proxyHost, proxyPort, AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(proxyUser, proxyPassword, null, null));
        }
        if ((proxyExceptions = proxyConfiguration.getProxyExceptions()) != null && !proxyExceptions.isEmpty()) {
            this.proxyExceptionResolver.addProxyExceptions(proxyExceptions);
        }
    }

    private boolean useProxy(URI url) {
        return this.proxy != null && this.proxyExceptionResolver.isProxyRequired(url.getHost());
    }

    private RequestConfig getRequestConfig(URI url) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(this.config.getConnectionManagerTimeout()).setConnectTimeout(this.config.getConnectionTimeout()).setSocketTimeout(this.config.getSocketTimeout());
        if (this.useProxy(url)) {
            requestConfigBuilder.setProxy(this.proxy).setProxyPreferredAuthSchemes(this.proxyAuthPrefs);
        }
        return requestConfigBuilder.build();
    }

    private HttpClientContext createContextAndTriggerProxyAuthentication(URI uri) throws ConnectionException {
        HttpClientContext context = null;
        if (this.proxyCredsProvider == null || "https".equals(uri.getScheme()) || !this.useProxy(uri)) {
            LOG.trace("Omitting to trigger GET for a proxy authentication!");
            return context;
        }
        CloseableHttpResponse getResponse = null;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Issuing GET to trigger proxy authentication for proxy {}", (Object)this.proxy.toURI());
            }
            context = HttpClientContext.create();
            context.setCredentialsProvider((CredentialsProvider)this.proxyCredsProvider);
            HttpGet getRequest = new HttpGet(uri);
            getRequest.setConfig(this.getRequestConfig(uri));
            getResponse = this.httpclient.execute((HttpUriRequest)getRequest, (HttpContext)context);
            HttpClientContext httpClientContext = context;
            return httpClientContext;
        }
        catch (IOException e) {
            throw new ConnectionException("Can't establish connection to " + uri.toString() + " using proxy server " + this.proxy.toString(), (Throwable)e);
        }
        finally {
            if (getResponse != null) {
                try {
                    getResponse.close();
                }
                catch (IOException e) {
                    throw new ConnectionException("Can't close authentication response for proxy server " + this.proxy.toString(), (Throwable)e);
                }
            }
        }
    }

    void closeClientContext(HttpClientContext context, URI uri) throws ConnectionException {
        if (context != null) {
            try {
                context.getConnection().close();
            }
            catch (IOException e) {
                throw new ConnectionException("Can't close HttpConnection to " + uri.toString(), (Throwable)e);
            }
        }
    }

    public HttpResponse delete(URI uri, HttpHeader ... headers) throws ConnectionException {
        HttpDelete request = new HttpDelete(uri);
        request.setConfig(this.getRequestConfig(uri));
        this.addHeader((HttpUriRequest)request, headers, uri);
        return this.execute(uri, (HttpRequestBase)request);
    }

    public HttpResponse post(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        HttpClientContext context = this.createContextAndTriggerProxyAuthentication(uri);
        HttpPost request = new HttpPost(uri);
        request.setConfig(this.getRequestConfig(uri));
        Optional.ofNullable(entity).map(ApacheHttpEntityFacade::new).ifPresent(arg_0 -> ((HttpPost)request).setEntity(arg_0));
        this.addHeader((HttpUriRequest)request, headers, uri);
        return this.execute(uri, context, (HttpRequestBase)request);
    }

    public HttpResponse put(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        HttpClientContext context = this.createContextAndTriggerProxyAuthentication(uri);
        HttpPut request = new HttpPut(uri);
        request.setConfig(this.getRequestConfig(uri));
        Optional.ofNullable(entity).map(ApacheHttpEntityFacade::new).ifPresent(arg_0 -> ((HttpPut)request).setEntity(arg_0));
        this.addHeader((HttpUriRequest)request, headers, uri);
        return this.execute(uri, context, (HttpRequestBase)request);
    }

    public HttpResponse get(URI uri, HttpHeader ... headers) throws ConnectionException {
        HttpGet request = new HttpGet(uri);
        request.setConfig(this.getRequestConfig(uri));
        this.addHeader((HttpUriRequest)request, headers, uri);
        return this.execute(uri, (HttpRequestBase)request);
    }

    private HttpResponse execute(URI uri, HttpRequestBase request) throws ConnectionException {
        try {
            LOG.debug("Send {}", (Object)request);
            CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)request);
            return new ApacheHttpResponse(response);
        }
        catch (IOException e) {
            throw new ConnectionException(uri, (Throwable)e);
        }
    }

    private HttpResponse execute(URI uri, HttpClientContext context, HttpRequestBase request) throws ConnectionException {
        try {
            LOG.debug("Send {}", (Object)request);
            CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)request, (HttpContext)context);
            return new ApacheHttpResponse(response);
        }
        catch (IOException e) {
            throw new ConnectionException(uri, (Throwable)e);
        }
    }

    public void close() throws IOException {
        this.httpclient.close();
    }

    protected void addHeader(HttpUriRequest request, HttpHeader[] headers, URI uri) {
        if (headers != null) {
            for (HttpHeader header : headers) {
                request.addHeader(header.getName(), header.getValue());
            }
        }
        if (this.defaultHeader != null) {
            for (Map.Entry entry : this.defaultHeader.entrySet()) {
                request.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public HttpClient getHttpClient() {
        return this.httpclient;
    }

    public static ApacheHttpClientBuilder builder() {
        return new ApacheHttpClientBuilder();
    }
}

