/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.server;

import de.bos_bremen.ecard.client.CommonsUrlConnector;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.governikus.csl.server.PacProxySelector;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyServer
implements ProxyConfiguration {
    private static final Logger LOG = LogManager.getLogger(ProxyServer.class);
    private String proxyHost;
    private String proxyPort;
    private String username;
    private char[] password;
    private String noProxyHost;
    private String autoConfigUrl;

    public void setHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setPort(String proxyPort) {
        if (proxyPort == null) {
            return;
        }
        if (proxyPort.contains("@PROXY_PORT@")) {
            return;
        }
        this.proxyPort = proxyPort;
    }

    public String getUsername() {
        return this.username == null ? "" : this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setPasswordFromConfig(String password) {
        if (password == null) {
            return;
        }
        if (password.isEmpty()) {
            this.setPassword(null);
            return;
        }
        String proxyPasswordStr = new String(Base64.getDecoder().decode(password), StandardCharsets.UTF_8);
        this.setPassword(proxyPasswordStr.toCharArray());
    }

    public String getNoProxyHost() {
        return this.noProxyHost == null ? "" : this.noProxyHost;
    }

    public void setNoProxyHost(String noProxyHost) {
        if (noProxyHost == null) {
            return;
        }
        this.noProxyHost = noProxyHost;
    }

    public String getAutoConfigUrl() {
        return this.autoConfigUrl == null ? "" : this.autoConfigUrl;
    }

    public void setAutoConfigUrl(String autoConfigUrl) {
        this.autoConfigUrl = autoConfigUrl;
    }

    public XMLProperties getXMLProperties() {
        XMLProperties props = new XMLProperties();
        boolean isValid = this.isValid();
        props.setProperty("host", isValid ? this.getProxyHost() : "");
        props.setProperty("port", isValid ? this.getProxyPortAsString() : "");
        props.setProperty("user", isValid ? this.getUsername() : "");
        props.setProperty("password", this.password != null ? Base64.getEncoder().encodeToString(this.getPassword().getBytes(StandardCharsets.UTF_8)) : "");
        props.setProperty("nonProxyHosts", isValid ? this.getNoProxyHost() : "");
        props.setProperty("autoConfigUrl", this.getAutoConfigUrl());
        return props;
    }

    public boolean isValid() {
        LOG.trace("isValid ... : proxy {}:{}", (Object)this.proxyHost, (Object)this.proxyPort);
        if (this.proxyHost == null || this.proxyHost.trim().isEmpty()) {
            return false;
        }
        if (this.proxyPort == null || this.proxyPort.trim().isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(this.proxyPort);
            LOG.trace("isValid : true");
            return true;
        }
        catch (NumberFormatException ex) {
            LOG.error(ex.getMessage());
            LOG.trace("isValid : false");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String evalAutoConfigUrl(String validationUrl) {
        LOG.info("URL: {}", (Object)validationUrl);
        LOG.debug("ProxyServer.AutoConfigUrl: ({})", (Object)this.autoConfigUrl);
        if (this.autoConfigUrl == null || this.autoConfigUrl.isEmpty()) {
            LOG.trace("PAC wird nicht verwendet.");
            return null;
        }
        if (validationUrl == null || validationUrl.isEmpty()) {
            LOG.warn("URL ist null: Kann Proxy f\u00fcr URL in PAC nicht suchen.");
            return null;
        }
        try {
            LOG.debug("autoConfigUrl : ({})", (Object)this.autoConfigUrl);
            PacProxySelector pps = PacProxySelector.getInstance(this.autoConfigUrl);
            LOG.debug("select : {}", (Object)validationUrl);
            List<Proxy> proxies = pps.select(new URI(validationUrl));
            Iterator<Proxy> iterator = proxies.iterator();
            while (iterator.hasNext()) {
                Proxy p = iterator.next();
                LOG.trace("Proxy : {}", (Object)p);
                if (p.type() == Proxy.Type.DIRECT) {
                    LOG.trace("DIRECT");
                    this.proxyHost = null;
                    this.proxyPort = null;
                    this.username = null;
                    this.password = null;
                    this.noProxyHost = null;
                } else {
                    LOG.trace("");
                    this.proxyHost = ((InetSocketAddress)p.address()).getHostString();
                    this.proxyPort = Integer.toString(((InetSocketAddress)p.address()).getPort());
                    this.noProxyHost = null;
                    LOG.debug("ProxyServer : ( {}:{} )", (Object)this.proxyHost, (Object)this.proxyPort);
                }
                HttpURLConnection uRLConnection = null;
                try {
                    LOG.info("test connect URL ( {} ) : Proxy ( {} )", (Object)validationUrl, (Object)p);
                    URL url = new URL(validationUrl);
                    uRLConnection = CommonsUrlConnector.setupHTTPConnection(url, p);
                    if (uRLConnection.getResponseCode() != 200) {
                        LOG.warn("connect URL returned: ( {} ) ( {} )", (Object)uRLConnection.getResponseCode(), (Object)uRLConnection.getResponseMessage());
                    } else {
                        LOG.info("connect URL ok : ( {} ) : Proxy ( {} )", (Object)validationUrl, (Object)p);
                        LOG.info("ProxyServer : ( {}:{} )", (Object)this.proxyHost, (Object)this.proxyPort);
                    }
                    String string = null;
                    Utils.closeConnection(uRLConnection);
                    return string;
                }
                catch (Exception e) {
                    LOG.error("test connect URL: failed: ", (Throwable)e);
                }
                finally {
                    Utils.closeConnection(uRLConnection);
                }
            }
            return "Connection to '" + validationUrl + "' failed. Tried proxies: " + proxies;
        }
        catch (Exception e) {
            LOG.error("");
            if (LOG.isDebugEnabled()) {
                LOG.error("Failed to read proxy from autoConfigUrl: ", (Throwable)e);
                return e.toString();
            }
            LOG.error("Failed to read proxy from AutoConfigUrl: ", (Object)e.getMessage());
            return e.toString();
        }
    }

    public List<String> getProxyExceptions() {
        LOG.trace("");
        ArrayList<String> proxyExceptions = new ArrayList<String>();
        if (this.noProxyHost != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.noProxyHost, ";", false);
            while (tokenizer.hasMoreElements()) {
                proxyExceptions.add(tokenizer.nextToken());
            }
        }
        return proxyExceptions;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort == null || this.proxyPort.isEmpty() ? 0 : Integer.parseInt(this.proxyPort);
    }

    public String getProxyPortAsString() {
        return this.proxyPort == null ? "" : this.proxyPort;
    }

    public String getPassword() {
        return this.password == null ? "" : new String(this.password);
    }

    public char[] getPasswordAsArray() {
        return this.password;
    }

    public boolean isNoCacheHeader() {
        return false;
    }

    public boolean isLDAPProxy() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProxyServer)) {
            return false;
        }
        ProxyServer other = (ProxyServer)obj;
        return Objects.equals(this.autoConfigUrl, other.autoConfigUrl) && Objects.equals(this.proxyHost, other.proxyHost) && Objects.equals(this.proxyPort, other.proxyPort) && Objects.equals(this.username, other.username) && Arrays.equals(this.password, other.password);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "ProxyServer[]";
        }
        String indent = "\n  ";
        return "ProxyServer\n[" + indent + "proxyHost=" + this.proxyHost + indent + "proxyPort=" + this.proxyPort + indent + "autoConfigUrl=" + this.autoConfigUrl + indent + "proxyUser=" + (this.username == null || this.username.isEmpty() ? "" : "***") + indent + "proxyPassw=" + (this.getPassword() == null || this.getPassword().isEmpty() ? "" : "***") + "\n]";
    }

    public boolean isEmpty() {
        boolean empty = this.proxyHost == null || this.proxyHost.isEmpty();
        empty = empty && (this.proxyPort == null || this.proxyPort.isEmpty());
        empty = empty && (this.autoConfigUrl == null || this.autoConfigUrl.isEmpty());
        empty = empty && (this.username == null || this.username.isEmpty());
        empty = empty && (this.getPassword() == null || this.getPassword().isEmpty());
        empty = empty && (this.noProxyHost == null || this.noProxyHost.isEmpty());
        return empty;
    }
}

