/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.server;

import com.sun.istack.Nullable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import org.graalvm.polyglot.HostAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacScriptMethods {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PacScriptMethods.class);
    public static final String OVERRIDE_LOCAL_IP = "com.btr.proxy.pac.overrideLocalIP";
    private static final String GMT = "GMT";
    private static final List<String> DAYS = List.of("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT");
    private static final List<String> MONTH = List.of("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC");
    private Calendar currentTime;

    @HostAccess.Export
    public boolean isPlainHostName(String host) {
        return !host.contains(".");
    }

    @HostAccess.Export
    public boolean dnsDomainIs(String host, String domain) {
        return host.endsWith(domain);
    }

    @HostAccess.Export
    public boolean localHostOrDomainIs(String host, String domain) {
        return domain.startsWith(host);
    }

    @HostAccess.Export
    public boolean isResolvable(String host) {
        try {
            InetAddress.getByName(host);
            return true;
        }
        catch (UnknownHostException ex) {
            log.error("Hostname not resolveable : {}", (Object)host);
            return false;
        }
    }

    @HostAccess.Export
    public boolean isInNet(String host, String pattern, String mask) {
        if ((host = this.dnsResolve(host)) == null || host.isEmpty()) {
            return false;
        }
        long lhost = this.parseIpAddressToLong(host);
        long lpattern = this.parseIpAddressToLong(pattern);
        long lmask = this.parseIpAddressToLong(mask);
        return (lhost & lmask) == (lpattern & lmask);
    }

    @HostAccess.Export
    private long parseIpAddressToLong(String address) {
        long result = 0L;
        String[] parts = address.split("\\.");
        long shift = 24L;
        for (String part : parts) {
            long lpart = Long.parseLong(part);
            result |= lpart << (int)shift;
            shift -= 8L;
        }
        return result;
    }

    @HostAccess.Export
    public String dnsResolve(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("DNS name not resolvable : {} ", (Object)host);
            return "";
        }
    }

    @HostAccess.Export
    public int convert_addr(String ipaddr) {
        try {
            InetAddress inetAddress = InetAddress.getByName(ipaddr);
            if (inetAddress instanceof Inet6Address) {
                return 0;
            }
            return ByteBuffer.wrap(inetAddress.getAddress()).getInt();
        }
        catch (UnknownHostException ex) {
            return 0;
        }
    }

    @HostAccess.Export
    public String myIpAddress() {
        try {
            String overrideIP = System.getProperty(OVERRIDE_LOCAL_IP);
            if (overrideIP != null && !overrideIP.trim().isEmpty()) {
                return overrideIP.trim();
            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("Local address not resolvable.");
            return "";
        }
    }

    @HostAccess.Export
    public int dnsDomainLevels(String host) {
        int count = 0;
        int startPos = 0;
        while ((startPos = host.indexOf(".", startPos + 1)) > -1) {
            ++count;
        }
        return count;
    }

    @HostAccess.Export
    public boolean shExpMatch(String str, String shexp) {
        StringTokenizer tokenizer = new StringTokenizer(shexp, "*");
        int startPos = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int temp = str.indexOf(token, startPos);
            if (temp == -1) {
                return false;
            }
            startPos = temp + token.length();
        }
        return true;
    }

    @HostAccess.Export
    public boolean weekdayRange(String wd1, String wd2, @Nullable String gmt) {
        int to;
        boolean useGmt = GMT.equalsIgnoreCase(wd2) || GMT.equalsIgnoreCase(gmt);
        Calendar cal = this.getCurrentTime(useGmt);
        int currentDay = cal.get(7) - 1;
        int from = DAYS.indexOf(wd1.toUpperCase());
        int n = to = wd2 == null ? -1 : DAYS.indexOf(wd2.toUpperCase());
        if (to == -1) {
            to = from;
        }
        if (to < from) {
            return currentDay >= from || currentDay <= to;
        }
        return currentDay >= from && currentDay <= to;
    }

    @HostAccess.Export
    public void setCurrentTime(Calendar cal) {
        this.currentTime = cal;
    }

    @HostAccess.Export
    private Calendar getCurrentTime(boolean useGmt) {
        if (this.currentTime != null) {
            return (Calendar)this.currentTime.clone();
        }
        return Calendar.getInstance(useGmt ? TimeZone.getTimeZone(GMT) : TimeZone.getDefault());
    }

    @HostAccess.Export
    public boolean dateRange(Object day1, Object month1, Object year1, Object day2, Object month2, Object year2, Object gmt) {
        Date to;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        this.parseDateParam(params, day1);
        this.parseDateParam(params, month1);
        this.parseDateParam(params, year1);
        this.parseDateParam(params, day2);
        this.parseDateParam(params, month2);
        this.parseDateParam(params, year2);
        this.parseDateParam(params, gmt);
        boolean useGmt = params.get("gmt") != null;
        Calendar cal = this.getCurrentTime(useGmt);
        Date current = cal.getTime();
        if (params.get("day1") != null) {
            cal.set(5, (Integer)params.get("day1"));
        }
        if (params.get("month1") != null) {
            cal.set(2, (Integer)params.get("month1"));
        }
        if (params.get("year1") != null) {
            cal.set(1, (Integer)params.get("year1"));
        }
        Date from = cal.getTime();
        if (params.get("day2") != null) {
            cal.set(5, (Integer)params.get("day2"));
        }
        if (params.get("month2") != null) {
            cal.set(2, (Integer)params.get("month2"));
        }
        if (params.get("year2") != null) {
            cal.set(1, (Integer)params.get("year2"));
        }
        if ((to = cal.getTime()).before(from)) {
            cal.add(2, 1);
            to = cal.getTime();
        }
        if (to.before(from)) {
            cal.add(1, 1);
            cal.add(2, -1);
            to = cal.getTime();
        }
        return current.compareTo(from) >= 0 && current.compareTo(to) <= 0;
    }

    @HostAccess.Export
    private void parseDateParam(Map<String, Integer> params, Object value) {
        String stringValue;
        int n;
        if (value instanceof Number) {
            Number number = (Number)value;
            n = number.intValue();
            if (n <= 31) {
                if (params.get("day1") == null) {
                    params.put("day1", n);
                } else {
                    params.put("day2", n);
                }
            } else if (params.get("year1") == null) {
                params.put("year1", n);
            } else {
                params.put("year2", n);
            }
        }
        if (value instanceof String && (n = MONTH.indexOf((stringValue = (String)value).toUpperCase())) > -1) {
            if (params.get("month1") == null) {
                params.put("month1", n);
            } else {
                params.put("month2", n);
            }
        }
        if (GMT.equalsIgnoreCase(String.valueOf(value))) {
            params.put("gmt", 1);
        }
    }

    @HostAccess.Export
    public boolean timeRange(Object hour1, Object min1, Object sec1, Object hour2, Object min2, Object sec2, Object gmt) {
        Date to;
        Date from;
        boolean useGmt = GMT.equalsIgnoreCase(String.valueOf(min1)) || GMT.equalsIgnoreCase(String.valueOf(sec1)) || GMT.equalsIgnoreCase(String.valueOf(min2)) || GMT.equalsIgnoreCase(String.valueOf(gmt));
        Calendar cal = this.getCurrentTime(useGmt);
        cal.set(14, 0);
        Date current = cal.getTime();
        if (sec2 instanceof Number) {
            Number sec2Numver = (Number)sec2;
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, ((Number)min1).intValue());
            cal.set(13, ((Number)sec1).intValue());
            from = cal.getTime();
            cal.set(11, ((Number)hour2).intValue());
            cal.set(12, ((Number)min2).intValue());
            cal.set(13, sec2Numver.intValue());
            to = cal.getTime();
        } else if (hour2 instanceof Number) {
            Number hour2Number = (Number)hour2;
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, ((Number)min1).intValue());
            cal.set(13, 0);
            from = cal.getTime();
            cal.set(11, ((Number)sec1).intValue());
            cal.set(12, hour2Number.intValue());
            cal.set(13, 59);
            to = cal.getTime();
        } else if (min1 instanceof Number) {
            Number min1Number = (Number)min1;
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, 0);
            cal.set(13, 0);
            from = cal.getTime();
            cal.set(11, min1Number.intValue());
            cal.set(12, 59);
            cal.set(13, 59);
            to = cal.getTime();
        } else {
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, 0);
            cal.set(13, 0);
            from = cal.getTime();
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, 59);
            cal.set(13, 59);
            to = cal.getTime();
        }
        if (to.before(from)) {
            cal.setTime(to);
            cal.add(5, 1);
            to = cal.getTime();
        }
        return current.compareTo(from) >= 0 && current.compareTo(to) <= 0;
    }

    @HostAccess.Export
    public void alert(String message) {
        log.info(message);
    }

    @HostAccess.Export
    public boolean isResolvableEx(String host) {
        return this.isResolvable(host);
    }

    @HostAccess.Export
    public boolean isInNetEx(String ipAddress, String ipPrefix) {
        try {
            InetAddress inetAddress = InetAddress.getByName(ipAddress);
            InetAddress maskAddress = InetAddress.getByName(ipPrefix.split("/")[0]);
            int nMaskBits = Integer.parseInt(ipPrefix.split("/")[1]);
            if (inetAddress.getAddress().length * 8 < nMaskBits) {
                return false;
            }
            if (!inetAddress.getClass().equals(maskAddress.getClass())) {
                return false;
            }
            if (nMaskBits < 0) {
                return inetAddress.equals(maskAddress);
            }
            byte[] inetAddr = inetAddress.getAddress();
            byte[] maskAddr = maskAddress.getAddress();
            int nMaskFullBytes = nMaskBits / 8;
            byte finalByte = (byte)(65280 >> (nMaskBits & 7));
            for (int i = 0; i < nMaskFullBytes; ++i) {
                if (maskAddr[i] == inetAddr[i]) continue;
                return false;
            }
            if (finalByte != 0) {
                return (inetAddr[nMaskFullBytes] & finalByte) == (maskAddr[nMaskFullBytes] & finalByte);
            }
            return true;
        }
        catch (IndexOutOfBoundsException | NumberFormatException | UnknownHostException ex) {
            return false;
        }
    }

    public String dnsResolveEx(String host) {
        try {
            InetAddress[] list = InetAddress.getAllByName(host);
            return Arrays.stream(list).map(InetAddress::getHostAddress).collect(Collectors.joining(";"));
        }
        catch (UnknownHostException e) {
            log.error("DNS name not resolvable " + host);
            return "";
        }
    }

    @HostAccess.Export
    public String myIpAddressEx() {
        String overrideIP = System.getProperty(OVERRIDE_LOCAL_IP);
        if (overrideIP != null && !overrideIP.trim().isEmpty()) {
            return overrideIP.trim();
        }
        return this.dnsResolveEx("localhost");
    }

    @HostAccess.Export
    public String sortIpAddressList(String ipAddressList) {
        if (ipAddressList == null || ipAddressList.trim().isEmpty()) {
            return "";
        }
        ArrayList<String> addresses = new ArrayList<String>(List.of(ipAddressList.split(";")));
        addresses.sort((o1, o2) -> {
            try {
                InetAddress addr1 = InetAddress.getByName(o1);
                InetAddress addr2 = InetAddress.getByName(o2);
                if (addr1.getClass().equals(addr2.getClass())) {
                    return Arrays.compare(addr1.getAddress(), addr2.getAddress());
                }
                return addr1 instanceof Inet6Address ? -1 : 1;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        });
        return String.join((CharSequence)";", addresses);
    }

    @HostAccess.Export
    public String getClientVersion() {
        return "1.0";
    }
}

