/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.server;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.util.Entry;
import de.bos_bremen.ecard.client.util.Reg;
import de.governikus.csl.server.PacScriptMethods;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacProxySelector
extends ProxySelector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PacProxySelector.class);
    private static final String PAC_SOCKS = Proxy.Type.SOCKS.name();
    private static final String PAC_DIRECT = Proxy.Type.DIRECT.name();
    private static final String SCRIPT_METHODS_OBJECT = "__pacutil";
    private static String pacScriptContent = null;
    private final Context context;
    private static PacProxySelector INSTANCE;

    public static synchronized PacProxySelector getInstance(String pacUrl) {
        block5: {
            if (INSTANCE == null) {
                log.info("INSTANCE ist null");
                try {
                    if (pacUrl == null || pacUrl.isEmpty()) {
                        INSTANCE = new PacProxySelector();
                        break block5;
                    }
                    INSTANCE = new PacProxySelector(pacUrl);
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            } else {
                log.info("INSTANCE ist vorhanden");
            }
        }
        return INSTANCE;
    }

    private PacProxySelector() throws IOException {
        log.debug("Trying to use PacProxySelector for proxy handling.");
        this.context = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.EXPLICIT).option("engine.WarnInterpreterOnly", "false").build();
        PacProxySelector.setupEngine(this.context);
        String httpProxyAutoConfig = System.getProperty("http.proxy.auto.config");
        boolean isSetAutoConfig = httpProxyAutoConfig != null && !httpProxyAutoConfig.isEmpty();
        try {
            String path = null;
            if (isSetAutoConfig) {
                log.info("System.getProperty(http.proxy.auto.config) ist vorhanden: {}", (Object)httpProxyAutoConfig);
                path = httpProxyAutoConfig;
            } else {
                log.info("System.getProperty(http.proxy.auto.config) ist nicht vorhanden.");
                String regPath = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
                String key = "AutoConfigURL";
                List<Entry> pacEntries = Reg.query(regPath, key);
                String string = path = pacEntries != null && !pacEntries.isEmpty() ? (String)pacEntries.get((int)0).value : null;
                if (path == null) {
                    throw new IOException("No AutoConfigURL for pac file found.");
                }
                log.debug("AutoConfigURL: {}", (Object)path);
            }
            pacScriptContent = PacProxySelector.readFile(path);
            System.setProperty("http.proxy.auto.config", path);
            log.info("system set : http.proxy.auto.config : {}", (Object)path);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private PacProxySelector(String path) throws IOException {
        log.info("PAC : ({}) ", (Object)path);
        if (path == null || path.isEmpty()) {
            throw new IOException("No PAC path given.");
        }
        this.context = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.EXPLICIT).option("engine.WarnInterpreterOnly", "false").build();
        PacProxySelector.setupEngine(this.context);
        try {
            pacScriptContent = PacProxySelector.readFile(path);
            System.setProperty("http.proxy.auto.config", path);
            log.info("Das Lesen von PAC. System set : http.proxy.auto.config : {}", (Object)path);
        }
        catch (IOException e) {
            log.error("Das Lesen von PAC ({}) ist fehlgeschlagen: {}", (Object)path, (Object)e.getMessage());
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            log.error("Die PAC-URL ({}) ist ung\u00fcltig: {}", (Object)path, (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    private static HttpURLConnection setupHTTPConnection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
        con.setInstanceFollowRedirects(true);
        con.setRequestProperty("accept", "application/x-ns-proxy-autoconfig, */*;q=0.8");
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String path) throws IOException, URISyntaxException {
        String string;
        log.trace("");
        InputStream is = null;
        HttpURLConnection con = null;
        try {
            if (((String)path).startsWith("file:/") || !((String)path).contains(":/")) {
                File file = null;
                if (!((String)path).contains(":/")) {
                    file = new File((String)path);
                } else {
                    try {
                        file = new File(new URL((String)path).toURI());
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("AutoConfigUrl ({}) malformed. try to rewritting url.", path);
                        path = ((String)path).substring(6);
                        while (((String)path).indexOf(47) == 0) {
                            path = ((String)path).substring(1);
                        }
                        path = "file:/" + (String)path;
                        file = new File(new URL((String)path).toURI());
                        log.info("Proxy AutoConfigUrl ({})", path);
                    }
                }
                is = new FileInputStream(file);
            } else {
                URL url = new URL((String)path);
                con = PacProxySelector.setupHTTPConnection(url);
                if (con.getResponseCode() != 200) {
                    log.error("Die PAC-Datei muss ohne Proxy zug\u00e4nglich sein: {}", (Object)url);
                    throw new IOException("Server returned: " + con.getResponseCode() + " " + con.getResponseMessage());
                }
                is = con.getInputStream();
            }
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            log.trace("");
            string = baos.toString(StandardCharsets.ISO_8859_1);
        }
        catch (Throwable throwable) {
            Utils.closeStream(is);
            Utils.closeConnection(con);
            throw throwable;
        }
        Utils.closeStream(is);
        Utils.closeConnection(con);
        return string;
    }

    private static void setupEngine(Context context) throws IOException {
        Method[] scriptMethods;
        context.getBindings("js").putMember(SCRIPT_METHODS_OBJECT, (Object)new PacScriptMethods());
        Class<PacScriptMethods> scriptMethodsClazz = PacScriptMethods.class;
        for (Method method : scriptMethods = scriptMethodsClazz.getMethods()) {
            int i;
            String name = method.getName();
            int args = method.getParameterTypes().length;
            StringBuilder toEval = new StringBuilder(name).append(" = function(");
            for (i = 0; i < args; ++i) {
                if (i > 0) {
                    toEval.append(",");
                }
                toEval.append("arg").append(i);
            }
            toEval.append(") {return ").append(SCRIPT_METHODS_OBJECT).append(".").append(name).append("(");
            for (i = 0; i < args; ++i) {
                if (i > 0) {
                    toEval.append(",");
                }
                toEval.append("arg").append(i);
            }
            toEval.append("); }");
            try {
                context.eval("js", (CharSequence)toEval.toString());
            }
            catch (PolyglotException e) {
                log.error("JS evaluation error when creating alias for {}.", (Object)name, (Object)e);
                throw new IOException("Error setting up script engine", e);
            }
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    @Override
    public List<Proxy> select(URI uri) {
        log.trace("PAC select Proxy for : ({})", (Object)uri);
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null.");
        }
        try {
            String[] proxyDefinitions;
            ArrayList<Proxy> proxies = new ArrayList<Proxy>();
            log.trace("evaluate url...");
            String parseResult = this.evaluate(uri.toString(), uri.getHost());
            log.trace("evaluate done.");
            for (String proxyDef : proxyDefinitions = parseResult.split("[;]")) {
                if (proxyDef.isEmpty()) continue;
                proxies.add(this.buildProxyFromPacResult(proxyDef));
                log.trace("proxy : ({})", (Object)proxyDef);
            }
            return proxies;
        }
        catch (IOException e) {
            log.error("PAC resolving error ({}).", (Object)e.getCause().getMessage(), (Object)e);
            log.error("Using direct connection.");
            return Collections.singletonList(Proxy.NO_PROXY);
        }
    }

    public String evaluate(String url, String host) throws IOException {
        log.debug("URL  : {}", (Object)url);
        log.debug("Host : {}", (Object)host);
        try {
            String script = pacScriptContent + "\n ;FindProxyForURL (\"" + url + "\",\"" + host + "\")";
            Value result = this.context.eval("js", (CharSequence)script);
            log.info("Proxy from PAC ({}) for URL : ({}) : ", (Object)result, (Object)url);
            if (!result.isString()) {
                log.error(String.format("The PAC file returned a non-string value as the proxy for url %s, host %s. Using DIRECT proxy.", url, host));
                log.info("Proxy from PAC : ({}) for URL : ({}) : ", (Object)result, (Object)url);
                return "DIRECT";
            }
            String str = result.asString();
            log.info(str);
            return str;
        }
        catch (Exception e) {
            throw new IOException("Error while executing PAC script", e);
        }
    }

    private Proxy buildProxyFromPacResult(String pacResult) {
        if (pacResult == null || pacResult.trim().length() < 6) {
            return Proxy.NO_PROXY;
        }
        String proxyDef = pacResult.trim();
        if (proxyDef.toUpperCase().startsWith(PAC_DIRECT)) {
            return Proxy.NO_PROXY;
        }
        Proxy.Type type = Proxy.Type.HTTP;
        if (proxyDef.toUpperCase().startsWith(PAC_SOCKS)) {
            type = Proxy.Type.SOCKS;
        }
        String host = proxyDef.substring(6);
        int port = 8080;
        int indexOfPort = host.indexOf(58);
        if (indexOfPort != -1) {
            port = Integer.parseInt(host.substring(indexOfPort + 1).trim());
            host = host.substring(0, indexOfPort).trim();
        }
        InetSocketAddress adr = InetSocketAddress.createUnresolved(host, port);
        return new Proxy(type, adr);
    }
}

