/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.server;

import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class KeycloakDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle res = ResourceBundle.getBundle(KeycloakDialog.class.getName());
    private static final Insets ZERO = new Insets(0, 0, 0, 0);
    private static final Insets NORM = new Insets(10, 10, 10, 10);
    private static final Insets RIGHT = new Insets(10, 5, 10, 10);
    private static final Insets LEFT = new Insets(10, 10, 10, 5);
    private int result = 2;
    private JButton ok;
    private JTextField userName;
    private JPasswordField password;

    public KeycloakDialog(String host) {
        super(Document.getInstance().getFrame());
        this.init(host);
        this.setResizable(false);
    }

    private void init(String host) {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBackground(Color.WHITE);
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(new ButtonBorder());
        int y = 0;
        JComponent p = this.prepareDescriptionView(host);
        contentPane.add((Component)p, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        p = this.prepareInputView();
        contentPane.add((Component)p, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        p = this.prepareOperationsView();
        contentPane.add((Component)p, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        this.prepareFrame();
        this.userName.requestFocusInWindow();
    }

    private JComponent prepareDescriptionView(String host) {
        JPanel p = new JPanel(new GridBagLayout());
        StringBuilder sb = new StringBuilder();
        String s = res.getString("hint.general");
        s = s.replace("HOST", host);
        sb.append(s);
        JTextPane l = new JTextPane();
        l.setText(sb.toString());
        l.getAccessibleContext().setAccessibleDescription(l.getText());
        l.setEditable(false);
        l.setBorder(CurvedBorder.EMPTY_BORDER);
        l.addFocusListener(ComponentUtils.createFocusListenerFor(l));
        p.add((Component)l, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, NORM, 0, 0));
        return p;
    }

    private JComponent prepareInputView() {
        JPanel p = new JPanel(new GridBagLayout());
        int y = 0;
        JLabel l = new JLabel(res.getString("userName.label"));
        p.add((Component)l, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.userName = new JTextField();
        l.setLabelFor(this.userName);
        this.userName.addFocusListener(ComponentUtils.createFocusListenerFor(this.userName));
        DocumentListener userNameDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                KeycloakDialog.this.userNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                KeycloakDialog.this.userNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.userName.getDocument().addDocumentListener(userNameDL);
        this.userName.setColumns(25);
        p.add((Component)this.userName, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, RIGHT, 0, 0));
        l = new JLabel(res.getString("password.label"));
        p.add((Component)l, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.password = new JPasswordField();
        l.setLabelFor(this.password);
        this.password.addFocusListener(ComponentUtils.createFocusListenerFor(this.password));
        DocumentListener passwordDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                KeycloakDialog.this.passwordChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                KeycloakDialog.this.passwordChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.password.getDocument().addDocumentListener(passwordDL);
        this.password.setColumns(25);
        p.add((Component)this.password, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, RIGHT, 0, 0));
        return p;
    }

    private void checkOK() {
        boolean b = this.userName.getDocument().getLength() > 0;
        b = b && this.password.getDocument().getLength() > 0;
        this.ok.setEnabled(b);
    }

    protected void passwordChanged() {
        this.checkOK();
    }

    protected void userNameChanged() {
        this.checkOK();
    }

    private JComponent prepareOperationsView() {
        JPanel operations = new JPanel(new FlowLayout(2, 12, 12));
        this.ok = new JButton(res.getString("button.ok.label"));
        this.ok.setDefaultCapable(true);
        this.ok.setEnabled(false);
        this.ok.addActionListener(e -> this.closeDialog(0));
        operations.add(this.ok);
        JButton cancel = new JButton(res.getString("button.cancel.label"));
        cancel.setDefaultCapable(false);
        cancel.addActionListener(e -> this.closeDialog(2));
        operations.add(cancel);
        return operations;
    }

    private void prepareFrame() {
        this.setIconImages(((Window)this.getParent()).getIconImages());
        this.setTitle(res.getString("dialog.title"));
        this.setDefaultCloseOperation(0);
        this.getRootPane().registerKeyboardAction(e -> this.closeDialog(2), KeyStroke.getKeyStroke(27, 0, false), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                KeycloakDialog.this.closeDialog(2);
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setAlwaysOnTop(true);
        this.getRootPane().setDefaultButton(this.ok);
        this.setModal(true);
    }

    protected void closeDialog(int r) {
        this.result = r;
        this.setVisible(false);
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    public String getUser() {
        return this.userName.getText();
    }

    public char[] getPassword() {
        return this.password.getPassword();
    }

    public static class ButtonBorder
    implements Border {
        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(12, 12, 13, 12);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics graph, int x, int y, int w, int h) {
            Graphics2D g = (Graphics2D)graph;
            g.setColor(Color.WHITE);
            g.setPaint(new GradientPaint(x, y, Color.WHITE, x, (float)y + (float)h, Color.WHITE));
            g.fillRect(x, y, w, h);
            g.setColor(Color.WHITE);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        }
    }
}

