/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.server;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.governikus.csl.VerifyProtocolType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateValidationServer {
    private static final Logger LOG = LogManager.getLogger(CertificateValidationServer.class);
    private String url = null;
    private String defaultCertificateBase64 = null;
    private String certificateBase64 = null;
    private VerifyProtocolType verifyProtocolType = VerifyProtocolType.html;
    private boolean useSpecialProtocolSuffix = false;
    public static final String VALIDATION_PROTOCOL = "_validation-protocol.";

    public CertificateValidationServer() {
    }

    public CertificateValidationServer(XMLProperties props) {
        LOG.trace("");
        String protocolTypeProperties = props.getProperty("protocoltype");
        this.setVerifyProtocolType(VerifyProtocolType.parseValueOf(protocolTypeProperties));
        this.setUseSpecialProtocolSuffix(Boolean.parseBoolean(props.getProperty("useSpecialProtocolSuffix")));
        XMLProperties verifyserverProperties = props.getPropertiesForNode("verificationserver");
        this.setUrl(verifyserverProperties.getProperty("url"));
        this.setDefaultCertificateBase64(verifyserverProperties.getProperty("certificate"));
        this.setCertificateBase64(verifyserverProperties.getProperty("certificate2"));
        LOG.trace("create done : {}", (Object)this);
    }

    public void setUrl(String url) {
        LOG.trace("Model-CVS <- servername {}", (Object)url);
        this.url = url;
    }

    public String getUrl() {
        LOG.trace("Model-CVS -> servername {}", (Object)this.url);
        return this.url;
    }

    public String getDefaultCertificateBase64() {
        LOG.trace("Model-CVS -> aktuel gueltiges Zertifikat");
        return this.defaultCertificateBase64;
    }

    public void setDefaultCertificateBase64(String defaultCertificateBase64) {
        LOG.trace("Model-CVS <- aktuel gueltiges Zertifikat");
        this.defaultCertificateBase64 = defaultCertificateBase64;
    }

    public String getCertificateBase64() {
        LOG.trace("Model-CVS -> alternatives Zertifikat");
        return this.certificateBase64;
    }

    public void setCertificateBase64(String certificateBase64) {
        LOG.trace("Model-CVS <- alternatives Zertifikat");
        this.certificateBase64 = certificateBase64;
    }

    public VerifyProtocolType getVerifyProtocolType() {
        LOG.trace("Model-CVS -> protokoll : {}", (Object)this.verifyProtocolType);
        return this.verifyProtocolType;
    }

    public void setVerifyProtocolType(VerifyProtocolType verifyProtocolType) {
        LOG.trace("Model-CVS <- protokoll : {}", (Object)verifyProtocolType);
        if (verifyProtocolType == null) {
            return;
        }
        this.verifyProtocolType = verifyProtocolType;
    }

    public void setVerifyProtocolType(String value) {
        LOG.trace("Model-CVS <- protokoll : {}", (Object)value);
        if (value == null) {
            return;
        }
        VerifyProtocolType vpt = VerifyProtocolType.parseValueOf(value);
        if (vpt == null) {
            return;
        }
        this.verifyProtocolType = vpt;
    }

    public List<Certificate> getCertificates() {
        ArrayList<Certificate> certificates;
        block15: {
            CertificateFactory certificateFactory;
            ByteArrayInputStream is;
            block14: {
                LOG.trace("");
                certificates = new ArrayList<Certificate>();
                try {
                    if (this.defaultCertificateBase64 == null) break block14;
                    is = new ByteArrayInputStream(Base64.getDecoder().decode(this.defaultCertificateBase64.replaceAll("[\r\n]", "")));
                    try {
                        certificateFactory = CertificateFactory.getInstance("X509", "BC");
                        certificates.add(certificateFactory.generateCertificate(is));
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception ex) {
                    LOG.error("could not parse certificate", (Throwable)ex);
                }
            }
            try {
                if (this.certificateBase64 == null) break block15;
                is = new ByteArrayInputStream(Base64.getDecoder().decode(this.certificateBase64.replaceAll("[\r\n]", "")));
                try {
                    certificateFactory = CertificateFactory.getInstance("X509", "BC");
                    certificates.add(certificateFactory.generateCertificate(is));
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (Exception ex) {
                LOG.error("could not parse certificate", (Throwable)ex);
            }
        }
        return certificates;
    }

    public boolean isConfigComplete() {
        LOG.trace("");
        return Utils.notEmpty(this.url) && !this.getCertificates().isEmpty();
    }

    public String toString() {
        return "\nurl=" + this.url + "\nprotokoll=" + this.verifyProtocolType + "\nuseSpecialProtocolSuffix=" + this.useSpecialProtocolSuffix + "\ncert_1=" + this.defaultCertificateBase64 + "\ncert_2=" + this.certificateBase64 + "\n";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.certificateBase64, this.defaultCertificateBase64, this.url, this.verifyProtocolType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CertificateValidationServer)) {
            return false;
        }
        CertificateValidationServer other = (CertificateValidationServer)obj;
        return Objects.equals(this.certificateBase64, other.certificateBase64) && Objects.equals(this.defaultCertificateBase64, other.defaultCertificateBase64) && Objects.equals(this.url, other.url) && this.verifyProtocolType == other.verifyProtocolType;
    }

    public void setUseSpecialProtocolSuffix(boolean useSpecialProtocollSuffix) {
        this.useSpecialProtocolSuffix = useSpecialProtocollSuffix;
    }

    public boolean isUseSpecialProtocolSuffix() {
        return this.useSpecialProtocolSuffix;
    }

    public String getProtocolSuffix() {
        if (this.useSpecialProtocolSuffix) {
            return VALIDATION_PROTOCOL + this.getVerifyProtocolType().name();
        }
        return "." + this.getVerifyProtocolType().name();
    }
}

