/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.server;

import de.bos_bremen.ecard.client.Utils;
import de.governikus.csl.server.KeycloakDialog;
import java.util.HashMap;
import lombok.Generated;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);
    private String url = null;
    private String authServiceRealm = null;
    private String username = null;
    private String password = null;
    private String client = null;
    private String secret = null;
    private KeycloakDeployment keycloakDeployment = null;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRealm() {
        return this.authServiceRealm;
    }

    public void setRealm(String authServiceRealm) {
        this.authServiceRealm = authServiceRealm;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.keycloakDeployment = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.keycloakDeployment = null;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
        this.keycloakDeployment = null;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
        this.keycloakDeployment = null;
    }

    public KeycloakDeployment getKeycloakDeployment() {
        if (this.isValid() && this.keycloakDeployment != null) {
            return this.keycloakDeployment;
        }
        AdapterConfig ac = new AdapterConfig();
        ac.setRealm(this.authServiceRealm);
        ac.setAuthServerUrl(this.url);
        ac.setResource(this.client);
        HashMap<String, String> creds = new HashMap<String, String>();
        creds.put("secret", this.secret);
        ac.setCredentials(creds);
        this.keycloakDeployment = KeycloakDeploymentBuilder.build((AdapterConfig)ac);
        return this.keycloakDeployment;
    }

    public boolean requestUsernamePassword() {
        KeycloakDialog d = new KeycloakDialog(this.getUrl());
        log.info("Keycloak-Anmeldung: Warte auf Nutzername und Passwort ...");
        d.setVisible(true);
        int result = d.getResult();
        if (result != 0) {
            log.warn("Keycloak-Anmeldung: ist vom Nutzer abgebrochen.");
            return false;
        }
        this.setUsername(d.getUser());
        this.setPassword(String.valueOf(d.getPassword()));
        log.info("Keycloak-Anmeldung: der Nutzer hat Nutzername und Passwort eingegeben.");
        return true;
    }

    public boolean isValid() {
        return Utils.notEmpty(this.client) && Utils.notEmpty(this.secret) && Utils.notEmpty(this.url) && Utils.notEmpty(this.authServiceRealm);
    }
}

