/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.proxy;

import de.bos_bremen.ecard.client.gui.GUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettingsDialog
extends JDialog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettingsDialog.class);
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle res = ResourceBundle.getBundle(NettingsDialog.class.getName());
    private static final Insets ZERO = new Insets(0, 0, 0, 0);
    private static final Insets NORM = new Insets(12, 12, 12, 12);
    private static final Insets RIGHT = new Insets(12, 6, 12, 12);
    private static final Insets LEFT = new Insets(12, 12, 12, 6);
    private int result = 2;
    private JButton ok;
    private JTextField userName;
    private JPasswordField password;

    public NettingsDialog(String host, int port, URL url, boolean isProxy) {
        super((Frame)null, true);
        log.trace("Proxy - {} - {}:{} - {}", new Object[]{isProxy, host, port, url});
        this.init(host, port, url, isProxy);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setIconImage(new ImageIcon(NettingsDialog.class.getResource("/resources/boreum_24.png")).getImage());
        GUIUtils.setSignerThemeInUIManager();
    }

    public NettingsDialog(String host, int port, URL url) {
        this(host, port, url, true);
        log.trace("Proxy {}:{} - {}", new Object[]{host, port, url});
    }

    private void init(String host, int port, URL url, boolean isProxy) {
        log.trace("");
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBackground(Color.WHITE);
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(new ButtonBorder());
        int y = 0;
        JComponent p = this.prepareDescriptionView(host, port, url, isProxy);
        contentPane.add((Component)p, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        p = this.prepareInputView();
        contentPane.add((Component)p, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        p = this.prepareOperationsView();
        contentPane.add((Component)p, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        this.prepareFrame();
        this.userName.requestFocusInWindow();
    }

    private JComponent prepareDescriptionView(String host, int port, URL url, boolean isProxy) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(Color.WHITE);
        StringBuilder sb = new StringBuilder();
        String s = res.getString("hint.general");
        if (!isProxy) {
            s = s.replace("Proxy", "Server").replace("proxy", "server");
        }
        s = s.replace("HOST", host);
        s = s.replace("PORT", Integer.toString(port));
        s = s.replace("URL", url.toString());
        sb.append(s);
        JTextPane l = new JTextPane();
        l.setText(sb.toString());
        l.setOpaque(false);
        l.setEditable(false);
        p.add((Component)l, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, NORM, 0, 0));
        return p;
    }

    private JComponent prepareInputView() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(Color.WHITE);
        int y = 0;
        JLabel l = new JLabel(res.getString("userName.label"));
        p.add((Component)l, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.userName = new JTextField();
        DocumentListener userNameDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NettingsDialog.this.userNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NettingsDialog.this.userNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.userName.getDocument().addDocumentListener(userNameDL);
        this.userName.setColumns(25);
        p.add((Component)this.userName, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, RIGHT, 0, 0));
        l = new JLabel(res.getString("password.label"));
        p.add((Component)l, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.password = new JPasswordField();
        DocumentListener passwordDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NettingsDialog.this.passwordChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NettingsDialog.this.passwordChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.password.getDocument().addDocumentListener(passwordDL);
        this.password.setColumns(25);
        p.add((Component)this.password, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, RIGHT, 0, 0));
        return p;
    }

    private void checkOK() {
        boolean b = this.userName.getDocument().getLength() > 0;
        b = b && this.password.getDocument().getLength() > 0;
        this.ok.setEnabled(b);
    }

    protected void passwordChanged() {
        this.checkOK();
    }

    protected void userNameChanged() {
        this.checkOK();
    }

    private JComponent prepareOperationsView() {
        JPanel operations = new JPanel(new FlowLayout(2, 12, 12));
        operations.setBackground(Color.WHITE);
        this.ok = new JButton(res.getString("button.ok.label"));
        this.ok.setDefaultCapable(true);
        this.ok.setOpaque(false);
        this.ok.setEnabled(false);
        this.ok.addActionListener(e -> this.closeDialog(0));
        operations.add(this.ok);
        JButton cancel = new JButton(res.getString("button.cancel.label"));
        cancel.setDefaultCapable(false);
        cancel.setOpaque(false);
        cancel.addActionListener(e -> this.closeDialog(2));
        operations.add(cancel);
        return operations;
    }

    private void prepareFrame() {
        this.setIconImages(((Window)this.getParent()).getIconImages());
        this.setTitle(res.getString("dialog.title"));
        this.setDefaultCloseOperation(0);
        this.getRootPane().registerKeyboardAction(e -> this.closeDialog(2), KeyStroke.getKeyStroke(27, 0, false), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NettingsDialog.this.closeDialog(2);
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.ok);
        this.getRootPane().setBackground(Color.WHITE);
        this.setModal(true);
    }

    protected void closeDialog(int r) {
        this.result = r;
        this.setVisible(false);
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    public String getUser() {
        return this.userName.getText();
    }

    public char[] getPassword() {
        return this.password.getPassword();
    }

    public static class ButtonBorder
    implements Border {
        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(12, 12, 13, 12);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics graph, int x, int y, int w, int h) {
            Graphics2D g = (Graphics2D)graph;
            g.setPaint(new GradientPaint(x, y, Color.WHITE, x, (float)y + (float)h, Color.WHITE));
            g.fillRect(x, y, w, h);
            g.setColor(Color.WHITE);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        }
    }
}

