/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl;

import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ecard.client.BoreumHttpClient;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.gui.dialog.ConnectServerWaitWindow;
import de.bos_bremen.ecard.client.gui.dialog.VerifyTimeDialog;
import de.bos_bremen.ecard.client.gui.dialog.WaitWindow;
import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.request.ValidationRequest;
import de.governikus.csl.server.AuthService;
import de.governikus.csl.server.BNotK;
import de.governikus.csl.server.CertificateValidationServer;
import de.governikus.csl.server.ProxyServer;
import de.governikus.csl.server.SignService;
import de.governikus.csl.server.TimestampService;
import de.governikus.csl.setup.validation.SetupException;
import de.governikus.csl.setup.validation.ValidationProcessorSetup;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.TransportFactoryConfiguration;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Options;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.validate.AlgorithmCatalog;
import de.governikus.csl.uom.validate.ValidateProcessor;
import de.governikus.csl.uom.validate.ValidateRequest;
import de.governikus.csl.uom.validate.ValidateResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignerValidationProcessor {
    private static final Logger LOG = LogManager.getLogger(SignerValidationProcessor.class);
    private static SignerValidationProcessor instance;
    private ValidationProcessorSetup setup;
    private ValidateProcessor validationProcessor;
    private HttpClient httpClient;
    private ProxyServer proxyServer = new ProxyServer();
    private CertificateValidationServer server = new CertificateValidationServer();
    private AuthService authService = null;
    private SignService signService = null;
    private TimestampService timestampService = new TimestampService();
    private BNotK bNotK = null;

    private SignerValidationProcessor() {
        LOG.trace("");
        this.setup = new ValidationProcessorSetup();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignerValidationProcessor getInstance() {
        LOG.trace("");
        Class<SignerValidationProcessor> clazz = SignerValidationProcessor.class;
        synchronized (SignerValidationProcessor.class) {
            if (instance == null) {
                instance = new SignerValidationProcessor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignerValidationProcessor resetInstance() {
        LOG.trace("reset ValidationProcessor");
        Class<SignerValidationProcessor> clazz = SignerValidationProcessor.class;
        synchronized (SignerValidationProcessor.class) {
            instance = new SignerValidationProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ValidationProcessorSetup getValidationProcessorSetup() {
        LOG.trace("");
        return this.setup;
    }

    public ValidateProcessor getValidateProcessor() {
        LOG.trace("");
        if (this.validationProcessor == null) {
            try {
                this.validationProcessor = this.setup.buildValidationProcessor();
            }
            catch (SetupException e) {
                LOG.error("", (Throwable)e);
            }
        }
        return this.validationProcessor;
    }

    public TimestampService getTimestampService() {
        if (this.timestampService.isValid()) {
            return this.timestampService;
        }
        return null;
    }

    public void setTimestampService(TimestampService timestampService) {
        this.timestampService = timestampService;
    }

    public ValidateResponse verifyCertificate(FlatCertificate cert, Date validationDate, ConnectServerWaitWindow waitWindow) throws Exception {
        LOG.trace("");
        File certFile = this.saveIntoTempFile(cert);
        if (certFile == null) {
            return null;
        }
        ValidationRequest request = new ValidationRequest();
        ValidationOptions options = new ValidationOptions();
        FileDocumentImpl signature = new FileDocumentImpl(certFile, certFile.getName());
        SimpleSignedData data = new SimpleSignedData((Document)signature);
        request.setSignedData((SignedData)data);
        if (validationDate == null && (validationDate = this.getVerificationTime(waitWindow)) == null) {
            return null;
        }
        options.setValidationDate(validationDate);
        request.setOptions((Options)options);
        LOG.trace("");
        return this.getValidateProcessor().validate((ValidateRequest)request);
    }

    public ValidateResponse verifyEnvelopedCMS(File signatureFile) throws Exception {
        LOG.trace("");
        ValidationRequest request = new ValidationRequest();
        FileDocumentImpl signedDocument = new FileDocumentImpl(signatureFile, signatureFile.getName());
        SimpleSignedData data = new SimpleSignedData((Document)signedDocument);
        request.setSignedData((SignedData)data);
        ValidationOptions options = new ValidationOptions();
        request.setOptions((Options)options);
        LOG.trace("");
        return this.getValidateProcessor().validate((ValidateRequest)request);
    }

    public HttpClient getHttpClient() {
        LOG.trace("");
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        LOG.trace("");
        this.httpClient = httpClient;
        this.setup.setHttpClient(httpClient, true, null);
    }

    public ProxyServer getProxyConfiguration() {
        LOG.trace("ValidationProcessor -> Model-ProxyServer : {}", (Object)this.proxyServer);
        return this.proxyServer;
    }

    public AuthService getAuthService() {
        LOG.trace("ValidationProcessor -> Model-AuthService");
        if (this.authService == null) {
            return null;
        }
        if (this.authService.isValid()) {
            return this.authService;
        }
        return null;
    }

    public void setAuthService(AuthService authService) {
        this.authService = authService;
    }

    public void setSignService(SignService signService) {
        this.signService = signService;
    }

    public SignService getSignService() {
        if (this.signService == null) {
            return null;
        }
        if (this.signService.isValid()) {
            return this.signService;
        }
        return null;
    }

    public void setBNotK(BNotK bNotK) {
        this.bNotK = bNotK;
    }

    public BNotK getBNotK() {
        if (this.bNotK == null) {
            return null;
        }
        if (this.bNotK.isValid()) {
            return this.bNotK;
        }
        return null;
    }

    public CertificateValidationServer getServer() {
        LOG.trace("");
        if (this.server == null) {
            return null;
        }
        if (this.server.isConfigComplete()) {
            LOG.trace("server is complete");
            return this.server;
        }
        LOG.warn("Validation Server ist nicht vollstaendig");
        return this.server;
    }

    public void setServer(CertificateValidationServer cvs) {
        LOG.trace("ValidationProcessor <- Model-CVS");
        this.server = cvs;
        this.setup = new ValidationProcessorSetup();
        this.setup.setRelayURL(this.server.getUrl());
        this.setup.setRelaySigningCertificates(this.server.getCertificates());
        this.setup.setTempDataFolder(Step.getTempFolder()).addASiCPlugin().addCAdESPlugin().addPAdESPlugin().addZipPlugin().addX509Plugin().addXAdESPlugin().addDeMailPlugin().addOSCIPlugin().addSMIMEPlugin().addTSPPlugin();
        this.setup.setTrustedAlgoCatalogSigningCertificates(this.getTrustedAlgoCatalogSigningCertificates());
        this.setup.addAlgorithmCatalog(AlgorithmCatalog.SOGIS_PLUS.name(), "algo_cat_sogis_plus.xml-signed.xml");
        this.setup.addAlgorithmCatalog(AlgorithmCatalog.SOGIS_ETSI.name(), "algo_cat_sogis_etsi.xml-signed.xml");
        this.setup.setHttpClient(this.httpClient, true, null);
        LOG.trace("");
    }

    public void setProxyServer(ProxyServer proxyServer) {
        LOG.trace("ValidationProcessor <- Model-ProxyServer : {}", (Object)proxyServer);
        this.proxyServer = proxyServer;
        TransportFactoryConfiguration transportFactoryConfiguration = new TransportFactoryConfiguration((ProxyConfiguration)proxyServer);
        this.httpClient = new BoreumHttpClient(transportFactoryConfiguration);
        this.setup.setHttpClient(this.httpClient, true, null);
        LOG.trace("");
    }

    public BoreumHttpClient getNewHttpClient() {
        LOG.trace("");
        TransportFactoryConfiguration transportFactoryConfiguration = null;
        transportFactoryConfiguration = this.proxyServer != null ? new TransportFactoryConfiguration((ProxyConfiguration)this.proxyServer) : new TransportFactoryConfiguration();
        transportFactoryConfiguration.setTrustedServerCerts(this.getSSLCertificates());
        return new BoreumHttpClient(transportFactoryConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getSslKeyStore() {
        InputStream in = SignerValidationProcessor.class.getResourceAsStream("/ssl.p12");
        if (in == null) {
            return null;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            keyStore.load(in, "signer".toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
        }
        finally {
            Utils.closeStream(in);
        }
        return null;
    }

    private List<Certificate> getSSLCertificates() {
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        KeyStore keystore = this.getSslKeyStore();
        if (keystore != null) {
            try {
                Enumeration<String> aliases = keystore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    result.add(keystore.getCertificate(alias));
                }
            }
            catch (KeyStoreException ex) {
                LOG.info("", (Throwable)ex);
            }
        }
        return result;
    }

    private void init() {
        this.setup.setTempDataFolder(Step.getTempFolder()).addASiCPlugin().addCAdESPlugin().addPAdESPlugin().addZipPlugin().addX509Plugin().addXAdESPlugin().addDeMailPlugin().addOSCIPlugin().addSMIMEPlugin().addTSPPlugin();
        this.setup.setTrustedAlgoCatalogSigningCertificates(this.getTrustedAlgoCatalogSigningCertificates());
        this.setup.addAlgorithmCatalog(AlgorithmCatalog.SOGIS_PLUS.name(), "algo_cat_sogis_plus.xml-signed.xml");
        this.setup.addAlgorithmCatalog(AlgorithmCatalog.SOGIS_ETSI.name(), "algo_cat_sogis_etsi.xml-signed.xml");
    }

    private Date getVerificationTime(WaitWindow waitWindow) {
        de.bos_bremen.ecard.client.model.Document documentInstance = de.bos_bremen.ecard.client.model.Document.getInstance();
        Date certificateVerifyTime = new Date();
        boolean hideWaitWindow = false;
        if (waitWindow != null) {
            hideWaitWindow = true;
            waitWindow.closeWindow();
        }
        int showDialog = VerifyTimeDialog.showDialog(documentInstance.getFrame(), certificateVerifyTime);
        if (hideWaitWindow) {
            waitWindow.showWindow();
        }
        if (showDialog != 0) {
            return null;
        }
        if (VerifyTimeDialog.isLocalTime()) {
            return new Date();
        }
        return certificateVerifyTime;
    }

    private List<? extends X509Certificate> getTrustedAlgoCatalogSigningCertificates() {
        X509Certificate cert;
        CertificateFactory cf;
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        InputStream is = CertificateValidationServer.class.getResourceAsStream("/algo_cat_signing_certificate02.cer");
        if (is != null) {
            try {
                cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(is);
                result.add(cert);
            }
            catch (CertificateException ex) {
                LOG.error("", (Throwable)ex);
            }
        }
        if ((is = CertificateValidationServer.class.getResourceAsStream("/algo_cat_signing_certificate03.cer")) != null) {
            try {
                cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(is);
                result.add(cert);
            }
            catch (CertificateException ex) {
                LOG.error("", (Throwable)ex);
            }
        }
        return result;
    }

    private File saveIntoTempFile(FlatCertificate cert) throws IOException {
        File file = File.createTempFile("tmpSignerCert", ".cer", Step.getTempFolder());
        try (FileOutputStream fos = new FileOutputStream(file);){
            byte[] encoded = cert.getEncoded();
            fos.write(encoded);
            fos.flush();
            File file2 = file;
            return file2;
        }
    }
}

