/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.cryptohost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.governikus.csc.cryptohost.model.XPrivateKeyResourceReferenceImpl;
import de.governikus.csl.uom.lock.LockState;
import de.governikus.csl.uom.res.AbstractResourceReference;
import de.governikus.csl.uom.res.KeyFunctionSupportedAlgorithms;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceType;
import de.governikus.csl.uom.res.TransportResourceReferenceStateType;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceReferenceImpl;
import de.governikus.csl.uom.types.CertificateListType;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceReferenceStdDeserializer
extends StdDeserializer<AbstractResourceReference> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceReferenceStdDeserializer.class);

    public ResourceReferenceStdDeserializer() {
        this(null);
    }

    public ResourceReferenceStdDeserializer(Class<AbstractResourceReference> t) {
        super(t);
    }

    public AbstractResourceReference deserialize(JsonParser p, DeserializationContext context) throws IOException {
        LOG.debug("############################################################# deserialize");
        LOG.debug("JsonParser : {}", (Object)p);
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        return this.parseNode(node);
    }

    public AbstractResourceReference parseNode(JsonNode node) {
        String name = node.get("name").asText();
        String id = node.get("id").asText();
        ResourceType type = ResourceType.valueOf((String)node.get("type").asText());
        ResourceComponentType componentType = ResourceComponentType.valueOf(node.get("componentType").asText());
        ResourceAreaType areaType = ResourceAreaType.valueOf((String)node.get("areaType").asText());
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        ObjectNode nodeState = (ObjectNode)node.get("state");
        boolean present = nodeState.get("present").asBoolean();
        boolean enabled = nodeState.get("enabled").asBoolean();
        ObjectMapper om = new ObjectMapper();
        CertificateListType certificateList = new CertificateListType();
        try {
            certificateList = (CertificateListType)om.readValue(node.get("certificateChain").toString().getBytes(), CertificateListType.class);
        }
        catch (IOException e) {
            LOG.error("error {}", (Object)e.getMessage(), (Object)e);
        }
        TransportResourceReferenceStateType state = new TransportResourceReferenceStateType(LockState.valueOf((String)nodeState.get("lockState").asText()), enabled, present);
        ArrayNode nodeSupportedAlgorithms = (ArrayNode)node.get("supportedAlgorithms");
        ArrayList<KeyFunctionSupportedAlgorithms> keyFunctionSupportedAlgorithmsList = new ArrayList<KeyFunctionSupportedAlgorithms>();
        for (JsonNode jsonNode : nodeSupportedAlgorithms) {
            try {
                keyFunctionSupportedAlgorithmsList.add((KeyFunctionSupportedAlgorithms)om.readValue(jsonNode.toString().getBytes(), KeyFunctionSupportedAlgorithms.class));
            }
            catch (IOException e) {
                LOG.error("error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        PrivateKeyResourceReferenceImpl delegate = new PrivateKeyResourceReferenceImpl(name, type, areaType, PrivateKeyResourceImpl.class.getName(), (ResourceReferenceState)state, keyFunctionSupportedAlgorithmsList, componentType);
        delegate.setCertificateChain(certificateList);
        delegate.setId(id);
        delegate.setAlgorithm(node.get("algorithm").asText());
        delegate.setFormat(node.get("format").asText());
        return new XPrivateKeyResourceReferenceImpl(delegate, id);
    }
}

