/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webparam;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpResponse;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractParameter {
    private static final Logger LOG = LogManager.getLogger(AbstractParameter.class);
    protected List<String> source;
    protected String dest = "";
    private String logFileName;
    private URL webServiceURL;
    private String licenceXML = "";
    protected String licenceFileName = null;
    protected String configurationXML = "";
    protected String configurationFileName = null;
    protected TargetFolderType targetFolderType;
    protected ProcessPolicy processPolicy;
    private int maxStartSignerRetryCount = 100;
    private int maxGetWebserviceRetryCount = 200;
    protected String returnCodeURL;

    public List<String> getSource() {
        return this.source;
    }

    public String getDest() {
        if (this.dest == null) {
            this.dest = "";
        }
        return this.dest;
    }

    public void setDest(String inDest) {
        if (inDest != null && !inDest.isEmpty()) {
            this.dest = inDest;
            this.targetFolderType = TargetFolderType.oneSpecial;
        } else {
            this.targetFolderType = TargetFolderType.sameAsSourceFolder;
        }
    }

    public TargetFolderType getTargetFolderType() {
        if (this.targetFolderType == null) {
            this.targetFolderType = TargetFolderType.sameAsSourceFolder;
        }
        return this.targetFolderType;
    }

    public void setTargetFolderType(String value) throws SignerException {
        if (value == null || value.trim().isEmpty()) {
            this.targetFolderType = this.dest != null ? TargetFolderType.oneSpecial : TargetFolderType.sameAsSourceFolder;
            return;
        }
        for (TargetFolderType type : TargetFolderType.values()) {
            if (!type.name().equalsIgnoreCase(value)) continue;
            this.targetFolderType = type;
            return;
        }
        LOG.warn("unknown value {}", (Object)value);
        throw new SignerException(ErrorCode.ILLEGAL_PARAM, (Throwable)new NullPointerException("unknown value for signer.targetfoldertype"));
    }

    public void setSourceFiles(List<String> inSource) throws SignerException {
        if (inSource == null) {
            throw new SignerException(ErrorCode.ILLEGAL_PARAM, (Throwable)new Exception("unknown source file/s"));
        }
        this.source = inSource;
    }

    public File getLogFile() {
        File logFile = null;
        logFile = this.dest != null && !"".equals(this.dest) ? new File(this.dest, this.logFileName) : new File(this.logFileName);
        boolean fileCorrupt = false;
        try {
            fileCorrupt = !logFile.exists() && !logFile.createNewFile();
        }
        catch (IOException ex) {
            fileCorrupt = true;
        }
        if (fileCorrupt) {
            if (this.dest != null && !"".equals(this.dest)) {
                File tempPath = new File(this.dest);
                File tempFileName = new File(this.logFileName);
                logFile = new File(tempPath, tempFileName.getName());
            } else {
                File tempFileName = new File(this.logFileName);
                logFile = new File(tempFileName.getName());
            }
        }
        return logFile;
    }

    public void setLogFile(String file) {
        this.logFileName = file;
    }

    public URL getWebServiceURL() {
        return this.webServiceURL;
    }

    public ProcessPolicy getProcessPolicy() {
        if (this.processPolicy == null) {
            this.processPolicy = ProcessPolicy.skipCompletedStep;
        }
        return this.processPolicy;
    }

    protected String fetchNextParam(String[] args, int i) throws SignerException {
        if (args.length < i + 1 || args[i].startsWith("-") || args[i].startsWith("jnlp.")) {
            throw new SignerException(ErrorCode.MISSING_PARAM, args[i - 1], (Throwable)new Exception("missing argument for param " + args[i - 1]));
        }
        return args[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLicenceXML() {
        LOG.info("license file name: {}", (Object)this.licenceFileName);
        if (this.licenceFileName == null || this.licenceFileName.isEmpty()) {
            this.licenceXML = "";
            return;
        }
        if (this.licenceFileName.indexOf("://") != -1 && this.licenceFileName.indexOf("file:") == -1) {
            try {
                File tempLicenceFileNamefile = File.createTempFile("license", ".xml");
                LOG.trace("temp LicenseFile : {}", (Object)tempLicenceFileNamefile);
                URL url = new URL(this.licenceFileName);
                LOG.trace("url licenseFileName : {}", (Object)url);
                LOG.info("downloading: {}", (Object)url);
                HttpClient http = SignerValidationProcessor.getInstance().getHttpClient();
                HttpResponse responseTemp = http.get(url.toURI(), new HttpHeader[0]);
                int responseStatus = responseTemp.getStatus();
                LOG.debug("HTTP Response Status: {}", (Object)responseStatus);
                if (responseStatus == 404) {
                    LOG.error("404: license nicht gefunden: {}", (Object)this.licenceFileName);
                    LOG.error("Pruefen Sie im Browser, ob URL erreichbar ist: {}", (Object)this.licenceFileName);
                    this.licenceXML = "";
                    Utils.closeStream((Closeable)responseTemp);
                    return;
                }
                try (InputStream is = responseTemp.getContent();
                     FileOutputStream fos = new FileOutputStream(tempLicenceFileNamefile);){
                    int bytesRead;
                    byte[] buff = new byte[4096];
                    while (-1 != (bytesRead = is.read(buff, 0, buff.length))) {
                        ((OutputStream)fos).write(buff, 0, bytesRead);
                    }
                }
                finally {
                    Utils.closeStream((Closeable)responseTemp);
                }
                this.licenceFileName = tempLicenceFileNamefile.getAbsolutePath();
                LOG.trace("licenceFileName : {}", (Object)this.licenceFileName);
            }
            catch (Exception ex) {
                LOG.error("Konnte license von parameter licenceFile nicht herunterladen: ", (Throwable)ex);
                this.licenceXML = "";
                return;
            }
        }
        LOG.info("Local license file: {}", (Object)this.licenceFileName);
        if (this.licenceFileName == null) {
            LOG.trace("");
            this.licenceXML = "";
            return;
        }
        File licenceFile = new File(this.licenceFileName);
        if (!licenceFile.exists()) {
            LOG.warn("The file does not exists : {}", (Object)licenceFile);
            this.licenceXML = "";
            return;
        }
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(licenceFile), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            this.licenceXML = buffer.toString();
            LOG.trace("Load done: licenceXML: \n{}", (Object)this.licenceXML);
        }
        catch (IOException ex) {
            this.licenceXML = "";
            LOG.trace("");
        }
        LOG.trace("");
    }

    public String getLicenceXML() {
        return this.licenceXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfigurationXML() {
        LOG.info("configuration file name: {}", (Object)this.configurationFileName);
        if (this.configurationFileName == null || this.configurationFileName.isEmpty()) {
            this.configurationXML = "";
            return;
        }
        if (this.configurationFileName.indexOf("://") != -1 && this.configurationFileName.indexOf("file:") == -1) {
            try {
                File tempConfigurationFileNamefile = File.createTempFile("configuration", ".xml");
                URL url = new URL(this.configurationFileName);
                LOG.info("downloading: {}", (Object)url);
                HttpClient http = SignerValidationProcessor.getInstance().getHttpClient();
                HttpResponse responseTemp = http.get(url.toURI(), new HttpHeader[0]);
                int responseStatus = responseTemp.getStatus();
                LOG.debug("HTTP Response Status: {}", (Object)responseStatus);
                if (responseStatus == 404) {
                    LOG.error("404: Konfiguration nicht gefunden: {}", (Object)this.configurationFileName);
                    LOG.error("Pruefen Sie im Browser, ob URL erreichbar ist: {}", (Object)this.configurationFileName);
                    this.configurationXML = "";
                    Utils.closeStream((Closeable)responseTemp);
                    return;
                }
                try (InputStream is = responseTemp.getContent();
                     FileOutputStream fos = new FileOutputStream(tempConfigurationFileNamefile);){
                    int bytesRead;
                    byte[] buff = new byte[4096];
                    while (-1 != (bytesRead = is.read(buff, 0, buff.length))) {
                        ((OutputStream)fos).write(buff, 0, bytesRead);
                    }
                }
                finally {
                    Utils.closeStream((Closeable)responseTemp);
                }
                this.configurationFileName = tempConfigurationFileNamefile.getAbsolutePath();
            }
            catch (Exception ex) {
                LOG.error("", (Throwable)ex);
                this.configurationXML = "";
                return;
            }
        }
        if (this.configurationFileName == null) {
            this.configurationXML = "";
            return;
        }
        LOG.info("local configuration file: {}", (Object)this.configurationFileName);
        File configurationFile = new File(this.configurationFileName);
        if (!configurationFile.exists()) {
            LOG.warn("The file does not exists: {}", (Object)this.configurationFileName);
            this.configurationXML = "";
            return;
        }
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configurationFile), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            this.configurationXML = buffer.toString();
            LOG.trace("Load done: configurationXML: \n{}", (Object)this.configurationXML);
        }
        catch (IOException ex) {
            this.configurationXML = "";
        }
    }

    public String getConfigurationXML() {
        return this.configurationXML;
    }

    public void setWebServiceURL(String inWebServiceURL) throws MalformedURLException {
        if (inWebServiceURL != null && !inWebServiceURL.equals("")) {
            try {
                this.webServiceURL = new URL(inWebServiceURL);
            }
            catch (MalformedURLException e) {
                this.webServiceURL = null;
                throw new MalformedURLException(inWebServiceURL);
            }
        }
    }

    public void setProcessPolicy(String value) throws SignerException {
        if (value == null || value.trim().isEmpty()) {
            this.processPolicy = ProcessPolicy.firstStep;
            return;
        }
        for (ProcessPolicy type : ProcessPolicy.values()) {
            if (!type.name().equalsIgnoreCase(value)) continue;
            this.processPolicy = type;
            return;
        }
        LOG.warn("unknown value {}", (Object)value);
        throw new SignerException(ErrorCode.ILLEGAL_PARAM, (Throwable)new NullPointerException("unknown value for signer.processpolicy"));
    }

    public void setLicenceXML(String inLicenceXML) {
        if (inLicenceXML != null) {
            if (new File(inLicenceXML).exists()) {
                this.licenceFileName = inLicenceXML;
            }
            this.loadLicenceXML();
        } else {
            this.licenceXML = "";
        }
    }

    public void setConfigurationXML(String inConfigurationXML) {
        if (inConfigurationXML != null) {
            this.configurationXML = inConfigurationXML;
            if (this.configurationFileName == null || this.configurationFileName.isEmpty()) {
                this.configurationFileName = this.configurationXML;
            }
            this.loadConfigurationXML();
        } else {
            this.configurationXML = "";
        }
    }

    public int getMaxStartSignerRetryCount() {
        return this.maxStartSignerRetryCount;
    }

    public void setMaxStartSignerRetryCount(int maxStartSignerRetryCount) {
        this.maxStartSignerRetryCount = maxStartSignerRetryCount;
    }

    public int getMaxGetWebserviceRetryCount() {
        return this.maxGetWebserviceRetryCount;
    }

    public void setMaxGetWebserviceRetryCount(int maxGetWebserviceRetryCount) {
        this.maxGetWebserviceRetryCount = maxGetWebserviceRetryCount;
    }

    public void setRCUrl(String rc) {
        this.returnCodeURL = rc;
    }

    public String getRCUrl() {
        return this.returnCodeURL;
    }

    public Locale getLocale() {
        return Locale.GERMAN;
    }

    public void setLicenceFileName(String licenceFileName) {
        this.licenceFileName = licenceFileName;
    }

    public String getLicenceFileName() {
        return this.licenceFileName;
    }

    public void setConfigurationFileName(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public String getConfigurationFileName() {
        return this.configurationFileName;
    }
}

