/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.util;

import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.util.DOMTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(XMLProperties.class);
    private static final String ROOTNODENAME = "root";
    private boolean loadEmptyNodeValues = false;

    public XMLProperties() {
    }

    public XMLProperties(boolean loadEmptyNodeValues) {
        this.loadEmptyNodeValues = loadEmptyNodeValues;
    }

    public XMLProperties(Properties defaults) {
        super(defaults);
    }

    public static XMLProperties getInstanceFromProperties(Properties p, boolean loadEmptyNodeValues) {
        XMLProperties result = null;
        result = new XMLProperties(loadEmptyNodeValues);
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            result.setProperty(key, value);
        }
        return result;
    }

    public void addAll(String node, Properties properties) {
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            Object key = (String)e.nextElement();
            String value = properties.getProperty((String)key);
            if (node.trim().length() != 0) {
                key = node + "/" + (String)key;
            }
            if (key == null || value == null) continue;
            this.setProperty((String)key, value);
        }
    }

    public XMLProperties extractPropertiesForNode(String node) {
        XMLProperties result = new XMLProperties(this.loadEmptyNodeValues);
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.indexOf(node) < 0) continue;
            String value = this.getProperty(key);
            String key2 = key.replaceAll(node, "");
            result.setProperty(key2.substring(key2.indexOf("/") + 1), value);
            this.remove(key);
        }
        return result;
    }

    public XMLProperties getPropertiesForNode(String node) {
        XMLProperties result = new XMLProperties(this.loadEmptyNodeValues);
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(node + "/")) continue;
            String value = this.getProperty(key);
            String key2 = key.replaceAll(node + "/", "");
            result.setProperty(key2, value);
        }
        return result;
    }

    @Override
    public synchronized void loadFromXML(InputStream inStream) throws IOException {
        LOG.trace("");
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inStream);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        if (doc != null) {
            this.parseXML(doc);
        }
    }

    private void parseXML(Document doc) throws IOException {
        Node n;
        int i;
        LOG.trace("");
        NodeList childNodes = doc.getChildNodes();
        if (childNodes.item(0).getNodeName().equals("Signature")) {
            childNodes = childNodes.item(0).getChildNodes();
            for (i = 0; i < childNodes.getLength(); ++i) {
                n = childNodes.item(i);
                if (!n.getNodeName().equals("Object")) continue;
                childNodes = n.getChildNodes();
                break;
            }
        }
        for (i = 0; i < childNodes.getLength(); ++i) {
            Node periodAttribute;
            n = childNodes.item(i);
            if (n.getAttributes() == null) continue;
            Node displayNameAttribute = n.getAttributes().getNamedItem("displayName");
            if (displayNameAttribute != null && Config.getLicenceName() == null) {
                Config.setLicenceName(displayNameAttribute.getNodeValue());
            }
            if ((periodAttribute = n.getAttributes().getNamedItem("period")) != null) {
                long openDays = this.checkPeriod();
                long period = Long.parseLong(periodAttribute.getNodeValue());
                if (openDays >= 0L && openDays < period) {
                    Config.setPeriod(true, period - openDays);
                    String nodePath = "";
                    this.getNodeValues(nodePath, n);
                    continue;
                }
                if (openDays >= 0L && openDays > period) {
                    Config.setPeriod(true, -1L);
                    continue;
                }
                Config.setPeriod(true, -1L);
                throw new IOException();
            }
            Config.setPeriod(false, new Long[0]);
            String nodePath = "";
            this.getNodeValues(nodePath, n);
        }
    }

    private long checkPeriod() {
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
            Preferences licenceNode = Preferences.userRoot().node("de/bos_bremen/governikus_signer");
            if (licenceNode != null) {
                Date period = df.parse(new String(Base64.getDecoder().decode(licenceNode.get("period", "")), StandardCharsets.UTF_8));
                Date today = df.parse(df.format(new Date()));
                return (today.getTime() - period.getTime()) / 86400000L;
            }
            return -1L;
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    private void getNodeValues(String nodePath, Node n) {
        NodeList childNodes = n.getChildNodes();
        if (childNodes.getLength() == 0) {
            if (n.getNodeValue() != null) {
                if (this.loadEmptyNodeValues || n.getNodeValue().trim().length() != 0) {
                    this.setProperty(((String)nodePath).substring(((String)nodePath).indexOf("/", 1) + 1), n.getNodeValue().trim());
                }
            } else if (this.loadEmptyNodeValues) {
                this.setProperty(((String)nodePath).substring(((String)nodePath).indexOf("/", 1) + 1) + "/" + n.getNodeName(), "");
            }
        } else {
            nodePath = (String)nodePath + "/" + n.getNodeName();
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            this.getNodeValues((String)nodePath, childNodes.item(i));
        }
    }

    public synchronized void storeToXML(File file) throws IOException {
        LOG.trace("store in {}...", (Object)file);
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (doc == null) {
            throw new IOException("couldn't create document");
        }
        if (file == null) {
            throw new IOException("file == null");
        }
        this.createNode(doc, ROOTNODENAME, "");
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            Object key = (String)e.nextElement();
            String value = this.getProperty((String)key);
            key = "root/" + (String)key;
            this.createNode(doc, (String)key, value);
        }
        if (doc.getChildNodes().getLength() == 0) {
            return;
        }
        try {
            DOMTools.documentToFile(doc, file.getAbsolutePath(), "UTF-8", 2);
        }
        catch (Exception ex) {
            LOG.error("Error: ", (Throwable)ex);
            throw new IOException(ex.getMessage());
        }
        LOG.trace("store : done");
    }

    public synchronized void storeToXML(OutputStream outS) throws IOException {
        LOG.trace("");
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Throwable ex) {
            LOG.debug(ex.getMessage());
        }
        if (doc == null) {
            throw new IOException("couldn't create document");
        }
        if (outS == null) {
            throw new IOException("outS == null");
        }
        this.createNode(doc, ROOTNODENAME, "");
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            Object key = (String)e.nextElement();
            String value = this.getProperty((String)key);
            key = "root/" + (String)key;
            this.createNode(doc, (String)key, value);
        }
        if (doc.getChildNodes().getLength() == 0) {
            return;
        }
        try {
            DOMTools.documentToStream(doc, outS);
        }
        catch (Exception ex) {
            LOG.error("Error: ", (Throwable)ex);
            throw new IOException(ex.getMessage());
        }
    }

    private void createNode(Document doc, String key, String value) {
        Element firstNode = null;
        Element lastNode = null;
        StringTokenizer st = new StringTokenizer(key, "/", false);
        String firstToken = st.nextToken();
        if (doc.getElementsByTagName(firstToken).getLength() > 0) {
            firstNode = (Element)doc.getElementsByTagName(firstToken).item(0);
        } else {
            firstNode = doc.createElement(firstToken);
            doc.appendChild(firstNode);
        }
        lastNode = firstNode;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            NodeList nl = lastNode.getChildNodes();
            boolean hasChild = false;
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!nl.item(i).getNodeName().equals(token)) continue;
                lastNode = (Element)nl.item(i);
                hasChild = true;
                break;
            }
            if (hasChild) continue;
            Element element = doc.createElement(token);
            lastNode.appendChild(element);
            lastNode = element;
        }
        Text tn = doc.createTextNode(value);
        lastNode.appendChild(tn);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null || value.isEmpty()) continue;
            builder.append(entry + "\n");
        }
        return builder.toString();
    }

    public static void printEntrySet(XMLProperties props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        LOG.trace((Object)props);
    }

    public static void printProcessEntrySet(XMLProperties props) {
        if (props == null) {
            return;
        }
        LOG.trace("--- Process Signieren ---");
        XMLProperties processProperties = props.getPropertiesForNode("sign");
        for (Map.Entry<Object, Object> entry : processProperties.entrySet()) {
            XMLProperties.printEntrySet(processProperties);
        }
        LOG.trace("TODO *** Process Validieren/Encrypt/Decrypt ");
    }
}

