/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.util;

import de.bos_bremen.ecard.client.util.Entry;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Reg {
    private static final Logger LOG = LogManager.getLogger(Reg.class);

    private Reg() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Entry> query(String regPath, String key) throws IOException, InterruptedException {
        String token;
        StringBuilder sb;
        String[] cmd = key == null ? new String[3] : new String[5];
        cmd[0] = "reg";
        cmd[1] = "query";
        cmd[2] = "\"" + regPath + "\"";
        if (key != null) {
            cmd[3] = "/v";
            cmd[4] = key;
        }
        if (LOG.isDebugEnabled()) {
            Object _cmd = "";
            for (int i = 0; i < cmd.length; ++i) {
                _cmd = (String)_cmd + cmd[i] + " ";
            }
            LOG.debug("CMD: \"{}\"", _cmd);
        }
        Process process = Runtime.getRuntime().exec(cmd);
        try (InputStreamReader is = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
            sb = new StringBuilder();
            char[] buf = new char[8192];
            int read = is.read(buf);
            while (read != -1) {
                sb.append(buf, 0, read);
                read = is.read(buf);
            }
        }
        int response = process.waitFor();
        if (response != 0) {
            throw new IOException("return code: " + response);
        }
        StringTokenizer st = new StringTokenizer(sb.toString(), "\n", false);
        while (st.hasMoreTokens() && !(token = st.nextToken().trim()).equals(regPath)) {
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while (st.hasMoreTokens()) {
            String token2 = st.nextToken().trim();
            if (token2.length() == 0) continue;
            entries.add(new Entry(regPath, token2));
        }
        return entries;
    }
}

