/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class GlassPane
extends JComponent
implements KeyEventDispatcher {
    private static final long serialVersionUID = 1L;
    private static final int BAR_WIDTH = 200;
    private static final int BAR_HEIGHT = 10;
    private int progress = 0;

    public GlassPane() {
        this.setFocusTraversalKeysEnabled(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                GlassPane.this.requestFocusInWindow();
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.setBackground(Color.WHITE);
        this.setFont((Font)UIManager.get("TitledBorder.font"));
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        int oldProgress = this.progress;
        this.progress = progress;
        if (this.getGraphics() != null && this.getGraphics().getFont() != null) {
            FontMetrics metrics = this.getGraphics().getFontMetrics(this.getFont());
            int w = (int)(200.0f * ((float)oldProgress / 100.0f));
            int x = w + (this.getWidth() - 200) / 2;
            int y = (this.getHeight() - 10) / 2;
            w = (int)(200.0f * ((float)progress / 100.0f)) - w;
            int h = 10;
            this.repaint(x, y += metrics.getDescent() / 2, w, h);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clip = g.getClipBounds();
        AlphaComposite alpha = AlphaComposite.SrcOver.derive(0.4f);
        g2.setComposite(alpha);
        g2.setColor(this.getBackground());
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        return false;
    }
}

