/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.util;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ecard.client.util.DType;

public class Entry {
    public final String path;
    public final String key;
    public final DType type;
    public final Object value;

    public Entry(String path, String key, DType type, Object value) {
        this.path = path;
        this.key = key;
        this.type = type;
        this.value = value;
    }

    public Entry(String p, String line) {
        this.path = p;
        if (!line.startsWith(this.path)) {
            line = Hex.replaceAll((String)line, (String)"    ", (int)9);
            String[] split = line.split("\t");
            this.key = split[0];
            this.type = DType.valueOf(split[1]);
            this.value = this.type.getJavaType(split[2]);
        } else {
            this.key = line.substring(this.path.length() + 1);
            this.type = null;
            this.value = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Entry[");
        sb.append("key=" + this.key);
        sb.append(", type=" + this.type);
        sb.append(", value=" + this.value);
        sb.append(']');
        return sb.toString();
    }
}

