/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class DOMTools {
    private static final Logger LOG = LogManager.getLogger(DOMTools.class);
    protected static final String STANDARD_ENCODING = "UTF-8";
    private static final String OUTFORM_XALAN_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";

    private DOMTools() {
        throw new IllegalStateException("Utility class");
    }

    public static void documentToFile(Document doc, String strFileName, String encoding, int indent) {
        try {
            File file = new File(strFileName);
            try (FileOutputStream fos = new FileOutputStream(file);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);){
                DOMTools.serialize(doc, osw, encoding, indent);
            }
        }
        catch (Exception ex) {
            LOG.error("Exception: documentToFile(data, {})", (Object)strFileName, (Object)ex);
        }
    }

    public static void documentToStream(Document data, OutputStream out) {
        try {
            DOMTools.transform((Source)new DOMSource(data), new StreamResult(out), STANDARD_ENCODING, 0, null, "xml", false);
        }
        catch (TransformerException ex) {
            LOG.error("", (Throwable)ex);
        }
    }

    private static void serialize(Document doc, Writer out, String encoding, int indent) throws TransformerException {
        DOMTools.transform((Source)new DOMSource(doc), out, encoding, indent, null, "xml", false);
    }

    private static void transform(Source source, Writer out, String encoding, int indent, Properties outProps, String type, boolean omitXMLDeclaration) throws TransformerException {
        StreamResult result = new StreamResult(out);
        DOMTools.transform(source, result, encoding, indent, outProps, type, omitXMLDeclaration);
    }

    private static void transform(Source source, Result result, String encoding, int indent, Properties outProps, String type, boolean omitXMLDeclaration) throws TransformerException {
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("method", type);
        xformer.setOutputProperty("indent", indent >= 0 ? "yes" : "no");
        xformer.setOutputProperty(OUTFORM_XALAN_INDENT_AMOUNT, (String)(indent >= 0 ? "" + indent : "0"));
        xformer.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
        xformer.setOutputProperty("encoding", encoding);
        if (outProps != null) {
            xformer.setOutputProperties(outProps);
        }
        xformer.transform(source, result);
    }
}

