/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.licence;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.licence.Licence;
import de.bos_bremen.ecard.client.model.licence.LicenceKeyEngine;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.governikus.csl.server.val.SimpleXMLSignatureValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProductLicence
extends Licence {
    private static final String RESOURCES = "/resources/";
    InputStream certificateInS = this.getClass().getResourceAsStream("/resources/governikusSigner.cer");
    private static final Logger LOG = LogManager.getLogger(ProductLicence.class);
    protected static final String DEFAULT_FILENAME = "default_licence.xml";
    protected static final String BASIC_FILENAME = "basic_licence.xml";
    protected static final String BASIC_YEAR_FILENAME = "basic_year_licence.xml";
    protected static final String PROF_FILENAME = "professional_licence.xml";
    private static final String CERTIFICATENAME = "governikusSigner.cer";
    public static final String BOREUM_PREF_NODE = "de/bos_bremen/governikus_signer";
    protected static final String PERIOD = "period";
    protected static final String LICENCE = "licence";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductLicence() {
        if (this.getClass().getResourceAsStream("/resources/governikusSigner.cer") == null) {
            LOG.error("/resources/governikusSigner.cer is null -> Illegal access");
            return;
        }
        Preferences userLicenceNode = Preferences.userRoot().node(BOREUM_PREF_NODE);
        Preferences systemLicenceNode = Preferences.systemRoot().node(BOREUM_PREF_NODE);
        String licenceFilename = this.checkLicenceFileName(userLicenceNode, systemLicenceNode);
        InputStream inS = this.getClass().getResourceAsStream(RESOURCES + licenceFilename);
        try {
            if (inS == null) {
                inS = this.getClass().getResourceAsStream(System.getProperty("signer.licence"));
            }
            if (inS == null) {
                LOG.error(" {} is null -> Illegal access", (Object)licenceFilename);
                return;
            }
        }
        catch (Exception e) {
            LOG.debug("");
        }
        File configFile = null;
        try {
            configFile = this.createTempFile(inS);
            if (!this.isSignatureValid(configFile, this.certificateInS)) {
                LOG.error("XML signature is invalid -> illegal licence!");
                return;
            }
        }
        catch (IOException ex) {
            LOG.error("", (Throwable)ex);
        }
        try (FileInputStream in = new FileInputStream(configFile);){
            this.load(in);
        }
        catch (IOException ex) {
            LOG.error("", (Throwable)ex);
        }
        finally {
            Utils.closeStream(inS);
            Utils.closeStream(this.certificateInS);
            if (configFile != null) {
                try {
                    Files.delete(configFile.toPath());
                }
                catch (IOException e) {
                    configFile.deleteOnExit();
                }
            }
        }
    }

    protected String checkLicenceFileName(Preferences userLicenceNode, Preferences systemLicenceNode) {
        LicenceKeyEngine licenceKeyEngine;
        if (userLicenceNode == null && systemLicenceNode == null) {
            LOG.warn("licence code could not be retrieved - using default licence!");
            return DEFAULT_FILENAME;
        }
        String userLicence = "";
        boolean userLicenceValid = false;
        if (userLicenceNode != null) {
            userLicence = userLicenceNode.get(LICENCE, "").trim();
            userLicenceValid = !userLicence.isEmpty() && this.periodValid(userLicence);
        }
        String systemLicence = "";
        boolean systemLicenceAvailable = false;
        if (systemLicenceNode != null) {
            systemLicence = systemLicenceNode.get(LICENCE, "").trim();
            boolean bl = systemLicenceAvailable = !systemLicence.isEmpty();
        }
        if (systemLicenceAvailable && userLicenceNode != null && !userLicence.equalsIgnoreCase(systemLicence)) {
            licenceKeyEngine = new LicenceKeyEngine(systemLicence);
            String systemLicenceCode = licenceKeyEngine.getLicenceKey();
            userLicenceNode.put(LICENCE, systemLicenceCode);
            userLicenceNode.remove(PERIOD);
            userLicenceNode.put(PERIOD, ProductLicence.toPeriod(new Date()));
            try {
                userLicenceNode.flush();
            }
            catch (BackingStoreException ex) {
                LOG.error("cannot persist system licence: '{}' as user licence!", (Object)systemLicenceCode);
            }
            catch (Exception thr) {
                LOG.error("wrong system licence key: '{}' - checking user licence key now!", (Object)systemLicenceCode);
            }
            userLicence = userLicenceNode.get(LICENCE, "").trim();
            boolean bl = userLicenceValid = !userLicence.isEmpty() && this.periodValid(userLicence);
        }
        if (userLicenceValid) {
            try {
                licenceKeyEngine = new LicenceKeyEngine(userLicence);
                byte edition = licenceKeyEngine.getEdition();
                switch (edition) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return BASIC_FILENAME;
                    }
                    case 2: {
                        return BASIC_YEAR_FILENAME;
                    }
                    case 3: {
                        return PROF_FILENAME;
                    }
                    default: {
                        LOG.error("licence type {} is unknown - using default licence!", (Object)edition);
                        break;
                    }
                }
            }
            catch (Exception thr) {
                LOG.error("wrong user licence key: {} - using default licence!", (Object)userLicence);
            }
        }
        return DEFAULT_FILENAME;
    }

    private boolean isSignatureValid(File configFile, InputStream cerInS) {
        boolean bl;
        X509Certificate x509 = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509 = (X509Certificate)cf.generateCertificate(cerInS);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return false;
        }
        FileInputStream signedXML = new FileInputStream(configFile);
        try {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            certificates.add(x509);
            CollectionCertStoreParameters certStoreParameters = new CollectionCertStoreParameters(certificates);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, Config.getSecurityProvider().getName());
            bl = SimpleXMLSignatureValidator.checkSignature((InputStream)signedXML, null, (CertStore)certStore);
        }
        catch (Throwable throwable) {
            try {
                try {
                    signedXML.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
                return false;
            }
        }
        signedXML.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createTempFile(InputStream inS) throws IOException {
        File tempFile = File.createTempFile(LICENCE, ".xml");
        try (FileOutputStream outS = new FileOutputStream(tempFile);){
            int read;
            byte[] buf = new byte[4096];
            while ((read = inS.read(buf)) != -1) {
                if (read < 0) continue;
                outS.write(buf, 0, read);
            }
        }
        finally {
            Utils.closeStream(inS);
        }
        return tempFile;
    }

    @Override
    protected LicenceTyp getDefault(String key, LicenceTyp defaultType) {
        return defaultType;
    }

    private boolean periodValid(String userLicence) {
        Date periodDate;
        Preferences licenceNode;
        try {
            licenceNode = Preferences.userRoot().node(BOREUM_PREF_NODE);
        }
        catch (Exception e) {
            return false;
        }
        if (licenceNode == null) {
            return false;
        }
        try {
            periodDate = ProductLicence.periodToDate(licenceNode.get(PERIOD, ""));
        }
        catch (ParseException e) {
            return false;
        }
        Date todayDate = new Date();
        long today = todayDate.getTime();
        long periodStart = periodDate.getTime();
        long licencePeriodUsed = today - periodStart;
        long oneDay = 86400000L;
        long oneYear = 365L;
        LicenceKeyEngine licenceKeyEngine = new LicenceKeyEngine(userLicence);
        byte edition = licenceKeyEngine.getEdition();
        switch (edition) {
            case 0: {
                return false;
            }
            case 1: 
            case 3: {
                return true;
            }
            case 2: 
            case 4: {
                return this.hasDaysFree(oneYear - licencePeriodUsed / oneDay);
            }
        }
        LOG.error("licence type '{}' is unknown - using default licence!", (Object)edition);
        return false;
    }

    private boolean hasDaysFree(long openDays) {
        long oneYear = 365L;
        return openDays >= 0L && openDays <= oneYear;
    }

    protected static String toPeriod(Date periodDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        return Base64.getEncoder().encodeToString(dateFormat.format(periodDate).getBytes(StandardCharsets.UTF_8));
    }

    protected static Date periodToDate(String periodFromLicenceNode) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        return df.parse(new String(Base64.getDecoder().decode(periodFromLicenceNode), StandardCharsets.UTF_8));
    }
}

