/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.licence;

import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.StepI;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.licence.DynamicLicence;
import de.bos_bremen.ecard.client.model.licence.Licence;
import de.bos_bremen.ecard.client.model.licence.LicenceI;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductLicence;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProductFunctions
implements LicenceI {
    private static final Logger LOG = LogManager.getLogger(ProductFunctions.class);
    DynamicLicence dynamicLicence = new DynamicLicence();
    ProductLicence productLicence = new ProductLicence();
    private static ProductFunctions instance;

    public static synchronized ProductFunctions getInstance() {
        if (instance == null) {
            instance = new ProductFunctions();
        }
        return instance;
    }

    private ProductFunctions() {
    }

    private LicenceTyp getLicenceTyp(LicenceTyp licence1, LicenceTyp licence2) {
        if (licence1 != null) {
            return licence1.mask(licence2);
        }
        return LicenceTyp.disable;
    }

    @Override
    public LicenceTyp enableGeneralMenu() {
        return this.getLicenceTyp(this.productLicence.enableGeneralMenu(), this.dynamicLicence.enableGeneralMenu());
    }

    @Override
    public LicenceTyp enableGeneralActions() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActions(), this.dynamicLicence.enableGeneralActions());
    }

    @Override
    public LicenceTyp enableGeneralActionsExport() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsExport(), this.dynamicLicence.enableGeneralActionsExport());
    }

    @Override
    public LicenceTyp enableGeneralActionsImport() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsImport(), this.dynamicLicence.enableGeneralActionsImport());
    }

    @Override
    public LicenceTyp enableGeneralActionsReset() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsReset(), this.dynamicLicence.enableGeneralActionsReset());
    }

    @Override
    public LicenceTyp enableGeneralActionsSaveConfig() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsSaveConfig(), this.dynamicLicence.enableGeneralActionsSaveConfig());
    }

    @Override
    public LicenceTyp enableGeneralActionsSettings() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsSettings(), this.dynamicLicence.enableGeneralActionsSettings());
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsProtocol() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsSettingsProtocol(), this.dynamicLicence.enableGeneralActionsSettingsProtocol());
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsProxyserver() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsSettingsProxyserver(), this.dynamicLicence.enableGeneralActionsSettingsProxyserver());
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsReset() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsSettingsReset(), this.dynamicLicence.enableGeneralActionsSettingsReset());
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsSplashScreen() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsSettingsSplashScreen(), this.dynamicLicence.enableGeneralActionsSettingsSplashScreen());
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsSubsequentProcess() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsSettingsSubsequentProcess(), this.dynamicLicence.enableGeneralActionsSettingsSubsequentProcess());
    }

    @Override
    public LicenceTyp enableGeneralIntegratedWS() {
        return this.getLicenceTyp(this.productLicence.enableGeneralIntegratedWS(), this.dynamicLicence.enableGeneralIntegratedWS());
    }

    @Override
    public LicenceTyp enableGeneralLicence() {
        return this.getLicenceTyp(this.productLicence.enableGeneralLicence(), this.dynamicLicence.enableGeneralLicence());
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsLanguage() {
        return this.getLicenceTyp(this.productLicence.enableGeneralActionsSettingsLanguage(), this.dynamicLicence.enableGeneralActionsSettingsLanguage());
    }

    public void loadDynamicLicence(String xmlContentString) {
        if (xmlContentString == null || xmlContentString.trim().isEmpty()) {
            return;
        }
        LOG.debug("try load dynamic license : \n{}", (Object)xmlContentString);
        try {
            DynamicLicence tempDynamicLicence = new DynamicLicence();
            tempDynamicLicence.load(new ByteArrayInputStream(xmlContentString.getBytes(StandardCharsets.UTF_8)));
            this.dynamicLicence = tempDynamicLicence;
            LOG.trace("Dynamische Lizenz -> gui update");
            LocaleChanger.getInstance().setLocale(Config.getInstance().getLocale(), true);
        }
        catch (IOException e) {
            LOG.info("loadDynamicLicence() failed : {}", (Object)xmlContentString);
            LOG.debug((Object)e, (Throwable)e);
        }
        LOG.debug("loadDynamicLicence() - > finished");
    }

    public LicenceTyp getLicence(StepI step) {
        String licenceKey = ((Step)step).getLicenceTypKey();
        return this.getLicence(licenceKey);
    }

    public LicenceTyp getLicence(String key) {
        return this.getLicenceTyp(this.productLicence.getLicence(key, LicenceTyp.disable), this.dynamicLicence.getLicence(key, LicenceTyp.disable));
    }

    public LicenceTyp getLicence(String key, LicenceTyp defaultLicenceTyp) {
        return this.getLicenceTyp(this.productLicence.getLicence(key, defaultLicenceTyp), this.dynamicLicence.getLicence(key, defaultLicenceTyp));
    }

    public String getProductLicence() {
        return Licence.toString(this.productLicence.getLicenceMap());
    }

    public String getDynamicLicence() {
        return Licence.toString(this.dynamicLicence.getLicenceMap());
    }
}

