/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.licence;

import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class LicenceKeyEngine {
    private static final int MAX_EDITION_CHARS = 1;
    private static final int MAX_KDNR_CHARS = 4;
    private static final int BLOCK1LENGTH = 11;
    private static final int MAX_RADIX = 36;
    private static final SecureRandom RAND = new SecureRandom();
    private byte edition = (byte)-1;
    private int kundenNummer = -1;
    private final String licenceKey;

    public LicenceKeyEngine(int kdNr, byte edition) throws NoSuchAlgorithmException {
        this(kdNr, edition, LicenceKeyEngine.generateDynamicOrder());
    }

    public LicenceKeyEngine(int kdNr, byte edition, int order) {
        this.licenceKey = this.generate(kdNr, edition, order);
    }

    public LicenceKeyEngine(String lk) {
        int indexOf = -1;
        while ((indexOf = ((String)lk).indexOf("-")) != -1) {
            if (indexOf < ((String)lk).length()) {
                lk = ((String)lk).substring(0, indexOf) + ((String)lk).substring(indexOf + 1);
                continue;
            }
            lk = ((String)lk).substring(0, indexOf);
        }
        this.licenceKey = lk;
        this.checkLicence(this.licenceKey);
    }

    public byte getEdition() {
        return this.edition;
    }

    public int getKundennummer() {
        return this.kundenNummer;
    }

    public String getLicenceKey() {
        return this.licenceKey;
    }

    public String getFormattedLicenceKey() {
        if (this.licenceKey != null && this.licenceKey.length() == 16) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.licenceKey.substring(0, 4));
            builder.append("-");
            builder.append(this.licenceKey.substring(4, 8));
            builder.append("-");
            builder.append(this.licenceKey.substring(8, 12));
            builder.append("-");
            builder.append(this.licenceKey.substring(12, 16));
            return builder.toString();
        }
        if (this.licenceKey != null) {
            return this.licenceKey;
        }
        return null;
    }

    private static int generateDynamicOrder() throws NoSuchAlgorithmException {
        int mask;
        int kdnrOrder = 0;
        int editionOrder = 0;
        SecureRandom rand = SecureRandom.getInstanceStrong();
        int counter = 0;
        while (counter < 4) {
            mask = rand.nextInt(10);
            if ((kdnrOrder & (mask = 1 << mask)) != 0) continue;
            kdnrOrder = (short)(kdnrOrder | mask);
            ++counter;
        }
        counter = 0;
        while (counter < 1) {
            mask = rand.nextInt(10);
            if ((editionOrder & (mask = 1 << mask)) != 0 || (kdnrOrder & mask) != 0) continue;
            editionOrder = (short)(editionOrder | mask);
            ++counter;
        }
        int order = kdnrOrder << 10;
        return order += editionOrder;
    }

    private String generate(int kdNr, byte edition, int order) throws IllegalArgumentException {
        this.edition = edition;
        this.kundenNummer = kdNr;
        if (kdNr > 99999 || kdNr < 1) {
            throw new IllegalArgumentException("invalid customer number " + kdNr);
        }
        this.checkOrder(order);
        short editionOrder = LicenceKeyEngine.getEditionOrder(order);
        String editionString = this.getEditionString();
        short kdNrOrder = LicenceKeyEngine.getKdNrOrder(order);
        String kdNrString = this.getKundennummerString();
        if ((editionOrder & kdNrOrder) != 0) {
            throw new IllegalArgumentException("invalid order order " + LicenceKeyEngine.toBinaryString(kdNrOrder) + " : " + LicenceKeyEngine.toBinaryString(editionOrder));
        }
        StringBuilder sb = new StringBuilder();
        int editionLength = 0;
        int kdNrLength = 0;
        for (int i = 1024; i != 0; i >>= 1) {
            if ((editionOrder & i) != 0) {
                sb.append(editionString.charAt(editionLength++));
                continue;
            }
            if ((kdNrOrder & i) != 0) {
                sb.append(kdNrString.charAt(kdNrLength++));
                continue;
            }
            sb.append(Integer.toString(RAND.nextInt(37), 36).charAt(0));
        }
        String checksum = Integer.toString(LicenceKeyEngine.checksum(Long.valueOf(sb.toString().toUpperCase(), 36), order), 36);
        sb.append(this.getOrderString(order));
        sb.insert(11, checksum.charAt(0));
        return sb.toString().toUpperCase();
    }

    private void checkOrder(int order) {
        if (order > Integer.parseInt("11110000000000100000", 2) || order < Integer.parseInt("00000011110000010000", 2)) {
            throw new InvalidParameterException("invalid order size " + Integer.toBinaryString(order));
        }
    }

    private void checkLicence(String licenceKey) throws IllegalArgumentException {
        if (licenceKey.length() != 16) {
            throw new InvalidParameterException("Licencekey length not 16");
        }
        String orderStr = licenceKey.substring(12);
        int order = Integer.parseInt(orderStr, 36);
        String checkSumStr = licenceKey.substring(11, 12);
        short kdnrOrder = LicenceKeyEngine.getKdNrOrder(order);
        short editionOrder = LicenceKeyEngine.getEditionOrder(order);
        boolean valid = checkSumStr.equals(Integer.toString(LicenceKeyEngine.checksum(Long.valueOf(licenceKey.substring(0, 11), 36), Integer.parseInt(orderStr, 36)), 36).toUpperCase());
        if (!valid) {
            throw new InvalidParameterException("checksum not valid");
        }
        StringBuilder editionStr = new StringBuilder();
        StringBuilder kdnrStr = new StringBuilder();
        int counter = 0;
        for (int i = 1024; i != 0; i >>= 1) {
            if ((editionOrder & i) != 0) {
                editionStr.append(licenceKey.substring(counter, counter + 1));
            } else if ((kdnrOrder & i) != 0) {
                kdnrStr.append(licenceKey.substring(counter, counter + 1));
            }
            ++counter;
        }
        this.edition = Byte.parseByte(editionStr.toString(), 36);
        this.kundenNummer = Integer.parseInt(kdnrStr.toString(), 36);
    }

    private static short getKdNrOrder(int order) {
        return (short)(order >> 10);
    }

    private static short getEditionOrder(int order) {
        int size = 20;
        return (short)(order & (1 << size / 2) - 1);
    }

    private static String toBinaryString(int zahl) {
        Object result = "";
        for (int i = 0; i < 20; ++i) {
            result = (zahl & 1 << i) != 0 ? "1" + (String)result : "0" + (String)result;
        }
        return result;
    }

    private static int checksum(long value, int order) {
        int checksum;
        do {
            checksum = 0;
            while (value != 0L) {
                checksum = (int)((long)checksum + value % 10L);
                value /= 10L;
            }
        } while ((value = (long)checksum) / 36L != 0L);
        value += (long)order;
        do {
            checksum = 0;
            while (value != 0L) {
                checksum = (int)((long)checksum + value % 10L);
                value /= 10L;
            }
        } while ((value = (long)checksum) / 36L != 0L);
        return (int)value;
    }

    private String getKundennummerString() {
        Object result = Integer.toString(this.kundenNummer, 36);
        while (((String)result).length() < 4) {
            result = "0" + (String)result;
        }
        return result;
    }

    private String getEditionString() {
        Object result = Integer.toString(this.edition, 36);
        while (((String)result).length() < 1) {
            result = "0" + (String)result;
        }
        return result;
    }

    private String getOrderString(int order) {
        Object result = Integer.toString(order, 36);
        while (((String)result).length() < 4) {
            result = "0" + (String)result;
        }
        return result;
    }
}

