/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.licence;

import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.licence.LicenceI;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Licence
implements LicenceI {
    private static final Logger LOG = LogManager.getLogger(Licence.class);
    HashMap<String, LicenceTyp> licenceMap = new HashMap();
    private LicenceTyp enableGeneralIntegratedWS;
    private LicenceTyp enableGeneralLicence;
    private LicenceTyp enableGeneralMenu;
    private LicenceTyp enableGeneralActions;
    private LicenceTyp enableGeneralActionsSettings;
    private LicenceTyp enableGeneralActionsSettingsSplashScreen;
    private LicenceTyp enableGeneralActionsSettingsProtocol;
    private LicenceTyp enableGeneralActionsSettingsSubsequentProcess;
    private LicenceTyp enableGeneralActionsSettingsProxyserver;
    private LicenceTyp enableGeneralActionsSettingsLanguage;
    private LicenceTyp enableGeneralActionsSettingsReset;
    private LicenceTyp enableGeneralActionsImport;
    private LicenceTyp enableGeneralActionsSaveAction;
    private LicenceTyp enableGeneralActionsExport;
    private LicenceTyp enableGeneralActionsReset;

    protected abstract LicenceTyp getDefault(String var1, LicenceTyp var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream in) throws IOException {
        this.licenceMap = new HashMap();
        XMLProperties props = new XMLProperties();
        try {
            XMLProperties propertiesForNodeRoot;
            props.loadFromXML(in);
            XMLProperties propertiesForNode = props.getPropertiesForNode("Object");
            if (propertiesForNode != null && propertiesForNode.size() != 0) {
                props = propertiesForNode;
            }
            if ((propertiesForNodeRoot = props.getPropertiesForNode("root")) != null && propertiesForNodeRoot.size() != 0) {
                props = propertiesForNodeRoot;
            }
            this.loadGeneralProperties(props);
            this.maskGeneralProperties();
            this.fillGeneralHashMap();
            for (ProcessI process : Document.getInstance().getProcessFactory().getProcesses()) {
                HashMap<String, LicenceTyp> processHashMap = this.loadProcessProperties(props, process);
                this.maskProcessProperties(process, processHashMap);
                this.fillHashMap(processHashMap);
            }
        }
        catch (Exception e) {
            LOG.error("load license failed");
            if (e.getMessage() != null && !e.getMessage().isEmpty() && e.getMessage().indexOf("Premature end of file.") != 0) {
                LOG.error("", (Throwable)e);
            }
        }
        finally {
            this.loadGeneralProperties(props);
            this.maskGeneralProperties();
            this.fillGeneralHashMap();
        }
    }

    private void maskProcessProperties(ProcessI process, HashMap<String, LicenceTyp> processHashMap) {
        this.maskProcessProperties("process/" + process.getProcessName().getName(), processHashMap);
    }

    private void maskProcessProperties(String parentKey, HashMap<String, LicenceTyp> processHashMap) {
        LicenceTyp parent = processHashMap.get(parentKey);
        Set<Map.Entry<String, LicenceTyp>> processChildEntrySet = this.getChildEntrySet(parentKey, processHashMap);
        if (processChildEntrySet != null && !processChildEntrySet.isEmpty()) {
            for (Map.Entry<String, LicenceTyp> entry : processChildEntrySet) {
                processHashMap.put(entry.getKey(), entry.getValue().mask(parent));
            }
            for (Map.Entry<String, LicenceTyp> entry : processChildEntrySet) {
                this.maskProcessProperties(entry.getKey(), processHashMap);
            }
        }
    }

    private Set<Map.Entry<String, LicenceTyp>> getChildEntrySet(String parentKey, HashMap<String, LicenceTyp> processHashMap) {
        HashMap<String, LicenceTyp> childs = new HashMap<String, LicenceTyp>();
        for (String key : processHashMap.keySet()) {
            if (!key.startsWith(parentKey) || key.length() <= parentKey.length() || key.substring(parentKey.length() + 1).indexOf(47) != -1) continue;
            childs.put(key, processHashMap.get(key));
        }
        return childs.entrySet();
    }

    private void loadGeneralProperties(XMLProperties props) {
        this.enableGeneralIntegratedWS = this.getLicence(Keys.general_integrated.toString(), LicenceTyp.disable, props);
        this.enableGeneralLicence = this.getLicence(Keys.general_licence.toString(), LicenceTyp.enable, props);
        this.enableGeneralMenu = this.getLicence(Keys.general_menu.toString(), LicenceTyp.disable, props);
        this.enableGeneralActions = this.getLicence(Keys.general_actions.toString(), LicenceTyp.disable, props);
        this.enableGeneralActionsSettings = this.getLicence(Keys.general_actions_settings.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsSettingsSplashScreen = this.getLicence(Keys.general_actions_settings_splashscreen.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsSettingsProtocol = this.getLicence(Keys.general_actions_settings_protocol.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsSettingsSubsequentProcess = this.getLicence(Keys.general_actions_settings_subsequentprocess.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsSettingsProxyserver = this.getLicence(Keys.general_actions_settings_proxyserver.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsSettingsLanguage = this.getLicence(Keys.general_actions_settings_language.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsSettingsReset = this.getLicence(Keys.general_actions_settings_reset.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsImport = this.getLicence(Keys.general_actions_import.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsExport = this.getLicence(Keys.general_actions_export.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsReset = this.getLicence(Keys.general_actions_reset.toString(), LicenceTyp.enable, props);
        this.enableGeneralActionsSaveAction = this.getLicence(Keys.general_actions_saveconfig.toString(), LicenceTyp.enable, props);
    }

    private HashMap<String, LicenceTyp> loadProcessProperties(XMLProperties props, ProcessI process) {
        HashMap<String, LicenceTyp> defaultMap = process.getDefaultLicenceTypes();
        HashMap<String, LicenceTyp> resultMap = new HashMap<String, LicenceTyp>();
        for (Map.Entry<String, LicenceTyp> entry : defaultMap.entrySet()) {
            resultMap.put(entry.getKey(), this.getLicence(entry.getKey(), entry.getValue(), props));
        }
        return resultMap;
    }

    private LicenceTyp getLicence(String key, LicenceTyp defaultLicence, XMLProperties props) {
        return LicenceTyp.valueOf(props.getProperty(key, this.getDefault(key, defaultLicence).toString()));
    }

    private void maskGeneralProperties() {
        this.enableGeneralActionsSettings = this.enableGeneralActionsSettings.mask(this.enableGeneralActions);
        this.enableGeneralActionsSettingsSplashScreen = this.enableGeneralActionsSettingsSplashScreen.mask(this.enableGeneralActionsSettings);
        this.enableGeneralActionsSettingsProtocol = this.enableGeneralActionsSettingsProtocol.mask(this.enableGeneralActionsSettings);
        this.enableGeneralActionsSettingsSubsequentProcess = this.enableGeneralActionsSettingsSubsequentProcess.mask(this.enableGeneralActionsSettings);
        this.enableGeneralActionsSettingsProxyserver = this.enableGeneralActionsSettingsProxyserver.mask(this.enableGeneralActionsSettings);
        this.enableGeneralActionsSettingsLanguage = this.enableGeneralActionsSettingsLanguage.mask(this.enableGeneralActionsSettings);
        this.enableGeneralActionsSettingsReset = this.enableGeneralActionsSettingsReset.mask(this.enableGeneralActionsSettings);
        this.enableGeneralActionsImport = this.enableGeneralActionsImport.mask(this.enableGeneralActions);
        this.enableGeneralActionsExport = this.enableGeneralActionsExport.mask(this.enableGeneralActions);
        this.enableGeneralActionsReset = this.enableGeneralActionsReset.mask(this.enableGeneralActions);
        this.enableGeneralActionsSaveAction = this.enableGeneralActionsSaveAction.mask(this.enableGeneralActions);
    }

    protected void setDefaultValues() {
        this.enableGeneralIntegratedWS = this.getDefault(Keys.general_integrated.toString(), LicenceTyp.enable);
        this.enableGeneralLicence = this.getDefault(Keys.general_licence.toString(), LicenceTyp.enable);
        this.enableGeneralMenu = this.getDefault(Keys.general_menu.toString(), LicenceTyp.enable);
        this.enableGeneralActions = this.getDefault(Keys.general_actions.toString(), LicenceTyp.enable);
        this.enableGeneralActionsSettings = this.getDefault(Keys.general_actions_settings.toString(), LicenceTyp.enable);
        this.enableGeneralActionsSettingsSplashScreen = this.getDefault(Keys.general_actions_settings_splashscreen.toString(), LicenceTyp.enable);
        this.enableGeneralActionsSettingsProtocol = this.getDefault(Keys.general_actions_settings_protocol.toString(), LicenceTyp.enable);
        this.enableGeneralActionsSettingsSubsequentProcess = this.getDefault(Keys.general_actions_settings_subsequentprocess.toString(), LicenceTyp.enable);
        this.enableGeneralActionsSettingsProxyserver = this.getDefault(Keys.general_actions_settings_proxyserver.toString(), LicenceTyp.enable);
        this.enableGeneralActionsSettingsLanguage = this.getDefault(Keys.general_actions_settings_language.toString(), LicenceTyp.enable);
        this.enableGeneralActionsSettingsReset = this.getDefault(Keys.general_actions_settings_reset.toString(), LicenceTyp.enable);
        this.enableGeneralActionsImport = this.getDefault(Keys.general_actions_import.toString(), LicenceTyp.enable);
        this.enableGeneralActionsExport = this.getDefault(Keys.general_actions_export.toString(), LicenceTyp.enable);
        this.enableGeneralActionsReset = this.getDefault(Keys.general_actions_reset.toString(), LicenceTyp.enable);
        this.enableGeneralActionsSaveAction = this.getDefault(Keys.general_actions_saveconfig.toString(), LicenceTyp.enable);
    }

    protected void fillHashMap(HashMap<String, LicenceTyp> hashMap) {
        this.licenceMap.putAll(hashMap);
    }

    protected void fillGeneralHashMap() {
        this.licenceMap.put(Keys.general_menu.toString(), this.enableGeneralMenu);
        this.licenceMap.put(Keys.general_integrated.toString(), this.enableGeneralIntegratedWS);
        this.licenceMap.put(Keys.general_licence.toString(), this.enableGeneralLicence);
        this.licenceMap.put(Keys.general_actions.toString(), this.enableGeneralActions);
        this.licenceMap.put(Keys.general_actions_settings.toString(), this.enableGeneralActionsSettings);
        this.licenceMap.put(Keys.general_actions_settings_splashscreen.toString(), this.enableGeneralActionsSettingsSplashScreen);
        this.licenceMap.put(Keys.general_actions_settings_protocol.toString(), this.enableGeneralActionsSettingsProtocol);
        this.licenceMap.put(Keys.general_actions_settings_subsequentprocess.toString(), this.enableGeneralActionsSettingsSubsequentProcess);
        this.licenceMap.put(Keys.general_actions_settings_proxyserver.toString(), this.enableGeneralActionsSettingsProxyserver);
        this.licenceMap.put(Keys.general_actions_settings_language.toString(), this.enableGeneralActionsSettingsLanguage);
        this.licenceMap.put(Keys.general_actions_settings_reset.toString(), this.enableGeneralActionsSettingsReset);
        this.licenceMap.put(Keys.general_actions_import.toString(), this.enableGeneralActionsImport);
        this.licenceMap.put(Keys.general_actions_export.toString(), this.enableGeneralActionsExport);
        this.licenceMap.put(Keys.general_actions_reset.toString(), this.enableGeneralActionsReset);
        this.licenceMap.put(Keys.general_actions_saveconfig.toString(), this.enableGeneralActionsSaveAction);
    }

    @Override
    public LicenceTyp enableGeneralMenu() {
        return this.enableGeneralMenu;
    }

    @Override
    public LicenceTyp enableGeneralActions() {
        return this.enableGeneralActions;
    }

    @Override
    public LicenceTyp enableGeneralActionsExport() {
        return this.enableGeneralActionsExport;
    }

    @Override
    public LicenceTyp enableGeneralActionsImport() {
        return this.enableGeneralActionsImport;
    }

    @Override
    public LicenceTyp enableGeneralActionsReset() {
        return this.enableGeneralActionsReset;
    }

    @Override
    public LicenceTyp enableGeneralActionsSaveConfig() {
        return this.enableGeneralActionsSaveAction;
    }

    @Override
    public LicenceTyp enableGeneralActionsSettings() {
        return this.enableGeneralActionsSettings;
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsProtocol() {
        return this.enableGeneralActionsSettingsProtocol;
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsProxyserver() {
        return this.enableGeneralActionsSettingsProxyserver;
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsLanguage() {
        return this.enableGeneralActionsSettingsLanguage;
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsReset() {
        return this.enableGeneralActionsSettingsReset;
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsSplashScreen() {
        return this.enableGeneralActionsSettingsSplashScreen;
    }

    @Override
    public LicenceTyp enableGeneralActionsSettingsSubsequentProcess() {
        return this.enableGeneralActionsSettingsSubsequentProcess;
    }

    @Override
    public LicenceTyp enableGeneralIntegratedWS() {
        return this.enableGeneralIntegratedWS;
    }

    @Override
    public LicenceTyp enableGeneralLicence() {
        return this.enableGeneralLicence;
    }

    public LicenceTyp getLicence(String key, LicenceTyp defaultType) {
        if (this.licenceMap.containsKey(key)) {
            return this.licenceMap.get(key);
        }
        return this.getDefault(key, defaultType);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Licence) {
            Licence licenceObj = (Licence)obj;
            if (obj.getClass() == this.getClass()) {
                return this.licenceMap.equals(licenceObj.licenceMap);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.licenceMap.hashCode();
    }

    public Map<String, LicenceTyp> getLicenceMap() {
        return this.licenceMap;
    }

    public static String toString(Map<String, LicenceTyp> licenceMap) {
        String license = licenceMap.toString();
        return license.replace(", ", "\n");
    }

    public static enum Keys {
        general_menu,
        general_integrated,
        general_licence,
        general_actions,
        general_actions_settings,
        general_actions_settings_splashscreen,
        general_actions_settings_protocol,
        general_actions_settings_subsequentprocess,
        general_actions_settings_language,
        general_actions_settings_updateserver,
        general_actions_settings_proxyserver,
        general_actions_settings_reset,
        general_actions_import,
        general_actions_export,
        general_actions_reset,
        general_actions_saveconfig;


        public String toString() {
            return super.toString().replace('_', '/');
        }
    }
}

