/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider.mcard;

import de.bos_bremen.ecard.client.model.keyprovider.mcard.AliasModel;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TerminalModel {
    private static final Logger LOG = LogManager.getLogger(TerminalModel.class);
    private String name;
    private List<AliasModel> aliases;

    public TerminalModel(String name) {
        this.name = name;
        this.aliases = new Vector<AliasModel>();
    }

    public String getName() {
        return this.name;
    }

    public List<AliasModel> getAliases() {
        return this.aliases;
    }

    public void addAlias(AliasModel alias) {
        if (this.aliases.contains(alias)) {
            return;
        }
        LOG.info((Object)alias);
        this.aliases.add(alias);
    }

    public void deleteAlias(String alias) {
        if (alias == null) {
            return;
        }
        for (AliasModel aliasModel : this.aliases) {
            if (!alias.equals(aliasModel.getName())) continue;
            LOG.info(alias);
            this.aliases.remove(aliasModel);
            return;
        }
    }

    public boolean exists(String alias) {
        if (alias == null) {
            return false;
        }
        for (AliasModel aliasModel : this.aliases) {
            if (!alias.equals(aliasModel.getName())) continue;
            LOG.info(alias);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TerminalModel)) {
            return false;
        }
        TerminalModel terminalModel = (TerminalModel)o;
        return this.getName().equals(terminalModel.getName());
    }
}

