/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider.mcard;

import de.bos_bremen.gov2.jca_provider.OCFKeyStoreListener;
import de.bos_bremen.gov2.jca_provider.OCFKeyStoreParameterInputStream;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.swing.event.EventListenerList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OCFHandler {
    private static final Logger LOG = LogManager.getLogger(OCFHandler.class);
    private static OCFHandler handler = null;
    private OCFKeyStoreParameterInputStream parameters;
    private KeyStore keyStore = null;
    private EventListenerList listenerList = new EventListenerList();

    private OCFHandler(OCFKeyStoreParameterInputStream parameters) {
        if (Security.getProvider("OCF") == null) {
            Security.addProvider((Provider)new OCFProvider());
        }
        OCFKeyStoreListener l = new OCFKeyStoreListener(){

            public void aliasAdded(String alias) {
                OCFHandler.this.fireAliasAdded(alias);
            }

            public void aliasRemoved(String alias) {
                OCFHandler.this.fireAliasRemoved(alias);
            }
        };
        this.parameters = parameters;
        if (this.parameters == null) {
            this.parameters = new OCFKeyStoreParameterInputStream();
            this.parameters.setOCFKeyStoreListener(l);
            this.parameters.setOCFProperties(null);
            this.parameters.setOwnerWindow(null);
            this.parameters.setProgressSessionListener(null);
        } else {
            OCFKeyStoreListener originListener = this.parameters.getOCFKeyStoreListener();
            this.parameters.setOCFKeyStoreListener(l);
            this.addListener(originListener);
        }
        this.initOCFKeyStore();
    }

    public static synchronized OCFHandler getInstance(OCFKeyStoreParameterInputStream parameters) {
        if (handler == null) {
            handler = new OCFHandler(parameters);
        } else if (parameters != null && parameters.getOCFKeyStoreListener() != null) {
            handler.addListener(parameters.getOCFKeyStoreListener());
        }
        return handler;
    }

    private synchronized void initOCFKeyStore() {
        try {
            this.keyStore = KeyStore.getInstance("OCF", "OCF");
        }
        catch (KeyStoreException | NoSuchProviderException ex) {
            LOG.error("", (Throwable)ex);
        }
        if (this.keyStore == null) {
            return;
        }
        try {
            this.keyStore.load((InputStream)this.parameters, null);
        }
        catch (Exception ex) {
            LOG.error("Error:  ", (Throwable)ex);
        }
    }

    public synchronized KeyStore getOCFKeyStore() {
        if (this.keyStore == null) {
            this.initOCFKeyStore();
        }
        return this.keyStore;
    }

    public void addListener(OCFKeyStoreListener l) {
        this.listenerList.add(OCFKeyStoreListener.class, l);
    }

    public void removeListener(OCFKeyStoreListener l) {
        this.listenerList.remove(OCFKeyStoreListener.class, l);
    }

    private void fireAliasAdded(String a) {
        for (OCFKeyStoreListener listener : (OCFKeyStoreListener[])this.listenerList.getListeners(OCFKeyStoreListener.class)) {
            listener.aliasAdded(a);
        }
    }

    private void fireAliasRemoved(String a) {
        for (OCFKeyStoreListener listener : (OCFKeyStoreListener[])this.listenerList.getListeners(OCFKeyStoreListener.class)) {
            listener.aliasRemoved(a);
        }
    }
}

