/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider.mcard;

import de.bos_bremen.basecard.terminal.pcsc.PaceCapabilities;
import de.bos_bremen.basecard.terminal.pcsc.PaceConstants;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.common.Filter;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.CertificateHolderAuthorizationTemplate;
import de.bos_bremen.common.asn1.cvc.SignatureTerminals;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.CardTerminalManager;
import de.bos_bremen.gov2.jca_provider.ocf.SecureCard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PACE;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PaceInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminal;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import opencard.core.terminal.CardTerminal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCardUtil {
    private static final Logger LOG = LogManager.getLogger(MCardUtil.class);
    private static final Filter<CardKey> FILTER_KEYS_QUALIFIED_SIGNATURE = new Filter<CardKey>(){

        public Class<CardKey> getFilterClass() {
            return CardKey.class;
        }

        public boolean accept(CardKey key) {
            return (key.getTypeValue() & CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getTypeValue()) == CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getTypeValue();
        }
    };
    private static final Logger LOGGER = LogManager.getLogger(MCardUtil.class);
    private static final SecureCard.SecurityProtocolParameter NPA_SECURE_CARD_SIGNING_CONTEXT_PARAMETER;
    private static final SecureCard.SecurityProtocolParameter TCOS_SC20_SECURE_CARD_SIGNING_CONTEXT_PARAMETER;
    private static final SecureCardEnvironment SECURE_CARD_SIGNING_ENVIRONMENT_NPA;
    private static final SecureCardEnvironment SECURE_CARD_ENVIRONMENT_ALWAYS;

    public static void logMCardVersion() {
        LOGGER.debug("Version of MCard: {}", (Object)OCFProvider.getVersionString());
        LOGGER.debug("MCard uses as CardServiceFactory: {}", (Object)OCFProvider.Settings.getInstance().getCardServiceFactory());
    }

    public static boolean isRFIDComfortTerminal(Terminal terminal) {
        boolean result = false;
        if (terminal != null) {
            result = MCardUtil.isRFIDComfortTerminal(terminal.getCardTerminal());
        }
        return result;
    }

    public static boolean isRFIDComfortTerminal(CardTerminal terminal) {
        List listPaceCapabilities;
        PaceCapabilities paceCapabilities;
        JPCSCCardTerminal pcscCardTerminal;
        Pcsc20Features pcsc20Features;
        boolean result = false;
        if (terminal instanceof JPCSCCardTerminal && (pcsc20Features = (pcscCardTerminal = (JPCSCCardTerminal)terminal).getPcsc20Features()) != null && (paceCapabilities = pcsc20Features.getPaceCapabilities()) != null && (listPaceCapabilities = paceCapabilities.getCapabilitiesList()) != null) {
            result = listPaceCapabilities.contains(PaceConstants.PaceCapabilityEnum.ESIGN);
        }
        return result;
    }

    public static void allocateSecureCardContext(Card card, KeyStore keystore) {
        if (card == null) {
            return;
        }
        SecureCardContext secureCardContext = SecureCardContext.getSecureCardContext(card);
        if (secureCardContext == null) {
            return;
        }
        Collection<CardKey> collectionKeys = secureCardContext.getKeys(card);
        boolean allocate = false;
        for (CardKey cardKey : collectionKeys) {
            if (cardKey.getInfo().getX509Certificate() != null) continue;
            allocate = true;
        }
        if (!allocate) {
            return;
        }
        try {
            GovCS cardService = card.getCardService();
            SecureCard secureCard = (SecureCard)cardService;
            SecureCard.SecurityProtocolResult secureContextAllocationResult = secureCard.allocateSecureContext(secureCardContext.securityProtocol, secureCardContext.securityProtocolParameter);
            if (secureContextAllocationResult.isSecurityProtocolSuccessfulAllocated()) {
                if (!secureCardContext.cardInternallyUpdating) {
                    LOGGER.debug("try externally updating card informations ...");
                    CardTerminalManager.getInstance(null, null, null).fireGovCSRemoved(cardService);
                    CardTerminalManager.getInstance(null, null, null).fireGovCSAdded(cardService);
                }
                LOGGER.debug("aliases after secure context: {}", Collections.list(keystore.aliases()));
            }
            LOGGER.debug("secure card context successfully established");
        }
        catch (Exception e) {
            LOGGER.debug("secure card context allocation failed: {}", (Object)e.getMessage());
        }
    }

    public static int getUsage(boolean[] ku) {
        if (ku == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < ku.length; ++i) {
            if (!ku[i]) continue;
            result += 1 << 7 - i;
        }
        return result;
    }

    static {
        PaceInputParameters tmpNPAPaceInputParameters = null;
        try {
            tmpNPAPaceInputParameters = new PaceInputParameters(PACE.USE_CAN_KEY, null, CertificateHolderAuthorizationTemplate.createFromOIDAndChatMatrix((OID)SignatureTerminals.OID_SIGNATURE_TERMINAL, (byte[])new byte[]{3}), null);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
        }
        NPA_SECURE_CARD_SIGNING_CONTEXT_PARAMETER = tmpNPAPaceInputParameters;
        TCOS_SC20_SECURE_CARD_SIGNING_CONTEXT_PARAMETER = new PaceInputParameters(PACE.USE_CAN_KEY, null, null, null);
        SECURE_CARD_SIGNING_ENVIRONMENT_NPA = card -> {
            boolean result = false;
            if (card != null) {
                return MCardUtil.isRFIDComfortTerminal(card.getTerminal());
            }
            return result;
        };
        SECURE_CARD_ENVIRONMENT_ALWAYS = card -> true;
    }

    private static enum SecureCardContext {
        NPA_SIGN(Card.CardTypeEnum.NPA, SECURE_CARD_SIGNING_ENVIRONMENT_NPA, "MF", SecureCard.SecurityProtocol.EAC2_PACEPLUS, NPA_SECURE_CARD_SIGNING_CONTEXT_PARAMETER, FILTER_KEYS_QUALIFIED_SIGNATURE, false),
        TELESEC_SC20_SIGN(new Card.CardTypeEnum[]{Card.CardTypeEnum.TCOS30_SC20M_RFID, Card.CardTypeEnum.TCOS30_SC20_RFID}, SECURE_CARD_ENVIRONMENT_ALWAYS, new String[]{"MF"}, SecureCard.SecurityProtocol.EAC2_PACE, TCOS_SC20_SECURE_CARD_SIGNING_CONTEXT_PARAMETER, FILTER_KEYS_QUALIFIED_SIGNATURE, false);

        private final List<String> listApplicationNames;
        private final List<Card.CardTypeEnum> listCardTypes;
        private final Filter<CardKey> filterKeys;
        private final List<Integer> listCardTypeValues;
        private final SecureCard.SecurityProtocol securityProtocol;
        private final boolean cardInternallyUpdating;
        private final SecureCardEnvironment environment;
        private final SecureCard.SecurityProtocolParameter securityProtocolParameter;

        private SecureCardContext(Card.CardTypeEnum cardType, SecureCardEnvironment environment, String applicationName, SecureCard.SecurityProtocol securityProtocol, SecureCard.SecurityProtocolParameter securityProtocolParameter, Filter<CardKey> filterKeys, boolean cardInternallyUpdating) {
            this(Arrays.asList(cardType), environment, Arrays.asList(applicationName), securityProtocol, securityProtocolParameter, filterKeys, cardInternallyUpdating);
        }

        private SecureCardContext(Card.CardTypeEnum[] cardTypes, SecureCardEnvironment environment, String[] applicationNames, SecureCard.SecurityProtocol securityProtocol, SecureCard.SecurityProtocolParameter securityProtocolParameter, Filter<CardKey> filterKeys, boolean cardInternallyUpdating) {
            this(Arrays.asList(cardTypes), environment, Arrays.asList(applicationNames), securityProtocol, securityProtocolParameter, filterKeys, cardInternallyUpdating);
        }

        private SecureCardContext(List<Card.CardTypeEnum> listCardTypes, SecureCardEnvironment environment, List<String> listApplicationNames, SecureCard.SecurityProtocol securityProtocol, SecureCard.SecurityProtocolParameter securityProtocolParameter, Filter<CardKey> filterKeys, boolean cardInternallyUpdating) {
            this.listCardTypes = listCardTypes;
            this.listCardTypeValues = new ArrayList<Integer>();
            for (Card.CardTypeEnum cardTypeEnum : listCardTypes) {
                this.listCardTypeValues.add(cardTypeEnum.getTypeValue());
            }
            this.environment = environment;
            this.listApplicationNames = listApplicationNames;
            this.securityProtocol = securityProtocol;
            this.securityProtocolParameter = securityProtocolParameter;
            this.filterKeys = filterKeys;
            this.cardInternallyUpdating = cardInternallyUpdating;
        }

        public List<String> getListApplicationNames() {
            return this.listApplicationNames;
        }

        public List<Card.CardTypeEnum> getListCardTypes() {
            return this.listCardTypes;
        }

        public Filter<CardKey> getFilterKeys() {
            return this.filterKeys;
        }

        public List<Integer> getListCardTypeValues() {
            return this.listCardTypeValues;
        }

        public SecureCard.SecurityProtocol getSecurityProtocol() {
            return this.securityProtocol;
        }

        public boolean isCardInternallyUpdating() {
            return this.cardInternallyUpdating;
        }

        public SecureCardEnvironment getEnvironment() {
            return this.environment;
        }

        public SecureCard.SecurityProtocolParameter getSecurityProtocolParameter() {
            return this.securityProtocolParameter;
        }

        public static SecureCardContext getSecureCardContext(Card card) {
            if (card != null) {
                GovCS cardService = card.getCardService();
                boolean usePINPAD = Boolean.parseBoolean(System.getProperty("use_pinpad", "true"));
                cardService.setKeyboardAllowed(!usePINPAD);
                if (cardService instanceof SecureCard) {
                    SecureCard secureCard = (SecureCard)cardService;
                    for (SecureCardContext secureCardContext : SecureCardContext.values()) {
                        if (!secureCardContext.listCardTypeValues.contains(card.getTypeValue()) || !secureCardContext.environment.isSecureContextSupported(card) || secureCard.getSecurityProtocol() == secureCardContext.securityProtocol || secureCardContext.getKeys(card).isEmpty()) continue;
                        return secureCardContext;
                    }
                }
            }
            return null;
        }

        public Collection<CardKey> getKeys(Card card) {
            if (card != null) {
                return card.getKeyCollection(this.filterKeys, 1);
            }
            return null;
        }

        public String toString() {
            return super.toString() + "\n  CardTypes: " + this.getListCardTypes() + "\n  CardTypesValues: " + this.getListCardTypeValues() + "\n  Applications: " + this.getListApplicationNames() + "\n  Environment: " + this.getEnvironment() + "\n  SecurityProtocol: " + this.getSecurityProtocol() + "\n  SecurityProtocolParameter: " + this.getSecurityProtocolParameter() + "\n  KeyFilter: " + this.getFilterKeys() + "\n  CardInternallyUpdating: " + this.isCardInternallyUpdating();
        }
    }

    private static interface SecureCardEnvironment {
        public boolean isSecureContextSupported(Card var1);
    }
}

