/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider.mcard;

import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AliasModel {
    private static final Logger LOG = LogManager.getLogger(AliasModel.class);
    public static final int NOTINITIALIZED = -1;
    public static final int RETRYCOUTNEREXPIRED = -2;
    public static final int NOTAVAILABLE = -3;
    private String alias;
    private Certificate cert;
    private boolean isKey;
    private int retrycounter = -3;
    private String terminalName;

    public AliasModel(String alias, KeyStore ks) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateEncodingException, ParseException {
        this.alias = alias;
        this.cert = Certificate.forX509((java.security.cert.Certificate)ks.getCertificate(this.alias));
        this.isKey = ks.isKeyEntry(this.alias);
        OCFPrivateKey privateKey = (OCFPrivateKey)ks.getKey(this.alias, null);
        this.retrycounter = -3;
        if (privateKey != null) {
            try {
                GovCS cs = privateKey.getCardService();
                this.terminalName = cs.getCardTerminal().getName();
                this.retrycounter = cs.getRetryCount(privateKey.getOCFCertificatInfo());
            }
            catch (RetryCounterExpiredException ex) {
                this.retrycounter = -2;
            }
            catch (NotYetInitializedException ex) {
                this.retrycounter = -1;
            }
            catch (Exception ex) {
                LOG.info("", (Throwable)ex);
            }
        }
    }

    public Certificate getCertificate() {
        return this.cert;
    }

    public String getDisplayName() {
        if (this.cert == null) {
            return "";
        }
        return JComponentUtils.displayCNandSerialnumber(this.cert);
    }

    public String getName() {
        return this.alias;
    }

    public String getCardTerminalName() {
        return this.terminalName;
    }

    public int hashCode() {
        return this.alias.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AliasModel)) {
            return false;
        }
        AliasModel aliasModel = (AliasModel)o;
        return this.getName().equals(aliasModel.getName());
    }

    public int getRetryCounter() {
        return this.retrycounter;
    }

    public boolean isKeyEntry() {
        return this.isKey;
    }

    public String toString() {
        return this.getDisplayName() + " -> " + this.getCardTerminalName();
    }
}

