/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider;

import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.AliasListener;
import de.bos_bremen.ecard.client.model.keyprovider.CardKey;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.AliasModel;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.MCardUtil;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.OCFHandler;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalListener;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalModel;
import de.bos_bremen.gov2.jca_provider.OCFKeyStoreListener;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.server.BNotK;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import java.io.File;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;

public class TerminalKey
extends AbstractKeyProvider
implements OCFKeyStoreListener {
    private static final String KEYSTORE_ID = "signer_card";
    private Map<String, CardKey> terminals = new HashMap<String, CardKey>();
    private Set<TerminalModel> terminalEntries = new HashSet<TerminalModel>();
    private EventListenerList listenerList = new EventListenerList();

    public TerminalKey(TerminalListener terminalListener, AliasListener aliasListener, KeyProviderStep step, KeyUsage keyUsage) {
        super(null, step, KeyProviderSource.CARD, keyUsage);
        this.addTerminalListener(terminalListener);
        this.addAliasListener(aliasListener);
        OCFHandler.getInstance(null).addListener(this);
        try {
            this.keyStore = KeyStore.getInstance("OCF");
            this.keyStore.load(null, null);
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
        }
    }

    public void addTerminalListener(TerminalListener l) {
        this.listenerList.add(TerminalListener.class, l);
    }

    public void fireTerminalAdded(TerminalModel terminal) {
        for (TerminalListener listener : (TerminalListener[])this.listenerList.getListeners(TerminalListener.class)) {
            listener.terminalAdded(terminal);
        }
    }

    public void fireTerminalRemoved(TerminalModel terminal) {
        for (TerminalListener listener : (TerminalListener[])this.listenerList.getListeners(TerminalListener.class)) {
            listener.terminalRemoved(terminal);
        }
    }

    public void addAliasListener(AliasListener l) {
        this.listenerList.add(AliasListener.class, l);
    }

    public void fireSelectAlias(AbstractKeyProvider keyProvider) {
        LOG.trace("");
        for (AliasListener listener : (AliasListener[])this.listenerList.getListeners(AliasListener.class)) {
            listener.selectAlias(keyProvider);
        }
    }

    @Override
    public String getIFDName() {
        return KEYSTORE_ID + this.keyUsage.toString();
    }

    @Override
    public String getUsageName(String alias) {
        return null;
    }

    @Override
    public void setFileToLoad(File file) {
        throw new IllegalArgumentException("try to load file for smartcard");
    }

    public Set<TerminalModel> getTerminalEntries() {
        return this.terminalEntries;
    }

    @Override
    public List<IFDCurvedToggleIconButton> getIFDCurvedToggleIconButton() {
        LOG.trace("");
        BNotK bNotK = SignerValidationProcessor.getInstance().getBNotK();
        if (bNotK != null && this.keyUsage == KeyUsage.SIGN) {
            LOG.info("BNotK-Fernsignatur wurde aktiviert.");
            LOG.trace("terminals.clear ...");
            this.terminals.clear();
            return Collections.emptyList();
        }
        LOG.trace("terminals.clear ...");
        this.terminals.clear();
        if (this.terminalEntries.isEmpty()) {
            return new ArrayList<IFDCurvedToggleIconButton>();
        }
        for (TerminalModel terminal : this.terminalEntries) {
            CardKey cardKey = new CardKey(terminal, this.step, this.keyUsage);
            this.terminals.put(terminal.getName(), cardKey);
        }
        ArrayList<IFDCurvedToggleIconButton> result = new ArrayList<IFDCurvedToggleIconButton>();
        for (Map.Entry<String, CardKey> entry : this.terminals.entrySet()) {
            String terminalName = entry.getKey();
            CardKey cardKey = entry.getValue();
            String buttonKey = this.getButtonKeyForKeyProviders(this.keyProviderType);
            String buttonText = terminalName;
            if (buttonText != null && !buttonText.isEmpty()) {
                buttonText = MultiLineTooltips.wrapToolTip(buttonText, buttonText.length() / 2, true);
                LOG.trace("button: {} -> {}", (Object)terminalName, (Object)buttonText);
            }
            IFDCurvedToggleIconButton button = new IFDCurvedToggleIconButton(buttonKey, buttonText, cardKey.getKeyProviderEntry(), terminalName);
            LOG.trace("{} : {}", (Object)buttonKey, (Object)button.getText());
            button.setFocusable(true);
            button.setFocusPainted(true);
            button.addActionListener(Document.getInstance().getActionFactory().createIFDSelectionAction(this, terminalName));
            LOG.trace("Terminal Key : add Button : {}", (Object)button.getText());
            result.add(button);
        }
        return result;
    }

    public void aliasAdded(String alias) {
        LOG.trace("KeyUSage: {}", (Object)this.keyUsage);
        if (this.isAliasExists(alias)) {
            return;
        }
        try {
            if (!this.keyStore.isKeyEntry(alias)) {
                return;
            }
            LOG.trace("check certificate for alias... : {}", (Object)alias);
            OCFPrivateKey ocfPrivateKey = (OCFPrivateKey)this.keyStore.getKey(alias, null);
            LOG.trace("card service class... : {}", (Object)ocfPrivateKey.getCardService().getClass().getName());
            MCardUtil.allocateSecureCardContext(ocfPrivateKey.getCardService().getCardObject(), this.keyStore);
            Certificate certificate = Certificate.forX509((java.security.cert.Certificate)this.keyStore.getCertificate(alias));
            if (certificate == null) {
                LOG.debug("Kein {}-Zertifikat gefunden: in Termianl : {}", (Object)this.keyUsage, (Object)alias);
                LOG.trace("return : certificate is null for terminal : {}", (Object)alias);
                return;
            }
            int cardUsage = MCardUtil.getUsage(certificate.getKeyUsage());
            boolean accepted = false;
            for (int mask : this.keyUsageMask) {
                boolean bl = accepted = (cardUsage & mask) == mask;
                if (accepted) break;
            }
            if (!accepted) {
                return;
            }
            LOG.trace("addAliasToTerminal alias : {}", (Object)alias);
            this.addAliasToTerminal(new AliasModel(alias, this.keyStore));
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
        }
    }

    private void addAliasToTerminal(AliasModel alias) {
        String terminalName = alias.getCardTerminalName();
        TerminalModel terminalModel = this.getTerminalModel(terminalName);
        if (terminalModel == null) {
            terminalModel = new TerminalModel(terminalName);
            terminalModel.addAlias(alias);
            this.terminalEntries.add(terminalModel);
            this.fireTerminalAdded(terminalModel);
        } else {
            terminalModel.addAlias(alias);
        }
    }

    private void removeAliasFromTerminal(String alias) {
        for (TerminalModel terminal : this.terminalEntries) {
            terminal.deleteAlias(alias);
            if (!terminal.getAliases().isEmpty()) continue;
            boolean result = this.terminalEntries.remove(terminal);
            if (!result) {
                LOG.warn("could not remove terminal: {}", (Object)terminal);
            }
            this.fireTerminalRemoved(terminal);
        }
    }

    private boolean isAliasExists(String alias) {
        if (this.terminalEntries.isEmpty()) {
            return false;
        }
        for (TerminalModel terminal : this.terminalEntries) {
            if (!terminal.exists(alias)) continue;
            return true;
        }
        return false;
    }

    public TerminalModel getTerminalModel(String name) {
        for (TerminalModel terminal : this.terminalEntries) {
            if (!terminal.getName().startsWith(name)) continue;
            return terminal;
        }
        return null;
    }

    public void aliasRemoved(String alias) {
        this.removeAliasFromTerminal(alias);
    }

    @Override
    public void ifdSelected(String ifdTag) {
        LOG.info("Select Speicherort : {}", (Object)ifdTag);
        CardKey cardKey = this.terminals.get(ifdTag);
        if (cardKey == null) {
            LOG.trace("CardKey is null -> return");
            return;
        }
        LOG.trace("CardKey vorhanden");
        this.fireSelectAlias(cardKey);
        LOG.trace("removeAll- und addKeyprovider to step...");
        this.removeAllKeyProvidersFromStep();
        this.addKeyProviderToStep(cardKey);
    }

    @Override
    public String getDisplayName(String alias) {
        return alias;
    }

    public PrivateKeyResourceImpl getPrivateKeyResourceImpl() {
        return null;
    }
}

