/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider;

import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.keyprovider.SoftwareKey;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SoftwareKeyList
extends AbstractKeyProvider {
    public SoftwareKeyList(KeyProviderStep step, KeyUsage keyUsage) {
        super(null, step, KeyProviderSource.SOFTWARE, keyUsage);
    }

    @Override
    public String getIFDName() {
        return null;
    }

    @Override
    public String getDisplayName(String alias) {
        return null;
    }

    public PrivateKeyResourceImpl getPrivateKeyResourceImpl() {
        return null;
    }

    @Override
    public void setFileToLoad(File file) {
        if (file == null) {
            LOG.debug("No file chosen in the FileChooser.");
            return;
        }
        this.step.setApplicationProperty("last_folder", file.getParent());
        LOG.debug("Selected Keystore File: {}", (Object)file.getAbsolutePath());
        this.setKeyPath(file);
    }

    @Override
    public List<IFDCurvedToggleIconButton> getIFDCurvedToggleIconButton() {
        LOG.trace("");
        ArrayList<IFDCurvedToggleIconButton> result = new ArrayList<IFDCurvedToggleIconButton>();
        String buttonKey = this.getButtonKeyForKeyProviders(this.keyProviderType);
        String buttonText = this.getButtonText(buttonKey, this.getIFDName());
        LOG.trace("{} : {}", (Object)buttonKey, (Object)buttonText);
        LOG.trace("{} : {}", (Object)this.keyProviderType, (Object)this.keyUsage);
        KeyProviderEntry entry = new KeyProviderEntry(this.keyProviderType, this.keyUsage);
        IFDCurvedToggleIconButton button = new IFDCurvedToggleIconButton(buttonKey, buttonText, entry, this.getIFDName());
        button.setFocusable(true);
        button.setFocusPainted(true);
        button.addActionListener(Document.getInstance().getActionFactory().createLoadSoftwareKeyStore(this, true, this.keyUsage == KeyUsage.ENCRYPT));
        LOG.trace("SW Key List : add Button : {}", (Object)button.getText());
        result.add(button);
        return result;
    }

    private void setKeyPath(File keyPath) {
        if (keyPath == null) {
            return;
        }
        SoftwareKey softwareKey = new SoftwareKey(null, this.step, this.keyUsage, false);
        boolean result = softwareKey.setKeyPath(keyPath, false);
        if (!result) {
            return;
        }
        LOG.info("add softwareKey");
        this.addKeyProviderToStep(softwareKey);
    }
}

