/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider;

import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.JX509Certificate;
import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.gui.dialog.SoftKeyPINDialog;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.AliasListener;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;

public class SoftwareKey
extends AbstractKeyProvider {
    private File keyPath;
    private String currentAlias;
    char[] certKeyStorePIN = new char[]{'1', '2', '3', '4', '5', '6'};
    private char[] pinCache;
    private boolean usePinCache = false;
    private static final String KEYSTORE_ID = "signer_softwarekey";
    private EventListenerList listenerList = new EventListenerList();
    private boolean checkValidity;
    private boolean cancelled = false;
    private boolean autoload = true;

    public boolean isAutoload() {
        return this.autoload;
    }

    public SoftwareKey(AliasListener aliasListener, KeyProviderStep step, KeyUsage newKeyUsage, boolean checkValidity) {
        super(null, step, KeyProviderSource.SOFTWARE, newKeyUsage);
        LOG.debug("New SoftwareKey {} : {}", (Object)step.getStepName(), (Object)newKeyUsage);
        this.checkValidity = checkValidity;
        this.addAliasListener(aliasListener);
    }

    public void addAliasListener(AliasListener l) {
        this.listenerList.add(AliasListener.class, l);
    }

    public void fireSelectAlias(AbstractKeyProvider keyProvider) {
        LOG.trace("");
        for (AliasListener listener : (AliasListener[])this.listenerList.getListeners(AliasListener.class)) {
            LOG.trace("listener:keyprovider => {} : {}", (Object)listener.getClass().getSimpleName(), (Object)keyProvider.keyProviderType);
            listener.selectAlias(keyProvider);
        }
    }

    public boolean setKeyPath(File keyFilePath, boolean newCheckValidity) {
        LOG.trace((Object)keyFilePath);
        this.keyPath = keyFilePath;
        if (this.keyPath == null) {
            LOG.trace("");
            this.keyStore = null;
            return false;
        }
        ErrorCode errorCode = null;
        int retryCounter = 0;
        boolean wrongPIN = false;
        do {
            wrongPIN = false;
            try {
                boolean loaded = this.createSoftwareKeyStore(this.keyPath);
                if (loaded) {
                    this.cancelled = false;
                    this.autoload = true;
                }
                LOG.trace("wurde keystore geladen? : {}", (Object)loaded);
                return loaded;
            }
            catch (ParseException e) {
                errorCode = ErrorCode.CANNOT_LOAD_KEYSTORE;
            }
            catch (FileNotFoundException e) {
                errorCode = ErrorCode.KEY_NOT_FOUND;
            }
            catch (NoSuchAlgorithmException e) {
                errorCode = ErrorCode.UNKNOWN_SIG_ALGORITHM;
            }
            catch (KeyStoreException | CertificateException e) {
                errorCode = ErrorCode.UNKNOWN;
            }
            catch (IOException e) {
                if (e.toString().indexOf("Given final block not properly padded") != -1 || e.toString().indexOf("failed to decrypt safe contents entry") != -1 || e.toString().indexOf("wrong password or corrupted file") != -1 || e.toString().indexOf("javax.crypto.BadPaddingException") != -1) {
                    errorCode = ErrorCode.INVALID_PIN;
                    wrongPIN = true;
                    this.pinCache = null;
                    ++retryCounter;
                    LOG.error("{} : {}", (Object)errorCode, (Object)errorCode.getDescription());
                    continue;
                }
                if (e.toString().indexOf("rejects tag type 35") != -1 || e.toString().indexOf("stream does not represent a PKCS12 key store") != -1) {
                    errorCode = ErrorCode.NO_KEYSTORE_FILE;
                    LOG.error("{} : {}", (Object)errorCode, (Object)errorCode.getDescription());
                    continue;
                }
                errorCode = ErrorCode.UNKNOWN;
                LOG.error("{} : {}", (Object)errorCode, (Object)errorCode.getDescription());
                LOG.error("Unerwarteter Fehler: ", (Throwable)e);
            }
        } while (wrongPIN && retryCounter < 2);
        if (errorCode != null) {
            this.keyPath = null;
            Document.getInstance().reportError(errorCode, false, keyFilePath.getAbsolutePath() + "\n");
        }
        return false;
    }

    private boolean createSoftwareKeyStore(File newKeyPath) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, ParseException {
        char[] pin = null;
        this.keyStore = KeyStore.getInstance("PKCS12", Config.getSecurityProvider());
        File tempKsFile = null;
        if (this.keyPath.getName().toLowerCase().endsWith(".cer") || this.keyPath.getName().toLowerCase().endsWith(".crt")) {
            LOG.trace("cer/crt ausgewaelt...");
            try {
                this.keyStore.load(null, null);
                Certificate certificate = new Certificate(newKeyPath);
                this.keyStore.setCertificateEntry(certificate.getSubjectCommonName(), (java.security.cert.Certificate)new JX509Certificate(certificate));
                tempKsFile = File.createTempFile("keyStore", ".p12");
                try (FileOutputStream fileOutS = new FileOutputStream(tempKsFile);){
                    pin = this.certKeyStorePIN;
                    this.keyStore.store(fileOutS, pin);
                }
            }
            catch (KeyStoreException e) {
                LOG.error("", (Throwable)e);
            }
        } else {
            LOG.trace("p12/pfx ausgewaelt...");
            try (FileInputStream inS = new FileInputStream(this.keyPath);){
                LOG.trace("usePinCache ?..");
                boolean askPin = true;
                if (this.usePinCache) {
                    LOG.trace("usePinCache ist aktiviert...");
                    if (this.pinCache == null) {
                        LOG.trace("usePinCache ist aktiviert, aber pinCache ist null -> PIN abfragen...");
                        askPin = true;
                    } else {
                        LOG.trace("usePinCache ist aktiviert: pinCache vorhanden : pinCache -> pin");
                        pin = this.pinCache;
                        askPin = false;
                        LOG.trace("Weiter mit keyStore load...");
                    }
                } else {
                    LOG.trace("usePinCache ist deaktiviert, pinCache ist egal -> immer PIN abfragen.");
                    askPin = true;
                    this.pinCache = null;
                }
                if (askPin) {
                    LOG.trace("PIN abfragen...");
                    pin = this.openPinDialogAndAskPin(this.keyPath.getName());
                }
                if (pin == null || pin.length == 0) {
                    this.cancelled = true;
                    this.autoload = false;
                    LOG.warn("PIN-Eingabe abgebrochen -> keyStore.load nicht moeglich.");
                    LOG.trace("cancelled={} --- autoload={}", (Object)this.cancelled, (Object)this.autoload);
                    boolean bl = false;
                    return bl;
                }
                LOG.trace("PIN eingegeben. Weiter mit keyStore load");
                LOG.trace("keyStore.load : pin vorhanden : ja");
                boolean isGuiVisible = this.isGuiVisible();
                if (!isGuiVisible && !this.cancelled) {
                    LOG.trace("!visible & !cancelled -> keystore load ...");
                    LOG.trace("visible={} ; cancelled={} ; autoload={}", (Object)isGuiVisible, (Object)this.cancelled, (Object)this.autoload);
                    this.keyStore.load(inS, pin);
                    LOG.info("keyStore.load ok.");
                    this.cancelled = false;
                    this.autoload = true;
                } else {
                    if (!isGuiVisible) {
                        LOG.trace("!visible & cancelled  -> keystore load ende.");
                        LOG.trace("visible={} ; cancelled={} ; autoload={}", (Object)isGuiVisible, (Object)this.cancelled, (Object)this.autoload);
                        this.autoload = false;
                        boolean bl = false;
                        return bl;
                    }
                    LOG.trace("visible - true -> keystore load...");
                    LOG.trace("visible={} ; cancelled={} ; autoload={}", (Object)isGuiVisible, (Object)this.cancelled, (Object)this.autoload);
                    this.keyStore.load(inS, pin);
                    LOG.info("keyStore.load ok.");
                    this.cancelled = false;
                    this.autoload = true;
                    LOG.trace("visible={}. Zur\u00fcckgesezt: cancelled={} --- autoload={}", (Object)isGuiVisible, (Object)this.cancelled, (Object)this.autoload);
                }
                if (this.usePinCache) {
                    LOG.trace("usePinCache ist aktiviert");
                    LOG.trace("pin -> pinCache");
                    this.pinCache = pin;
                } else {
                    LOG.trace("usePinCache ist deaktiviert");
                    this.pinCache = null;
                }
            }
        }
        return true;
    }

    private char[] openPinDialogAndAskPin(String filename) {
        LOG.trace("");
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp usePinCacheGui = productFunctions.getLicence("sign/key/software/usePinCache");
        LOG.trace("licence : {} : {}", (Object)"sign/key/software/usePinCache", (Object)usePinCacheGui);
        LOG.trace("von config : {} : {}", (Object)"sign/selectkeys/keyprovider/_0/usePinCache", (Object)this.usePinCache);
        LOG.info("Warte auf PIN-Eingabe fuer SW Schluessel...");
        SoftKeyPINDialog softKeyPINDialog = new SoftKeyPINDialog(filename, SoftKeyPINDialog.ServiceType.SOFTKEY, this.usePinCache);
        int okorcancelled = softKeyPINDialog.getResult();
        if (okorcancelled == 0) {
            LOG.trace("PIN eingegeben fuer: {}", (Object)filename);
            this.usePinCache = softKeyPINDialog.isUsePinCache();
            LOG.trace("Nutzerentscheidung: {}", (Object)(this.usePinCache ? "PIN merken." : "PIN nicht merken."));
            return softKeyPINDialog.getPIN();
        }
        LOG.warn("PIN-Eingabe fuer SW Schluessel {} wurde abgebrochen.", (Object)filename);
        return new char[0];
    }

    @Override
    public List<String> getAllAliases() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.keyStore == null) {
            return result;
        }
        try {
            Enumeration<String> en = this.keyStore.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (!this.validKeyUsage(alias)) continue;
                result.add(alias);
            }
        }
        catch (KeyStoreException ex) {
            LOG.error("", (Throwable)ex);
        }
        return result;
    }

    @Override
    public String getIFDName() {
        return KEYSTORE_ID + this.keyUsage.toString();
    }

    @Override
    public X509Certificate getCertificate() {
        if (this.keyStore == null) {
            LOG.warn("keystore is null");
            return null;
        }
        try {
            return (X509Certificate)this.keyStore.getCertificate(this.getSelectedAlias());
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getSignatureAlgorithm() {
        PrivateKey key = this.getKey();
        if (key instanceof BCECPrivateKey) {
            return "SHA256withECDSA";
        }
        return "SHA256withRSA";
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public PrivateKey getKey() {
        LOG.info("");
        try {
            return (PrivateKey)this.keyStore.getKey(this.getSelectedAlias(), null);
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
            return null;
        }
    }

    public File getProviderKeyFile() {
        return this.keyPath == null ? null : this.keyPath.getAbsoluteFile();
    }

    private boolean isKeyProviderValid() {
        X509Certificate cert = null;
        String alias = null;
        try {
            Enumeration<String> en = this.keyStore.aliases();
            while (en.hasMoreElements()) {
                alias = en.nextElement();
                cert = this.getCertificate(alias);
                if (cert == null) continue;
                cert.checkValidity();
                return true;
            }
        }
        catch (CertificateExpiredException e) {
            Document.getInstance().reportError(ErrorCode.KEY_EXPIRED, false, alias);
        }
        catch (CertificateNotYetValidException e) {
            Document.getInstance().reportError(ErrorCode.KEY_NOT_YET_VALID, false, alias);
        }
        catch (KeyStoreException ex) {
            Document.getInstance().reportError(ErrorCode.UNKNOWN, false, alias);
        }
        return false;
    }

    @Override
    public String getSelectedAlias() {
        if (this.currentAlias == null) {
            this.currentAlias = this.getDefaultAlias();
            LOG.info("currentAlias wird auf getDefault gesetzt: {}", (Object)this.currentAlias);
        }
        return this.currentAlias;
    }

    @Override
    public void setSelectedAlias(String alias) {
        LOG.info("set selected alias: {}", (Object)alias);
        if (alias == null) {
            return;
        }
        if (this.getAllAliases().contains(alias)) {
            this.currentAlias = alias;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SoftwareKey)) {
            return false;
        }
        SoftwareKey keyToCompare = (SoftwareKey)obj;
        if (this.keyPath == null) {
            return false;
        }
        if (this.currentAlias != null) {
            return this.currentAlias.equals(keyToCompare.currentAlias) && this.keyPath.equals(keyToCompare.keyPath) && this.keyUsage.equals((Object)keyToCompare.keyUsage);
        }
        if (keyToCompare.currentAlias != null) {
            return false;
        }
        return this.keyPath.equals(keyToCompare.keyPath) && this.keyUsage.equals((Object)keyToCompare.keyUsage);
    }

    public int hashCode() {
        return super.hashCode() + (this.keyPath != null ? this.keyPath.hashCode() : 815);
    }

    @Override
    public void setFileToLoad(File fileToLoad) {
        LOG.trace("");
        if (fileToLoad == null) {
            LOG.debug("No file choosen in the FileChooser.");
            return;
        }
        this.step.setApplicationProperty("last_folder", fileToLoad.getParent());
        LOG.debug("To select Keystore File: {}", (Object)fileToLoad.getAbsolutePath());
        this.addSoftKeystore(fileToLoad);
    }

    private void addSoftKeystore(File file) {
        LOG.info("Trying to load SoftKeyStore from file: {}", (Object)file);
        if (!this.setKeyPath(file, false)) {
            LOG.trace("KeyStore wurde nicht geladen. ");
            LOG.trace("visible={} ; cancelled={} ; autoload={}", (Object)this.isGuiVisible(), (Object)this.cancelled, (Object)this.autoload);
            return;
        }
        LOG.trace("KeyStore erfolgreich geladen. ");
        LOG.trace("visible={}. Zur\u00fcckgesezt : cancelled={} ; autoload={}", (Object)this.isGuiVisible(), (Object)this.cancelled, (Object)this.autoload);
        LOG.info("SoftKeyStore loaded successfully.");
        LOG.trace("is select keys complete? : {}", (Object)this.step.isStateComplete());
        if (!this.checkValidity || this.isKeyProviderValid()) {
            this.fireSelectAlias(this);
            this.addKeyProviderToStep(this);
            LOG.trace("is select keys complete? : {}", (Object)this.step.isStateComplete());
        } else {
            this.keyStore = null;
            LOG.trace("keyStore = null => is select keys complete? : {}", (Object)this.step.isStateComplete());
        }
    }

    @Override
    public List<IFDCurvedToggleIconButton> getIFDCurvedToggleIconButton() {
        LOG.trace("");
        ArrayList<IFDCurvedToggleIconButton> result = new ArrayList<IFDCurvedToggleIconButton>();
        String buttonKey = this.getButtonKeyForKeyProviders(this.keyProviderType);
        String buttonText = this.getButtonText(buttonKey, this.getIFDName());
        LOG.trace("{} : {}", (Object)buttonKey, (Object)buttonText);
        LOG.trace("{} : {}", (Object)this.keyProviderType, (Object)this.keyUsage);
        KeyProviderEntry entry = new KeyProviderEntry(this.keyProviderType, this.keyUsage);
        IFDCurvedToggleIconButton button = new IFDCurvedToggleIconButton(buttonKey, buttonText, entry, this.getIFDName());
        button.setFocusPainted(true);
        button.addActionListener(Document.getInstance().getActionFactory().createLoadSoftwareKeyStore(this, true, this.keyUsage == KeyUsage.ENCRYPT));
        LOG.trace("SW Key : add Button : {}", (Object)button.getText());
        result.add(button);
        return result;
    }

    @Override
    public String getDisplayName(String alias) {
        return alias;
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        if (this.keyStore == null) {
            LOG.warn("keystore is null");
            return null;
        }
        try {
            return (X509Certificate)this.keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public PrivateKeyResourceImpl getPrivateKeyResourceImpl() {
        try {
            return PrivateKeyResourceImpl.fromKeyStore((String)"alias", (KeyStore)this.getKeyStore(), (String)this.getSelectedAlias());
        }
        catch (IllegalArgumentException e) {
            ErrorCode errorCode = ErrorCode.CANNOT_LOAD_KEYSTORE;
            LOG.error("report ErrorCode : {} : ", (Object)errorCode, (Object)e);
            String specificMessage = " \nAlias ist kein privater Schl\u00fcssel: " + this.getSelectedAlias() + " \nPfad: " + this.keyPath;
            Document.getInstance().reportError(errorCode, false, specificMessage);
        }
        catch (Exception e) {
            ErrorCode errorCode = ErrorCode.UNKNOWN;
            LOG.error("report ErrorCode : {} : ", (Object)errorCode, (Object)e);
            String specificMessage = " \nAlias: " + this.getSelectedAlias() + " \nPfad: " + this.keyPath;
            Document.getInstance().reportError(errorCode, false, specificMessage);
        }
        return null;
    }

    public char[] getPinCache() {
        return this.pinCache;
    }

    public void setPinCache(char[] pinCache) {
        this.pinCache = pinCache;
    }

    public boolean isUsePinCache() {
        LOG.trace("usePinCache : {}", (Object)this.usePinCache);
        return this.usePinCache;
    }

    public void setUsePinCache(boolean usePinCache) {
        LOG.trace("SW Key: usePinCache : {}", (Object)usePinCache);
        this.usePinCache = usePinCache;
    }

    private boolean isGuiVisible() {
        return Document.getInstance().getFrame().isShowing();
    }
}

