/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider;

import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ecard.client.BoreumHttpClient;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.gui.dialog.ConnectServerWaitWindow;
import de.bos_bremen.ecard.client.gui.dialog.ErrorDialog;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.AliasListener;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.keyprovider.SignServiceInterface;
import de.governikus.csc.authentication.keycloak.client.KeycloakAuthClient;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.remote.sign.ClientRemoteSignature;
import de.governikus.csl.remote.sign.exception.RemoteSigningException;
import de.governikus.csl.remote.sign.util.AlgorithmUtil;
import de.governikus.csl.server.AuthService;
import de.governikus.csl.server.SignService;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.ResponseData;
import de.governikus.csl.transport.entity.InputStreamRequest;
import de.governikus.csl.transport.exception.ConnectionException;
import de.governikus.csl.uom.res.KeyFunction;
import de.governikus.csl.uom.res.PrivateKeyResource;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.event.EventListenerList;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.keycloak.adapters.KeycloakDeployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignServiceKey
extends AbstractKeyProvider
implements SignServiceInterface {
    private static final String DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE_AUTHSERVICE = "dialog.error.import.keystore.message.authservice";
    private static final String KEYSTORE_ID = "signer_signservice";
    private static final String ERROR_IMPORT = "error.import";
    private static final String DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE = "dialog.error.import.keystore.message";
    private List<Certificate> certs = null;
    private String selectedAlias = null;
    private List<PrivateKeyResource> privateKeyResources;
    private final EventListenerList listenerList = new EventListenerList();
    private static final List<String> defaultFilter = Arrays.asList("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256-ansi", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384-ansi", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512-ansi");

    public SignServiceKey(AliasListener aliasListener, KeyProviderStep step, KeyUsage keKeyUsage) {
        super(null, step, KeyProviderSource.NET_SIGNER, keKeyUsage);
        this.addAliasListener(aliasListener);
    }

    @Override
    public void setFileToLoad(File file) {
        throw new IllegalArgumentException("try to load file for signservice");
    }

    @Override
    public List<IFDCurvedToggleIconButton> getIFDCurvedToggleIconButton() {
        LOG.trace("");
        AuthService authService = SignerValidationProcessor.getInstance().getAuthService();
        SignService signService = SignerValidationProcessor.getInstance().getSignService();
        if (signService == null || authService == null) {
            LOG.trace("AuthService oder SignService ist null.");
            return Collections.emptyList();
        }
        ArrayList<IFDCurvedToggleIconButton> result = new ArrayList<IFDCurvedToggleIconButton>();
        String buttonKey = this.getButtonKeyForKeyProviders(this.keyProviderType);
        String buttonText = this.getButtonText(buttonKey, this.getIFDName());
        LOG.trace("{} : {}", (Object)buttonKey, (Object)buttonText);
        LOG.trace("{} : {}", (Object)this.keyProviderType, (Object)this.keyUsage);
        KeyProviderEntry entry = new KeyProviderEntry(this.keyProviderType, this.keyUsage);
        IFDCurvedToggleIconButton button = new IFDCurvedToggleIconButton(buttonKey, buttonText, entry, this.getIFDName());
        button.setFocusable(true);
        button.setFocusPainted(true);
        button.addActionListener(Document.getInstance().getActionFactory().createIFDSelectionAction(this, KEYSTORE_ID));
        LOG.trace("SignService : add Button : {}", (Object)button.getText());
        result.add(button);
        return result;
    }

    @Override
    public String getDisplayName(String alias) {
        if (this.certs.isEmpty()) {
            return "";
        }
        Certificate cert = this.getCertificateForAlias(alias);
        if (cert == null) {
            return "";
        }
        return JComponentUtils.displayCNandSerialnumber(cert);
    }

    @Override
    public X509Certificate getCertificate() {
        return this.getCertificate(this.selectedAlias);
    }

    @Override
    public String getSignatureAlgorithm() {
        PrivateKeyResource pks = this.getPKSForAlias(this.selectedAlias);
        List supportedAlgorithms = (List)pks.supportedAlgorithms().get(KeyFunction.SIGN);
        LOG.debug("----- supportedAlgorithms : {}", (Object)supportedAlgorithms);
        if (supportedAlgorithms == null || supportedAlgorithms.isEmpty()) {
            LOG.debug("no SIGN algorithms for key: {}, use AUTHENTICATE as fallback", (Object)pks.getName());
            supportedAlgorithms = (List)pks.supportedAlgorithms().get(KeyFunction.AUTHENTICATE);
        }
        if (supportedAlgorithms == null || supportedAlgorithms.isEmpty()) {
            LOG.debug("no algorithms for key: {}", (Object)pks.getName());
            return null;
        }
        return AlgorithmUtil.getRecommendSignatureAlgorithm((List)supportedAlgorithms, defaultFilter);
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        LOG.info("");
        if (alias == null || alias.isEmpty()) {
            LOG.error("F\u00fcr einen null-Alias ist kein Zertifikat m\u00f6glich.");
            return null;
        }
        Certificate cert = this.getCertificateForAlias(alias);
        if (cert == null) {
            LOG.error("F\u00fcr Alias '{}' ist Zertifikat null.", (Object)alias);
            return null;
        }
        LOG.trace("seriennummer: {} ; cert CN : {}", (Object)alias, (Object)cert.getSubjectCommonName());
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
            return (X509Certificate)cf.generateCertificate(bais);
        }
        catch (CertificateException ex) {
            LOG.error("", (Throwable)ex);
            return null;
        }
    }

    private Certificate getCertificateForAlias(String alias) {
        List cert = this.certs.stream().filter(c -> c.getSerialNumber().getValueAsString().equals(alias)).collect(Collectors.toList());
        return (Certificate)cert.get(0);
    }

    private PrivateKeyResource getPKSForAlias(String alias) {
        int index = this.certs.indexOf(this.getCertificateForAlias(alias));
        return this.privateKeyResources.get(index);
    }

    @Override
    public PrivateKeyResource getPrivateKeyResourceImpl() {
        return this.getPKSForAlias(this.selectedAlias);
    }

    public void addAliasListener(AliasListener l) {
        this.listenerList.add(AliasListener.class, l);
    }

    public void fireSelectAlias(AbstractKeyProvider keyProvider) {
        LOG.trace("");
        for (AliasListener listener : (AliasListener[])this.listenerList.getListeners(AliasListener.class)) {
            LOG.trace("listener:keyprovider => {} : {}", (Object)listener.getClass().getSimpleName(), (Object)keyProvider.getIFDName());
            LOG.trace("selectAlias von {}", (Object)keyProvider.getIFDName());
            listener.selectAlias(keyProvider);
        }
    }

    @Override
    public String getIFDName() {
        return KEYSTORE_ID + this.keyUsage.toString();
    }

    @Override
    public void setSelectedAlias(String selectedAlias) {
        this.selectedAlias = selectedAlias;
    }

    @Override
    public String getSelectedAlias() {
        if (this.selectedAlias == null) {
            this.selectedAlias = this.getDefaultAlias();
        }
        return this.selectedAlias;
    }

    @Override
    public List<String> getAllAliases() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.certs.isEmpty()) {
            return result;
        }
        for (Certificate cert : this.certs) {
            result.add(cert.getSerialNumber().getValueAsString());
        }
        return result;
    }

    @Override
    public void ifdSelected(String ifdTag) throws SignerException {
        LOG.info("selected : {}", (Object)ifdTag);
        this.certs = this.getCerts();
        for (Certificate cert : this.certs) {
            LOG.trace(cert.getSubjectCommonName());
        }
        if (this.certs.isEmpty()) {
            LOG.error("Keine Zertifikate vom Signaturdienst erhalten.");
            return;
        }
        this.fireSelectAlias(this);
        this.addKeyProviderToStep(this);
    }

    private List<Certificate> getCerts() throws SignerException {
        ClientRemoteSignature clientRemoteSignature;
        KeycloakAuthClient keycloakAuthClient;
        KeycloakHttpClient keycloakHttpClient;
        KeycloakDeployment keycloakDeployment;
        LOG.info("");
        SignService signService = SignerValidationProcessor.getInstance().getSignService();
        if (signService == null) {
            LOG.warn("Einstellungen/Governikusdienste: Signaturdienst ist nicht konfiguriert.");
            throw new SignerException(ErrorCode.SIGN_SERVICE_NOT_CONFIGURED, null);
        }
        AuthService authService = SignerValidationProcessor.getInstance().getAuthService();
        if (authService == null) {
            LOG.warn("Einstellungen/Governikusdienste: Authentisierungsdienst ist nicht konfiguriert.");
            throw new SignerException(ErrorCode.AUTH_SERVICE_NOT_CONFIGURED, null);
        }
        LOG.trace("AuthService & SignService sind konfiguriert.");
        boolean loginAttempt = false;
        if (authService.getUsername() == null) {
            LOG.info("Anmeldedaten abfragen...");
            loginAttempt = authService.requestUsernamePassword();
        } else {
            loginAttempt = true;
            LOG.trace("AuthService hat Anmeldedaten.");
        }
        if (!loginAttempt) {
            LOG.warn("Keycloak: Nutzer hat die Anmeldung abgebrochen, daher kann Signaturdienst nicht angesprochen werden.");
            return Collections.emptyList();
        }
        ConnectServerWaitWindow waitWindow = new ConnectServerWaitWindow((Component)Document.getInstance().getFrame());
        waitWindow.showWindow();
        LOG.trace("Wartezeichen...");
        try {
            LOG.trace("KeycloakDeployment ...");
            keycloakDeployment = authService.getKeycloakDeployment();
            LOG.trace("KeycloakDeployment ok");
        }
        catch (Exception e) {
            this.closeWaitWindow(waitWindow);
            LOG.error("KeycloakDeployment failed : ", (Throwable)e);
            String errorDetailMessage = MessageFormat.format(Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE_AUTHSERVICE), e.getLocalizedMessage());
            ErrorDialog.showDialog(null, ERROR_IMPORT, Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE), errorDetailMessage);
            authService.setUsername(null);
            return Collections.emptyList();
        }
        LOG.trace("Evaluate AuthService URL : {}", (Object)keycloakDeployment.getAuthServerBaseUrl());
        String eval = SignerValidationProcessor.getInstance().getProxyConfiguration().evalAutoConfigUrl(keycloakDeployment.getAuthServerBaseUrl());
        LOG.trace("Evaluate AuthService URL. Fehler: {}", (Object)eval);
        SignerValidationProcessor.getInstance().getProxyConfiguration();
        try {
            LOG.trace("KeycloakHttpClient ...");
            keycloakHttpClient = new KeycloakHttpClient(SignerValidationProcessor.getInstance().getNewHttpClient());
            LOG.trace("KeycloakHttpClient ok");
        }
        catch (Exception e) {
            this.closeWaitWindow(waitWindow);
            LOG.error("KeycloakHttpClient failed : ", (Throwable)e);
            String errorDetailMessage = MessageFormat.format(Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE_AUTHSERVICE), e.getLocalizedMessage());
            ErrorDialog.showDialog(null, ERROR_IMPORT, Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE), errorDetailMessage);
            authService.setUsername(null);
            return Collections.emptyList();
        }
        keycloakDeployment.setClient((HttpClient)keycloakHttpClient);
        LOG.trace("keycloakDeployment completed");
        try {
            LOG.trace("KeycloakAuthClient ...");
            keycloakAuthClient = new KeycloakAuthClient(keycloakDeployment, authService.getUsername(), authService.getPassword());
            LOG.trace("KeycloakAuthClient ok");
        }
        catch (Exception e) {
            this.closeWaitWindow(waitWindow);
            LOG.error("KeycloakAuthClient failed : ", (Throwable)e);
            String errorDetailMessage = MessageFormat.format(Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE_AUTHSERVICE), e.getLocalizedMessage());
            ErrorDialog.showDialog(null, ERROR_IMPORT, Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE), errorDetailMessage);
            authService.setUsername(null);
            return Collections.emptyList();
        }
        try {
            LOG.trace("Keycloak AccessToken ...");
            String accessToken = keycloakAuthClient.getAccessToken();
            boolean accessTokenOK = accessToken != null && !accessToken.isEmpty();
            LOG.trace("AccessToken {}", (Object)(accessTokenOK ? "ok." : "failed"));
            LOG.info("Keycloak-Anmeldung ok");
        }
        catch (Exception e) {
            this.closeWaitWindow(waitWindow);
            LOG.error("Keycloak AccessToken failed : {}", (Throwable)e);
            if (e.getMessage().contains("401")) {
                String errorDetailMessage = MessageFormat.format(Messages.getString("dialog.error.import.keystore.message.authservice.unauthorized"), authService.getUsername());
                LOG.error("401 / Unauthorized : {}", (Object)errorDetailMessage);
                LOG.warn("Daher kann Signaturdienst nicht angesprochen werden: Zertifikatenliste ist leer.");
                ErrorDialog.showDialog(null, ERROR_IMPORT, Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE), errorDetailMessage);
            } else {
                String errorDetailMessage = MessageFormat.format(Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE_AUTHSERVICE), e.getLocalizedMessage());
                LOG.error(errorDetailMessage);
                ErrorDialog.showDialog(null, ERROR_IMPORT, Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE), errorDetailMessage);
            }
            authService.setUsername(null);
            return Collections.emptyList();
        }
        try {
            LOG.trace("ClientRemoteSignature ...");
            clientRemoteSignature = new ClientRemoteSignature((de.governikus.csl.transport.HttpClient)keycloakHttpClient, signService.getUrl(), keycloakAuthClient);
            LOG.trace("ClientRemoteSignature ok");
        }
        catch (Exception e) {
            this.closeWaitWindow(waitWindow);
            LOG.error("ClientRemoteSignature failed : ", (Throwable)e);
            String errorDetailMessage = MessageFormat.format(Messages.getString("dialog.error.import.keystore.message.signservice"), e.getLocalizedMessage());
            ErrorDialog.showDialog(null, ERROR_IMPORT, Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE), errorDetailMessage);
            authService.setUsername(null);
            return Collections.emptyList();
        }
        try {
            LOG.trace("PrivateKeyResources ...");
            this.privateKeyResources = clientRemoteSignature.getPrivateKeyResources();
            LOG.trace("PrivateKeyResources ok");
            LOG.trace("PrivateKeyResources is empty ? : {}", (Object)this.privateKeyResources.isEmpty());
        }
        catch (Exception e) {
            this.closeWaitWindow(waitWindow);
            LOG.error("PrivateKeyResources failed : ", (Throwable)e);
            if (e.getMessage().contains("401")) {
                String errorDetailMessage = MessageFormat.format(Messages.getString("dialog.error.import.keystore.message.signservice.unauthorized"), authService.getUsername());
                LOG.error("401 / Unauthorized: {}", (Object)errorDetailMessage);
                LOG.trace("{} : {}", (Object)ErrorCode.SIGN_SERVICE_ERROR, (Object)ErrorCode.SIGN_SERVICE_ERROR.getDescription());
                ErrorDialog.showDialog(null, ERROR_IMPORT, Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE), errorDetailMessage);
            } else if (e instanceof RemoteSigningException && e.getMessage().contains("SIGNSERVICE_NOT_REACHABLE")) {
                LOG.error("Fehler des Signaturdienstes.");
                String errorDetailMessage = MessageFormat.format(Messages.getString("dialog.error.import.keystore.message.signservice.not.reachable"), signService.getUrl());
                ErrorDialog.showDialog(null, ERROR_IMPORT, Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE), errorDetailMessage);
            } else {
                LOG.error("Fehler des Signaturdienstes.");
                String errorDetailMessage = MessageFormat.format(Messages.getString("dialog.error.import.keystore.message.signservice"), e.getLocalizedMessage());
                ErrorDialog.showDialog(null, ERROR_IMPORT, Messages.getString(DIALOG_ERROR_IMPORT_KEYSTORE_MESSAGE), errorDetailMessage);
            }
            authService.setUsername(null);
            return Collections.emptyList();
        }
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        for (PrivateKeyResource pkr : this.privateKeyResources) {
            LOG.trace("");
            try {
                result.add(Certificate.forX509((java.security.cert.Certificate)pkr.getCertificate().certificate()));
            }
            catch (Exception ex) {
                this.closeWaitWindow(waitWindow);
                LOG.error("Das Hinzufuegen des Zertifikats ist fehlgeschlagen: {}" + ex.getLocalizedMessage());
                LOG.error("{} : {}", (Object)ErrorCode.SIGN_SERVICE_ERROR.name(), (Object)ErrorCode.SIGN_SERVICE_ERROR.getDescription());
                authService.setUsername(null);
                throw new SignerException(ErrorCode.SIGN_SERVICE_ERROR, (Throwable)ex);
            }
        }
        this.closeWaitWindow(waitWindow);
        LOG.info("result : {}", result.isEmpty() ? " leer." : result);
        return result;
    }

    private void closeWaitWindow(ConnectServerWaitWindow waitWindow) {
        if (waitWindow == null) {
            return;
        }
        waitWindow.closeWindow();
    }

    public static class KeycloakHttpClient
    extends SystemDefaultHttpClient
    implements de.governikus.csl.transport.HttpClient {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(KeycloakHttpClient.class);
        BoreumHttpClient bhc;

        public KeycloakHttpClient(BoreumHttpClient bhc) {
            this.bhc = bhc;
        }

        public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
            Args.notNull((Object)request, (String)"HTTP request");
            try {
                Header[] hds = request.getAllHeaders();
                HttpHeader[] hhds = new HttpHeader[hds.length];
                for (int i = 0; i < hds.length; ++i) {
                    hhds[i] = new HttpHeader(hds[i].getName(), hds[i].getValue());
                }
                if (request.getMethod().equalsIgnoreCase("GET")) {
                    log.trace("GET...");
                    return this.bhc.getIt(request.getURI(), hhds);
                }
                HttpEntity he = ((HttpEntityEnclosingRequestBase)request).getEntity();
                if (request.getMethod().equalsIgnoreCase("POST")) {
                    log.trace("POST...");
                    return this.bhc.postIt(request.getURI(), (HttpRequest)new InputStreamRequest(he.getContent(), he.getContentType().getValue(), he.getContentEncoding() == null ? null : he.getContentEncoding().getValue()), hhds);
                }
                if (request.getMethod().equalsIgnoreCase("PUT")) {
                    log.trace("PUT...");
                    return this.bhc.putIt(request.getURI(), (HttpRequest)new InputStreamRequest(he.getContent(), he.getContentType().getValue(), he.getContentEncoding() == null ? null : he.getContentEncoding().getValue()), hhds);
                }
                throw new NotImplementedException("Nicht implementiert " + request.getMethod());
            }
            catch (Exception e) {
                AbstractKeyProvider.LOG.error("", (Throwable)e);
                throw new IOException(e);
            }
        }

        public void addDefaultHeader(String name, String value) {
            AbstractKeyProvider.LOG.info("header : {} = {}", (Object)name, (Object)value);
            this.bhc.addDefaultHeader(name, value);
        }

        public HttpResponse delete(URI uri, HttpHeader ... headers) throws ConnectionException {
            return null;
        }

        public <T> T post(URI uri, HttpRequest entity, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
            return null;
        }

        public HttpResponse post(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
            return null;
        }

        public <T> T put(URI uri, HttpRequest entity, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
            AbstractKeyProvider.LOG.trace("uri : {} \nheders : {}", (Object)uri, (Object)headers);
            try (HttpResponse response = this.bhc.put(uri, entity, headers);){
                Object object = handler.handleResponse(response);
                return (T)object;
            }
        }

        public HttpResponse put(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
            AbstractKeyProvider.LOG.trace("uri : {} \nheders : {}", (Object)uri, (Object)headers);
            return this.bhc.put(uri, entity, headers);
        }

        public <T> T get(URI uri, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
            AbstractKeyProvider.LOG.trace("uri : {} \nheders : {}", (Object)uri, (Object)headers);
            try (HttpResponse response = this.bhc.get(uri, headers);){
                Object object = handler.handleResponse(response);
                return (T)object;
            }
        }

        public HttpResponse get(URI uri, HttpHeader ... headers) throws ConnectionException {
            return null;
        }

        public ResponseData sendGETRequest(String url) throws IOException {
            return null;
        }

        public ResponseData sendPOSTRequest(String url) throws IOException {
            return null;
        }

        public ResponseData sendPOSTRequest(String url, byte[] request) throws IOException {
            return null;
        }

        public ResponseData sendGETRequest(String url, Map<String, String> header) throws IOException {
            return null;
        }

        public ResponseData sendPOSTRequest(String url, Map<String, String> header) throws IOException {
            return null;
        }

        public ResponseData sendPOSTRequest(String url, Map<String, String> header, byte[] request) throws IOException {
            return null;
        }
    }
}

