/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider;

import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ecard.client.model.CardReader;
import de.bos_bremen.ecard.client.model.Certificate;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.AliasListener;
import de.bos_bremen.ecard.client.model.keyprovider.CardKey;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.TerminalKey;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalListener;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalModel;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyProviderListener
implements TerminalListener,
AliasListener {
    private static final Logger LOG = LogManager.getLogger(KeyProviderListener.class);
    private TerminalKey terminalKey;
    private KeyUsage keyUsage;

    public KeyProviderListener(KeyUsage keyUsage) {
        this.keyUsage = keyUsage;
        this.terminalKey = new TerminalKey(this, this, null, keyUsage);
    }

    public List<CardReader> getAvailableCardList() {
        Set<TerminalModel> terminalEntries = this.terminalKey.getTerminalEntries();
        if (terminalEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CardReader> cardReaderList = new ArrayList<CardReader>();
        for (TerminalModel terminal : terminalEntries) {
            CardKey cardKey = new CardKey(terminal, null, this.keyUsage);
            CardReader cr = new CardReader(cardKey.getIFDName());
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            List<String> allAliases = cardKey.getAllAliases();
            for (String alias : allAliases) {
                X509Certificate certificate = cardKey.getCertificate(alias);
                String serialnumber = certificate.getSerialNumber().toString();
                try {
                    String base64 = Base64.getEncoder().encodeToString(certificate.getEncoded());
                    String commonName = de.bos_bremen.ci.asn1.x509.Certificate.forX509((X509Certificate)certificate).getSubjectCommonName();
                    certificates.add(new Certificate(serialnumber, base64, commonName));
                }
                catch (ParseException | CertificateEncodingException e) {
                    LOG.error("", e);
                }
            }
            cr.setCertificates(certificates);
            cardReaderList.add(cr);
        }
        return cardReaderList;
    }

    @Override
    public void terminalAdded(TerminalModel terminal) {
        LOG.info("");
    }

    @Override
    public void terminalRemoved(TerminalModel terminal) {
        LOG.info("");
    }

    @Override
    public void selectAlias(AbstractKeyProvider keyProvider) {
        LOG.info("");
    }

    public boolean checkCard(String cardnumber) {
        Set<TerminalModel> terminalEntries = this.terminalKey.getTerminalEntries();
        if (terminalEntries.isEmpty()) {
            Document.getInstance().reportError(ErrorCode.CARD_REMOVED, false, cardnumber);
            return false;
        }
        LOG.info("check if serial number or certificate");
        BigInteger bigIntCardNumber = null;
        try {
            bigIntCardNumber = new BigInteger(cardnumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (TerminalModel terminal : terminalEntries) {
            CardKey cardKey = new CardKey(terminal, null, this.keyUsage);
            List<String> allAliases = cardKey.getAllAliases();
            for (String alias : allAliases) {
                X509Certificate certificate = cardKey.getCertificate(alias);
                BigInteger serialnumber = certificate.getSerialNumber();
                if (!serialnumber.equals(bigIntCardNumber)) continue;
                LOG.info("alias: {}", (Object)alias);
                LOG.info("Seriennummer: {}", (Object)bigIntCardNumber);
                return true;
            }
        }
        Document.getInstance().reportError(ErrorCode.CARD_REMOVED, false, cardnumber);
        return false;
    }

    public KeyProvider getKeyProvider(String serialnumber) {
        LOG.info("try to get KeyProvider for serialnumber : {}", (Object)serialnumber);
        Set<TerminalModel> terminalEntries = this.terminalKey.getTerminalEntries();
        if (terminalEntries.isEmpty()) {
            Document.getInstance().reportError(ErrorCode.CARD_REMOVED, false, serialnumber);
            return null;
        }
        BigInteger bigIntCardNumber = null;
        try {
            bigIntCardNumber = new BigInteger(serialnumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (TerminalModel terminal : terminalEntries) {
            CardKey cardKey = new CardKey(terminal, null, this.keyUsage);
            List<String> allAliases = cardKey.getAllAliases();
            for (String alias : allAliases) {
                X509Certificate certificate = cardKey.getCertificate(alias);
                BigInteger bigInteger = certificate.getSerialNumber();
                LOG.debug("Zertifikat-Serialnumber : {}", (Object)bigInteger);
                if (bigInteger.equals(bigIntCardNumber)) {
                    LOG.info("Alias: {}", (Object)alias);
                    LOG.info("Mit Serialnumber: {}", (Object)bigIntCardNumber);
                    KeyProviderEntry keyProviderEntry = cardKey.getKeyProviderEntry();
                    if (keyProviderEntry == null) continue;
                    cardKey.setSelectedAlias(alias);
                    return cardKey;
                }
                LOG.info("Alias mit Serialnumber '{}' wurde nicht gefunden.", (Object)bigIntCardNumber);
            }
        }
        Document.getInstance().reportError(ErrorCode.CARD_REMOVED, false, serialnumber);
        return null;
    }
}

