/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.AliasModel;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalModel;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardPrivateKeyResourceImpl;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CardKey
extends AbstractKeyProvider {
    private final TerminalModel terminal;
    private String selectedAlias;

    public CardKey(TerminalModel terminal, KeyProviderStep step, KeyUsage keyUsage) {
        super(terminal, step, KeyProviderSource.CARD, keyUsage);
        this.terminal = terminal;
        this.keyProviderEntry = new KeyProviderEntry(this.keyProviderType, keyUsage);
        try {
            this.keyStore = KeyStore.getInstance("OCF");
            this.keyStore.load(null, null);
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
        }
    }

    @Override
    public String getSecurityProviderName() {
        return "OCF";
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyProviderEntry getKeyProviderEntry() {
        return this.keyProviderEntry;
    }

    @Override
    public X509Certificate getCertificate() {
        try {
            return (X509Certificate)this.keyStore.getCertificate(this.getSelectedAlias());
        }
        catch (KeyStoreException ex) {
            LOG.error("", (Throwable)ex);
            return null;
        }
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        try {
            return (X509Certificate)this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException ex) {
            LOG.error("", (Throwable)ex);
            return null;
        }
    }

    @Override
    public PrivateKey getKey() {
        LOG.info("");
        try {
            return (PrivateKey)this.keyStore.getKey(this.getSelectedAlias(), null);
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getSignatureAlgorithm() {
        LOG.info("");
        PrivateKey privateKey = this.getKey();
        if (privateKey == null) {
            return "";
        }
        OCFPrivateKey key = (OCFPrivateKey)privateKey;
        Algorithm recommendedAlgorithm = key.getRecommendedAlgorithm(UsageRelated.Usage.SIGNATURE);
        String algorithm = recommendedAlgorithm.getAlgorithmName();
        LOG.info("Algorithm: {}", (Object)algorithm);
        return algorithm;
    }

    @Override
    public List<String> getAllAliases() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.keyStore == null) {
            return result;
        }
        List<AliasModel> aliases = this.terminal.getAliases();
        for (AliasModel alias : aliases) {
            result.add(alias.getName());
        }
        return result;
    }

    @Override
    public String getSelectedAlias() {
        return this.selectedAlias;
    }

    @Override
    public void setSelectedAlias(String selectedAlias) {
        this.selectedAlias = selectedAlias;
    }

    @Override
    public String getIFDName() {
        return this.terminal.getName();
    }

    @Override
    public void setFileToLoad(File file) {
    }

    @Override
    public List<IFDCurvedToggleIconButton> getIFDCurvedToggleIconButton() {
        LOG.trace("");
        return Collections.emptyList();
    }

    @Override
    public String getDisplayName(String alias) {
        LOG.trace("{}", (Object)alias);
        List<AliasModel> aliases = this.terminal.getAliases();
        for (AliasModel aliasModel : aliases) {
            if (!aliasModel.getName().equals(alias)) continue;
            return aliasModel.getDisplayName();
        }
        return alias;
    }

    @Override
    public PrivateKeyResource getPrivateKeyResourceImpl() {
        return new MCardPrivateKeyResourceImpl(this.getSelectedAlias(), (OCFPrivateKey)this.getKey(), "OCF", (Certificate)this.getCertificate(), ResourceAreaType.LOCAL);
    }

    public String getSerialnumberForselectedAlias() {
        String alias = this.getSelectedAlias();
        if (alias == null || alias.isEmpty()) {
            return "";
        }
        X509Certificate cert = this.getCertificate(alias);
        if (cert == null) {
            return "";
        }
        BigInteger serialnumberBigInt = cert.getSerialNumber();
        if (serialnumberBigInt == null) {
            return "";
        }
        return serialnumberBigInt.toString();
    }
}

