/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider;

import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.AliasListener;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.keyprovider.SignServiceInterface;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.remote.sign.bnotk.BNotKClientConfiguration;
import de.governikus.csl.remote.sign.bnotk.BNotKRemoteSignature;
import de.governikus.csl.remote.sign.bnotk.util.BNotKMCardHelper;
import de.governikus.csl.remote.sign.util.AlgorithmUtil;
import de.governikus.csl.server.BNotK;
import de.governikus.csl.uom.res.KeyFunction;
import de.governikus.csl.uom.res.PrivateKeyResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.event.EventListenerList;

public class BNotKServiceKey
extends AbstractKeyProvider
implements SignServiceInterface {
    private static final String KEYSTORE_ID = "signer_BNotK";
    private List<Certificate> certs = null;
    private String selectedAlias = null;
    private List<PrivateKeyResource> privateKeyResources;
    private final EventListenerList listenerList = new EventListenerList();
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ZonedDateTime validTo;

    public BNotKServiceKey(AliasListener aliasListener, KeyProviderStep step, KeyUsage keKeyUsage) {
        super(null, step, KeyProviderSource.BNOTK, keKeyUsage);
        this.addAliasListener(aliasListener);
        this.executor.scheduleAtFixedRate(() -> {
            if (this.validTo != null && ZonedDateTime.now().isAfter(this.validTo)) {
                LOG.info("BNotK-Token ist abgelaufen, der Schl\u00fcssel muss nochmal ausgew\u00e4hlt werden");
                this.removeAllKeyProvidersFromStep();
                this.validTo = null;
                this.certs.clear();
                this.selectedAlias = null;
            }
        }, 3L, 3L, TimeUnit.MINUTES);
    }

    @Override
    public String getIFDName() {
        return KEYSTORE_ID + this.keyUsage.toString();
    }

    @Override
    public String getDisplayName(String alias) {
        if (this.certs.isEmpty()) {
            return "";
        }
        Certificate cert = this.getCertificateForAlias(alias);
        if (cert == null) {
            return "";
        }
        return JComponentUtils.displayCNandSerialnumber(cert);
    }

    @Override
    public PrivateKeyResource getPrivateKeyResourceImpl() {
        return this.getPKSForAlias(this.selectedAlias);
    }

    public void addAliasListener(AliasListener l) {
        this.listenerList.add(AliasListener.class, l);
    }

    @Override
    public void setFileToLoad(File file) {
        throw new IllegalArgumentException("try to load file for signservice");
    }

    @Override
    public List<IFDCurvedToggleIconButton> getIFDCurvedToggleIconButton() {
        LOG.trace("");
        BNotK bNotK = SignerValidationProcessor.getInstance().getBNotK();
        if (bNotK == null) {
            LOG.trace("BNotK ist in Einstellungen abgew\u00e4hlt.");
            this.validTo = null;
            if (this.certs != null) {
                this.certs.clear();
            }
            this.selectedAlias = null;
            return Collections.emptyList();
        }
        LOG.trace("BNotK ist in Einstellungen ausgew\u00e4hlt.");
        ArrayList<IFDCurvedToggleIconButton> result = new ArrayList<IFDCurvedToggleIconButton>();
        String buttonKey = this.getButtonKeyForKeyProviders(this.keyProviderType);
        String buttonText = this.getButtonText(buttonKey, this.getIFDName());
        KeyProviderEntry entry = new KeyProviderEntry(this.keyProviderType, this.keyUsage);
        IFDCurvedToggleIconButton button = new IFDCurvedToggleIconButton(buttonKey, buttonText, entry, this.getIFDName());
        button.setFocusable(true);
        button.setFocusPainted(true);
        button.addActionListener(Document.getInstance().getActionFactory().createIFDSelectionAction(this, KEYSTORE_ID));
        LOG.trace("BNotK Service : add Button : {}", (Object)button.getText());
        result.add(button);
        return result;
    }

    @Override
    public void setSelectedAlias(String selectedAlias) {
        this.selectedAlias = selectedAlias;
    }

    @Override
    public String getSelectedAlias() {
        if (this.selectedAlias == null) {
            this.selectedAlias = this.getDefaultAlias();
        }
        return this.selectedAlias;
    }

    @Override
    public List<String> getAllAliases() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.certs.isEmpty()) {
            return result;
        }
        for (Certificate cert : this.certs) {
            result.add(cert.getSerialNumber().getValueAsString());
        }
        return result;
    }

    @Override
    public void ifdSelected(String ifdTag) throws SignerException {
        LOG.info("select Speicherort : {}", (Object)ifdTag);
        this.certs = this.getCerts();
        for (Certificate cert : this.certs) {
            LOG.trace(cert.getSubjectCommonName());
        }
        if (this.certs.isEmpty()) {
            LOG.info("Keine Zertifikate in -{}- gefunden.", (Object)ifdTag);
        }
        this.fireSelectAlias(this);
        this.addKeyProviderToStep(this);
    }

    private List<Certificate> getCerts() throws SignerException {
        LOG.info("");
        BNotK bNotK = SignerValidationProcessor.getInstance().getBNotK();
        if (bNotK == null) {
            LOG.info("BNotK is null");
            throw new SignerException(ErrorCode.BNOTK_NOT_CONFIGURED, null);
        }
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        OCFPrivateKey ocfPrivateKey = null;
        try {
            Optional findFirstOCFPrivateKey = BNotKMCardHelper.findFirstOCFPrivateKey();
            if (!findFirstOCFPrivateKey.isPresent()) {
                LOG.warn("Entweder 1) ist keine BNotK-Karte im Leseger\u00e4t eingelegt oder 2) ist kein Authentisierung-Schl\u00fcssel auf der BNotK-Karte vorhanden.");
                return result;
            }
            ocfPrivateKey = (OCFPrivateKey)findFirstOCFPrivateKey.get();
            BNotKClientConfiguration config = bNotK.getBNotKClientConfiguration();
            BNotKRemoteSignature bNotKRemoteSignature = new BNotKRemoteSignature(ocfPrivateKey, config);
            this.privateKeyResources = bNotKRemoteSignature.getPrivateKeyResources();
            this.validTo = bNotKRemoteSignature.getTokenExpirationDate();
            LOG.info("Token: valid to {}", (Object)this.validTo);
            if (this.privateKeyResources != null && !this.privateKeyResources.isEmpty()) {
                for (PrivateKeyResource pkr : this.privateKeyResources) {
                    Certificate cer = Certificate.forX509((java.security.cert.Certificate)pkr.getCertificate().certificate());
                    result.add(cer);
                    LOG.info("bNotK-Remote hat ein Schl\u00fcssel : {}", (Object)cer.getSubjectCommonName());
                }
            } else {
                LOG.warn("bNotK-Remote hat keinen privaten Schl\u00fcssel zur\u00fcckgegeben.");
            }
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
            throw new SignerException(ErrorCode.BNOTK_ERROR, (Throwable)ex);
        }
        return result;
    }

    @Override
    public X509Certificate getCertificate() {
        return this.getCertificate(this.selectedAlias);
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        LOG.info("");
        Certificate cert = this.getCertificateForAlias(alias);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
            return (X509Certificate)cf.generateCertificate(bais);
        }
        catch (CertificateException ex) {
            LOG.error("", (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getSignatureAlgorithm() {
        PrivateKeyResource pks = this.getPKSForAlias(this.selectedAlias);
        List supportedAlgorithms = (List)pks.supportedAlgorithms().get(KeyFunction.SIGN);
        if (supportedAlgorithms == null || supportedAlgorithms.isEmpty()) {
            LOG.debug("no SIGN algorithms for key: {}, use AUTHENTICATE as fallback", (Object)pks.getName());
            supportedAlgorithms = (List)pks.supportedAlgorithms().get(KeyFunction.AUTHENTICATE);
        }
        if (supportedAlgorithms == null || supportedAlgorithms.isEmpty()) {
            LOG.debug("no algorithms for key: {}", (Object)pks.getName());
            return null;
        }
        return AlgorithmUtil.getRecommendSignatureAlgorithm((List)supportedAlgorithms);
    }

    private Certificate getCertificateForAlias(String alias) {
        List cert = this.certs.stream().filter(c -> c.getSerialNumber().getValueAsString().equals(alias)).collect(Collectors.toList());
        return (Certificate)cert.get(0);
    }

    private PrivateKeyResource getPKSForAlias(String alias) {
        int index = this.certs.indexOf(this.getCertificateForAlias(alias));
        return this.privateKeyResources.get(index);
    }

    private void fireSelectAlias(AbstractKeyProvider keyProvider) {
        LOG.trace("");
        for (AliasListener listener : (AliasListener[])this.listenerList.getListeners(AliasListener.class)) {
            LOG.trace("listener:keyprovider => {} : {}", (Object)listener.getClass().getSimpleName(), (Object)keyProvider.getIFDName());
            LOG.trace("selectAlias von Keyprovider ... ");
            listener.selectAlias(keyProvider);
        }
    }
}

