/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.keyprovider;

import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.IFDSelectionHandler;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.keyprovider.CertificateQuality;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.MCardUtil;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalModel;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public abstract class AbstractKeyProvider
implements KeyProvider,
SelectedFileHandler,
IFDSelectionHandler {
    protected static final Logger LOG = LogManager.getLogger(AbstractKeyProvider.class);
    public static final int AUTH_MASK = 128;
    public static final int SIGG_MASK = 64;
    public static final int CIPH_MASK = 48;
    public static final int KEY_ENCIPHERMENT = 32;
    public static final int DATA_ENCIPHERMENT = 16;
    public static final int KEY_AGREEMENT = 8;
    protected final int[] keyUsageMask;
    private static final int QUALITY_ADVANCED = 0;
    private static final int QUALITY_QUALIFIED = 1;
    private final Map<Name, Integer> states = new HashMap<Name, Integer>();
    protected final KeyProviderStep step;
    protected final KeyProviderSource keyProviderType;
    protected final KeyUsage keyUsage;
    protected KeyProviderEntry keyProviderEntry;
    protected KeyStore keyStore;
    private TerminalModel terminal;

    public abstract List<IFDCurvedToggleIconButton> getIFDCurvedToggleIconButton();

    protected AbstractKeyProvider(TerminalModel terminal, KeyProviderStep step, KeyProviderSource keyProviderType, KeyUsage keyUsage) {
        this.terminal = terminal;
        this.step = step;
        this.keyProviderType = keyProviderType;
        this.keyUsage = keyUsage;
        this.keyUsageMask = keyUsage == KeyUsage.SIGN ? new int[]{128, 64} : new int[]{48, 32, 16, 8};
    }

    @Override
    public TerminalModel getTerminalModel() {
        return this.terminal;
    }

    @Override
    public String getDefaultAlias() {
        List<String> allAliases = this.getAllAliases();
        if (allAliases != null && !allAliases.isEmpty()) {
            String alias0 = allAliases.get(0);
            LOG.info("from {} is alias 1 default : {}", (Object)allAliases.size(), (Object)alias0);
            return allAliases.get(0);
        }
        return null;
    }

    @Override
    public CertificateQuality getCertificateQuality(String alias) {
        if (alias == null) {
            return CertificateQuality.indetermined;
        }
        try {
            int check = this.check(this.getCertificate(alias));
            if (check == 1) {
                return CertificateQuality.qualified;
            }
            if (check == 0) {
                return CertificateQuality.advanced;
            }
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
        }
        return CertificateQuality.indetermined;
    }

    protected String getButtonKeyForKeyProviders(KeyProviderSource keyProviderType) {
        String buttonKey = null;
        if (keyProviderType == KeyProviderSource.SOFTWARE) {
            buttonKey = "action.softkeystore";
        } else if (keyProviderType == KeyProviderSource.NET_SIGNER) {
            buttonKey = "action.netsignerkeystore";
        } else if (keyProviderType == KeyProviderSource.BNOTK) {
            buttonKey = "action.BNotK";
        } else if (keyProviderType == KeyProviderSource.CARD) {
            buttonKey = "action.mcardkeystore";
        } else {
            LOG.error("Unknown KeyProvider type for {}", (Object)keyProviderType);
        }
        return buttonKey;
    }

    protected String getButtonText(String buttonKey, String ifdTag) {
        if (buttonKey.equalsIgnoreCase("action.softkeystore")) {
            return null;
        }
        if (buttonKey.equalsIgnoreCase("action.softkeystore.encrypt")) {
            return null;
        }
        if (buttonKey.equalsIgnoreCase("action.netsignerkeystore")) {
            return null;
        }
        if (buttonKey.equalsIgnoreCase("action.BNotK")) {
            return null;
        }
        return ifdTag;
    }

    @Override
    public void setFilesToLoad(File[] files) {
        throw new IllegalArgumentException("Tried to load several SoftKeyStores at once. Do not use this method!");
    }

    @Override
    public File getLastFolder() {
        String lastFolder = this.step.getApplicationProperties().getProperty("last_folder", null);
        if (lastFolder == null) {
            return null;
        }
        return new File(lastFolder);
    }

    @Override
    public void ifdSelected(String ifdTag) throws SignerException {
    }

    protected void addKeyProviderToStep(KeyProvider keyProvider) {
        if (this.keyUsage != KeyUsage.ENCRYPT) {
            this.removeAllKeyProvidersFromStep();
        }
        if (keyProvider != null) {
            this.step.addKeyProviderToUse(keyProvider);
        }
    }

    protected void removeAllKeyProvidersFromStep() {
        LOG.debug("Removing all KeyProvidersToUse from step...");
        List<KeyProvider> keyProviderToUse = this.step.getKeyProviderToUse();
        if (keyProviderToUse == null || keyProviderToUse.isEmpty()) {
            LOG.debug("No KeyProvidersToUse.");
            return;
        }
        for (KeyProvider keyProvider : keyProviderToUse) {
            this.step.removeKeyProviderToUse(keyProvider);
        }
        LOG.debug("All KeyProvidersToUse were removed from step.");
    }

    @Override
    public String getUsageName(String alias) {
        X509Certificate x509cert = this.getCertificate(alias);
        if (x509cert == null) {
            return "";
        }
        boolean[] ku = x509cert.getKeyUsage();
        if (ku == null) {
            return "";
        }
        HashSet<String> keyUsageString = new HashSet<String>();
        if (ku[0] || ku[1]) {
            keyUsageString.add("signature");
        }
        if (ku[1]) {
            keyUsageString.add("authentification");
        }
        if (ku[2] || ku[3] || ku[4]) {
            keyUsageString.add("encryption");
        }
        StringBuilder usageStr = new StringBuilder();
        boolean firstElement = true;
        for (String string : keyUsageString) {
            if (!firstElement) {
                usageStr.append("/");
            }
            firstElement = false;
            usageStr.append(Messages.getString("dialog.change_pin." + string));
        }
        return usageStr.toString();
    }

    protected boolean validKeyUsage(String alias) {
        try {
            Certificate certificate = Certificate.forX509((java.security.cert.Certificate)this.keyStore.getCertificate(alias));
            int cardUsage = MCardUtil.getUsage(certificate.getKeyUsage());
            for (int mask : this.keyUsageMask) {
                boolean accepted;
                boolean bl = accepted = (cardUsage & mask) == mask;
                if (!accepted) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
            return false;
        }
    }

    private int check(X509Certificate cert) throws ParseException, CertificateException, IOException {
        if (cert == null) {
            return -1;
        }
        if (this.isQualified(cert)) {
            return 1;
        }
        Name issuer = Certificate.forX509((X509Certificate)cert).getIssuer();
        Map<Name, Integer> statesList = this.getStates();
        if (statesList.containsKey(issuer)) {
            return statesList.get(issuer);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isQualified(X509Certificate cert) {
        try {
            byte[] qcStatementBytes = cert.getExtensionValue(Extension.qCStatements.getId());
            if (null == qcStatementBytes) {
                return false;
            }
            ByteArrayInputStream statementStream = new ByteArrayInputStream(qcStatementBytes);
            ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)statementStream);
            DEROctetString oct = (DEROctetString)asn1InputStream.readObject();
            try (ASN1InputStream is = new ASN1InputStream(oct.getOctets());){
                QCStatement qcStatement;
                ASN1ObjectIdentifier statementId;
                ASN1Sequence qcStatements = (ASN1Sequence)is.readObject();
                Enumeration qcStatementEnum = qcStatements.getObjects();
                do {
                    if (!qcStatementEnum.hasMoreElements()) return false;
                } while (!ETSIQCObjectIdentifiers.id_etsi_qcs_QcCompliance.equals((ASN1Primitive)(statementId = (qcStatement = QCStatement.getInstance(qcStatementEnum.nextElement())).getStatementId())));
                LOG.info("ETSI Statement that the certificate is a Qualified Certificate.");
                boolean bl = true;
                return bl;
            }
            finally {
                Utils.closeStream(statementStream);
                Utils.closeStream((Closeable)asn1InputStream);
            }
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
        return false;
    }

    private Map<Name, Integer> getStates() throws IOException {
        if (this.states.isEmpty()) {
            try (InputStream is = AbstractKeyProvider.class.getResourceAsStream("/issuerAdvanced.properties");
                 Scanner scanner = new Scanner(is, StandardCharsets.UTF_8);){
                while (scanner.hasNextLine()) {
                    this.states.put(new Name(scanner.nextLine()), 0);
                }
            }
            catch (Exception ex) {
                LOG.error("", (Throwable)ex);
            }
        }
        return this.states;
    }

    @Override
    public KeyStore getKeyStore() {
        LOG.info("");
        return null;
    }

    @Override
    public List<String> getAllAliases() {
        return Collections.emptyList();
    }

    @Override
    public String getSelectedAlias() {
        return null;
    }

    @Override
    public void setSelectedAlias(String alias) {
    }

    @Override
    public PrivateKey getKey() {
        return null;
    }

    @Override
    public X509Certificate getCertificate() {
        return null;
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        LOG.info("");
        return null;
    }

    @Override
    public String getSignatureAlgorithm() {
        return null;
    }

    @Override
    public String getSecurityProviderName() {
        return Config.getSecurityProviderName();
    }
}

