/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.formular.process.impl;

import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.model.Block;
import de.bos_bremen.ecard.client.model.formular.Formular;
import de.bos_bremen.ecard.client.model.formular.FormularChangeListener;
import de.bos_bremen.ecard.client.model.formular.FormularChangedEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractProcessFormular
implements Formular {
    protected static final Logger LOG = LogManager.getLogger(AbstractProcessFormular.class);
    private List<FormularChangeListener> allChangeListener = new ArrayList<FormularChangeListener>();
    protected Block blockNotify = new Block();

    protected AbstractProcessFormular() {
    }

    protected AbstractProcessFormular(AbstractProcessFormular formular) {
        this.allChangeListener = formular.allChangeListener != null ? new ArrayList<FormularChangeListener>(formular.allChangeListener) : new ArrayList();
        this.blockNotify = formular.blockNotify != null ? formular.blockNotify : new Block();
    }

    @Override
    public void addFormularChangeListener(FormularChangeListener listener) {
        if (!this.allChangeListener.contains(listener)) {
            this.allChangeListener.add(listener);
        }
    }

    @Override
    public void removeFormularChangeListener(FormularChangeListener listener) {
        this.allChangeListener.remove(listener);
    }

    @Override
    public void addBlockRequest() {
        this.blockNotify.addBlockRequest();
    }

    @Override
    public void removeBlockRequest() {
        if (this.blockNotify.removeBlockRequest()) {
            this.notifyAllStateChangeListener(this.blockNotify.getEvent());
        }
    }

    protected void notifyAllChangeListener(Object oldValue, Object newValue, StepFactory.StepName changedModel) {
        boolean changedValue;
        boolean bl = changedValue = oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue);
        if (changedValue && this.blockNotify.addNotifyRequest(changedModel) && this.blockNotify.getEvent() != null) {
            try {
                this.notifyAllStateChangeListener(this.blockNotify.getEvent());
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private void notifyAllStateChangeListener(FormularChangedEvent e) {
        if (this.allChangeListener != null) {
            for (FormularChangeListener changeListener : this.allChangeListener) {
                changeListener.formularChanged(e);
            }
        }
    }
}

