/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.error;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.ErrorDialog;
import de.bos_bremen.ecard.client.gui.dialog.RedundantDialog;
import de.bos_bremen.ecard.client.gui.dialog.RedundantErrorDialog;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.error.AbstractErrorHandler;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.ErrorObject;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.Icon;

public class SignerErrorHandler
extends AbstractErrorHandler {
    private final Component parent;

    public SignerErrorHandler(Component inParent) {
        this.parent = inParent;
    }

    @Override
    protected ErrorObject displayAndSendErrorCode(ErrorCode errorCode, String message, boolean showRedundant, Object ... inObjects) {
        LOG.trace((Object)errorCode);
        LOG.trace(message);
        if (message == null) {
            message = "";
        }
        Document documentInstance = Document.getInstance();
        String messageStr = MessageFormat.format(message, inObjects);
        LOG.info("\n{}", (Object)messageStr);
        Object htmlString = MultiLineTooltips.wrappString(messageStr, 80);
        if (((String)htmlString).indexOf("<html>") == -1) {
            htmlString = "<html>" + (String)htmlString + "</html>";
        }
        htmlString = ((String)htmlString).replace("\n", "<br>");
        boolean abortError = false;
        if (!(errorCode == null || ErrorCode.OK.equals((Object)errorCode) || ErrorCode.FILE_PROCESSED.equals((Object)errorCode) || ErrorCode.FILE_CANCELLED.equals((Object)errorCode) || ErrorCode.ABORTED.equals((Object)errorCode))) {
            if (showRedundant) {
                abortError = RedundantErrorDialog.showDialog(this.parent, (String)htmlString, Messages.getString("dialog.error.title"));
            } else {
                documentInstance.showMessageDialogText(this.parent, (String)htmlString);
            }
        }
        if (errorCode != null && (ErrorCode.ErrorCodeStatus.fatal.equals((Object)errorCode.state()) || ErrorCode.ErrorCodeStatus.exit.equals((Object)errorCode.state()))) {
            try {
                XMLProperties properties = documentInstance.getProcessFactory().getProperties();
                Config.getInstance().setProcessProperties(properties);
                Config.getInstance().storeDefault();
            }
            catch (Exception ex) {
                LOG.debug(ex.getMessage());
            }
            System.exit(0);
        }
        return new ErrorObject(errorCode, messageStr, abortError);
    }

    @Override
    public void displayErrorMessages(Component parentComponent, String dialogKey, String errorMessage, String detailMessage) {
        LOG.trace("");
        if (parentComponent == null) {
            parentComponent = this.parent;
        }
        ErrorDialog.showDialog(parentComponent, dialogKey, errorMessage, detailMessage);
    }

    @Override
    public int displayRedundantMessages(Component parentComponent, String key, String title, String message, int numOptions, int type, Icon icon, boolean force, boolean saveConfig) {
        LOG.trace("");
        if (parentComponent == null) {
            parentComponent = this.parent;
        }
        return RedundantDialog.showDialog(parentComponent, key, title, message, numOptions, type, force, saveConfig);
    }
}

