/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.error;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum ErrorCode {
    OK(0),
    ABORTED(1),
    FILE_PROCESSED(3),
    FILE_CANCELLED(5),
    MISSING_PARAM(10),
    ILLEGAL_PARAM(11),
    FILE_NOT_FOUND(20),
    FILE_IN_USE(21),
    SOURCE_DIR_EMPTY(22),
    OUTPUT_DIR_NOT_FOUND(23),
    CONNECTION_ERROR(24),
    CANNOT_SAVE_OUTPUT(25),
    CANNOT_WRITE_TO_FOLDER(26),
    CANNOT_UNZIP(27),
    CANNOT_CREATE_ZIP(28),
    FILE_IS_EMPTY(29),
    CANNOT_READ_FOLDER(30),
    CANNOT_OPEN_SOURCE(31),
    CANNOT_CLOSE_INPUT(33),
    KEY_NOT_FOUND(40),
    KEY_EXPIRED(41),
    KEY_NOT_YET_VALID(42),
    CANNOT_LOAD_KEYSTORE(43),
    NO_KEYSTORE_FILE(44),
    CARD_NOT_YET_INITIALIZED(45),
    CARD_REMOVED(46),
    WRONG_KEY(47),
    INVALID_PIN(50),
    TOO_MANY_WRONG_PINS(51),
    UNKNOWN_SIG_TYPE(52),
    UNKNOWN_SIG_ALGORITHM(53),
    PIN_INPUT_CANCEL(54),
    SHOWNFILE_CHANGED(55),
    VERIFY_CERTIFICATE_ERROR(56),
    UNSUPPORTED_SIG_ALGORITHM(57),
    HASHEDFILE_CHANGED(59),
    UNSUPPORTED_PDF_DIALECT(81),
    PDF_SIGNATURE_VISUALISATION_TOO_BIG(82),
    PDF_SIGNATURE_VISUALISATION_WIDTH_TOO_BIG(83),
    PDF_ENCRYPTED(84),
    PDF_SIGNATURE_IMAGE_NOT_AVAILABLE(88),
    PDF_SIGNATURE_NO_SIGNATURE_FIELD(91),
    MULTIPLE_SIGNATURES_NOT_SUPPORTED(96),
    UNKNOWN(99),
    AUTH_SERVICE_NOT_CONFIGURED(201),
    SIGN_SERVICE_NOT_CONFIGURED(202),
    AUTH_SERVICE_ERROR(203),
    TIMESTAMP_SERVICE_ERROR(204),
    SIGN_SERVICE_ERROR(205),
    CMS_MULTIPLE_DETACHED_CONTENT_SIGNATURE_MISMATCH(206),
    BNOTK_NOT_CONFIGURED(301),
    BNOTK_ERROR(302);

    private static final Logger LOG;
    private static final String BUNDLE_NAME = "de.bos_bremen.ecard.client.model.error.ErrorCode";
    private static Map<ErrorCodeResourcesType, Map<ResourceBundle, String>> processResourceBundles;
    private final int returnCode;

    private ErrorCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public static ErrorCode getErrorCodeByID(int id) {
        ErrorCode result = null;
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (errorCode == null || errorCode.returnCode != id) continue;
            result = errorCode;
        }
        return result;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String toString() {
        return ErrorCode.getString("ec." + this.returnCode + ".name");
    }

    public String getDescription() {
        return ErrorCode.getString("ec." + this.returnCode + ".description");
    }

    public ErrorCodeStatus state() {
        return ErrorCodeStatus.valueOf(ErrorCode.getString("ec." + this.returnCode + ".state"));
    }

    public int errorLevel() {
        return Integer.parseInt(ErrorCode.getString("ec." + this.returnCode + ".errorlevel"));
    }

    private static String getString(String key) {
        String string = ErrorCode.getProcessUserRessource(ErrorCodeResourcesType.wizard, key);
        if (string == null) {
            return "!" + key + "!";
        }
        return string;
    }

    private static String getProcessUserRessource(ErrorCodeResourcesType resourcesType, String key) {
        Map<ResourceBundle, String> map = processResourceBundles.get((Object)resourcesType);
        if (map == null) {
            return null;
        }
        for (ResourceBundle bundle : map.keySet()) {
            try {
                String message = bundle.getString(key);
                if (LOG.isDebugEnabled()) {
                    // empty if block
                }
                return message;
            }
            catch (MissingResourceException e) {
                LOG.debug("");
            }
        }
        return null;
    }

    public static void setLocale(Locale locale) {
        processResourceBundles.put(ErrorCodeResourcesType.wizard, ErrorCode.updateResourceBundles(processResourceBundles.get((Object)ErrorCodeResourcesType.wizard), locale));
        processResourceBundles.put(ErrorCodeResourcesType.process, ErrorCode.updateResourceBundles(processResourceBundles.get((Object)ErrorCodeResourcesType.process), locale));
        processResourceBundles.put(ErrorCodeResourcesType.project, ErrorCode.updateResourceBundles(processResourceBundles.get((Object)ErrorCodeResourcesType.project), locale));
    }

    private static Map<ResourceBundle, String> updateResourceBundles(Map<ResourceBundle, String> resourceBundles, Locale locale) {
        if (resourceBundles != null) {
            Iterator<String> bundleNames = resourceBundles.values().iterator();
            HashMap<ResourceBundle, String> tmpProcessResourceBundles = new HashMap<ResourceBundle, String>();
            while (bundleNames.hasNext()) {
                String tmpBundleName = bundleNames.next();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(tmpBundleName, locale);
                tmpProcessResourceBundles.put(resourceBundle, tmpBundleName);
            }
            resourceBundles.clear();
            resourceBundles.putAll(tmpProcessResourceBundles);
        }
        return resourceBundles;
    }

    public static void addRessourceBundle(String bundleName, ResourceBundle bundle) {
        Map<ResourceBundle, String> processResourceHashMap = processResourceBundles.get((Object)ErrorCodeResourcesType.process);
        if (processResourceHashMap == null) {
            processResourceHashMap = new HashMap<ResourceBundle, String>();
        }
        processResourceHashMap.put(bundle, bundleName);
        processResourceBundles.put(ErrorCodeResourcesType.process, processResourceHashMap);
    }

    public static void addRessourceBundle(ErrorCodeResourcesType resourcesType, String bundleName, ResourceBundle bundle) {
        Map<ResourceBundle, String> map = processResourceBundles.get((Object)resourcesType);
        if (map == null) {
            map = new HashMap<ResourceBundle, String>();
        }
        map.put(bundle, bundleName);
        processResourceBundles.put(resourcesType, map);
    }

    public static void printHelp(PrintStream out) {
        out.println("    ReturnCodes :");
        out.println("    Name\t\t\t|\tID\t|\tDescription");
        out.println("    -------------------------------------------------------------------------------------------------------------------------------------");
        out.println("    " + OK.toString() + "\t\t\t\t|\t" + ErrorCode.OK.returnCode + "\t|\t" + OK.getDescription());
        out.println("    " + ABORTED.toString() + "\t\t\t|\t" + ErrorCode.ABORTED.returnCode + "\t|\t" + ABORTED.getDescription());
        out.println("    " + FILE_PROCESSED.toString() + "\t\t|\t" + ErrorCode.FILE_PROCESSED.returnCode + "\t|\t" + FILE_PROCESSED.getDescription());
        out.println("    " + MISSING_PARAM.toString() + "\t\t|\t" + ErrorCode.MISSING_PARAM.returnCode + "\t|\t" + MISSING_PARAM.getDescription());
        out.println("    " + ILLEGAL_PARAM.toString() + "\t\t|\t" + ErrorCode.ILLEGAL_PARAM.returnCode + "\t|\t" + ILLEGAL_PARAM.getDescription());
        out.println("    " + FILE_NOT_FOUND.toString() + "\t\t|\t" + ErrorCode.FILE_NOT_FOUND.returnCode + "\t|\t" + FILE_NOT_FOUND.getDescription());
        out.println("    " + FILE_IS_EMPTY.toString() + "\t\t|\t" + ErrorCode.FILE_IS_EMPTY.returnCode + "\t|\t" + FILE_IS_EMPTY.getDescription());
        out.println("    " + SOURCE_DIR_EMPTY.toString() + "\t\t|\t" + ErrorCode.SOURCE_DIR_EMPTY.returnCode + "\t|\t" + SOURCE_DIR_EMPTY.getDescription());
        out.println("    " + OUTPUT_DIR_NOT_FOUND.toString() + "\t|\t" + ErrorCode.OUTPUT_DIR_NOT_FOUND.returnCode + "\t|\t" + OUTPUT_DIR_NOT_FOUND.getDescription());
        out.println("    " + CONNECTION_ERROR.toString() + "\t\t|\t" + ErrorCode.CONNECTION_ERROR.returnCode + "\t|\t" + CONNECTION_ERROR.getDescription());
        out.println("    " + CANNOT_SAVE_OUTPUT.toString() + "\t\t|\t" + ErrorCode.CANNOT_SAVE_OUTPUT.returnCode + "\t|\t" + CANNOT_SAVE_OUTPUT.getDescription());
        out.println("    " + CANNOT_WRITE_TO_FOLDER.toString() + "\t|\t" + ErrorCode.CANNOT_WRITE_TO_FOLDER.returnCode + "\t|\t" + CANNOT_WRITE_TO_FOLDER.getDescription());
        out.println("    " + CANNOT_UNZIP.toString() + "\t\t|\t" + ErrorCode.CANNOT_UNZIP.returnCode + "\t|\t" + CANNOT_UNZIP.getDescription());
        out.println("    " + CANNOT_OPEN_SOURCE.toString() + "\t\t|\t" + ErrorCode.CANNOT_OPEN_SOURCE.returnCode + "\t|\t" + CANNOT_OPEN_SOURCE.getDescription());
        out.println("    " + CANNOT_CLOSE_INPUT.toString() + "\t\t|\t" + ErrorCode.CANNOT_CLOSE_INPUT.returnCode + "\t|\t" + CANNOT_CLOSE_INPUT.getDescription());
        out.println("    " + KEY_NOT_FOUND.toString() + "\t\t|\t" + ErrorCode.KEY_NOT_FOUND.returnCode + "\t|\t" + KEY_NOT_FOUND.getDescription());
        out.println("    " + KEY_EXPIRED.toString() + "\t\t\t|\t" + ErrorCode.KEY_EXPIRED.returnCode + "\t|\t" + KEY_EXPIRED.getDescription());
        out.println("    " + KEY_NOT_YET_VALID.toString() + "\t\t|\t" + ErrorCode.KEY_NOT_YET_VALID.returnCode + "\t|\t" + KEY_NOT_YET_VALID.getDescription());
        out.println("    " + CANNOT_LOAD_KEYSTORE.toString() + "\t|\t" + ErrorCode.CANNOT_LOAD_KEYSTORE.returnCode + "\t|\t" + CANNOT_LOAD_KEYSTORE.getDescription());
        out.println("    " + NO_KEYSTORE_FILE.toString() + "\t\t|\t" + ErrorCode.NO_KEYSTORE_FILE.returnCode + "\t|\t" + NO_KEYSTORE_FILE.getDescription());
        out.println("    " + CARD_NOT_YET_INITIALIZED.toString() + "\t|\t" + ErrorCode.CARD_NOT_YET_INITIALIZED.returnCode + "\t|\t" + CARD_NOT_YET_INITIALIZED.getDescription());
        out.println("    " + CARD_REMOVED.toString() + "\t\t|\t" + ErrorCode.CARD_REMOVED.returnCode + "\t|\t" + CARD_REMOVED.getDescription());
        out.println("    " + INVALID_PIN.toString() + "\t\t\t|\t" + ErrorCode.INVALID_PIN.returnCode + "\t|\t" + INVALID_PIN.getDescription());
        out.println("    " + TOO_MANY_WRONG_PINS.toString() + "\t\t|\t" + ErrorCode.TOO_MANY_WRONG_PINS.returnCode + "\t|\t" + TOO_MANY_WRONG_PINS.getDescription());
        out.println("    " + UNKNOWN_SIG_TYPE.toString() + "\t\t|\t" + ErrorCode.UNKNOWN_SIG_TYPE.returnCode + "\t|\t" + UNKNOWN_SIG_TYPE.getDescription());
        out.println("    " + UNKNOWN_SIG_ALGORITHM.toString() + "\t|\t" + ErrorCode.UNKNOWN_SIG_ALGORITHM.returnCode + "\t|\t" + UNKNOWN_SIG_ALGORITHM.getDescription());
        out.println("    " + VERIFY_CERTIFICATE_ERROR.toString() + "\t|\t" + ErrorCode.VERIFY_CERTIFICATE_ERROR.returnCode + "\t|\t" + VERIFY_CERTIFICATE_ERROR.getDescription());
        out.println("    " + UNSUPPORTED_PDF_DIALECT.toString() + "\t|\t" + ErrorCode.UNSUPPORTED_PDF_DIALECT.returnCode + "\t|\t" + UNSUPPORTED_PDF_DIALECT.getDescription());
        out.println("    " + PDF_SIGNATURE_VISUALISATION_TOO_BIG.toString() + "\t|\t" + ErrorCode.PDF_SIGNATURE_VISUALISATION_TOO_BIG.returnCode + "\t|\t" + PDF_SIGNATURE_VISUALISATION_TOO_BIG.getDescription());
        out.println("    " + PDF_SIGNATURE_VISUALISATION_WIDTH_TOO_BIG.toString() + "\t|\t" + ErrorCode.PDF_SIGNATURE_VISUALISATION_WIDTH_TOO_BIG.returnCode + "\t|\t" + PDF_SIGNATURE_VISUALISATION_WIDTH_TOO_BIG.getDescription());
        out.println("    " + PDF_SIGNATURE_IMAGE_NOT_AVAILABLE.toString() + "\t|\t" + ErrorCode.PDF_SIGNATURE_IMAGE_NOT_AVAILABLE.returnCode + "\t|\t" + PDF_SIGNATURE_IMAGE_NOT_AVAILABLE.getDescription());
        out.println("    " + UNKNOWN.toString() + "\t\t\t|\t" + ErrorCode.UNKNOWN.returnCode + "\t|\t" + UNKNOWN.getDescription());
        out.println("    " + FILE_IN_USE.toString() + "\t\t\t|\t" + ErrorCode.FILE_IN_USE.returnCode + "\t|\t" + FILE_IN_USE.getDescription());
        out.println("    " + CANNOT_CREATE_ZIP.toString() + "\t\t|\t" + ErrorCode.CANNOT_CREATE_ZIP.returnCode + "\t|\t" + CANNOT_CREATE_ZIP.getDescription());
        out.println("    " + WRONG_KEY.toString() + "\t\t\t|\t" + ErrorCode.WRONG_KEY.returnCode + "\t|\t" + WRONG_KEY.getDescription());
        out.println("    " + PIN_INPUT_CANCEL.toString() + "\t\t|\t" + ErrorCode.PIN_INPUT_CANCEL.returnCode + "\t|\t" + PIN_INPUT_CANCEL.getDescription());
        out.println("    " + SHOWNFILE_CHANGED.toString() + "\t\t|\t" + ErrorCode.SHOWNFILE_CHANGED.returnCode + "\t|\t" + SHOWNFILE_CHANGED.getDescription());
        out.println("    " + UNSUPPORTED_SIG_ALGORITHM.toString() + "\t|\t" + ErrorCode.UNSUPPORTED_SIG_ALGORITHM.returnCode + "\t|\t" + UNSUPPORTED_SIG_ALGORITHM.getDescription());
        out.println("    " + MULTIPLE_SIGNATURES_NOT_SUPPORTED.toString() + "\t|\t" + ErrorCode.MULTIPLE_SIGNATURES_NOT_SUPPORTED.returnCode + "\t|\t" + MULTIPLE_SIGNATURES_NOT_SUPPORTED.getDescription());
    }

    public static ErrorCode getErrorcodeByName(String name) {
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (!errorCode.name().equals(name)) continue;
            return errorCode;
        }
        return UNKNOWN;
    }

    static {
        LOG = LogManager.getLogger(ErrorCode.class);
        processResourceBundles = new HashMap<ErrorCodeResourcesType, Map<ResourceBundle, String>>();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        ErrorCode.addRessourceBundle(ErrorCodeResourcesType.wizard, BUNDLE_NAME, resourceBundle);
    }

    public static enum ErrorCodeStatus {
        fatal,
        warn,
        info,
        exit;

    }

    public static enum ErrorCodeResourcesType {
        wizard,
        process,
        project;

    }
}

