/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.error;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.ErrorHandler;
import de.bos_bremen.ecard.client.model.error.ErrorObject;
import de.bos_bremen.ecard.client.model.error.SignerException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractErrorHandler
implements ErrorHandler {
    protected static final Logger LOG = LogManager.getLogger(AbstractErrorHandler.class);

    protected AbstractErrorHandler() {
    }

    @Override
    public ErrorObject reportError(SignerException signerException, boolean showRedundant, Object ... inObjects) {
        LOG.trace("");
        ArrayList<Object> dummyObjects = new ArrayList<Object>();
        if (inObjects != null) {
            dummyObjects.addAll(Arrays.asList(inObjects));
        }
        String message = signerException.getErrorCode().getDescription();
        if (signerException.getParams() != null) {
            dummyObjects.addAll(Arrays.asList(signerException.getParams()));
        }
        if (signerException.getCause() != null) {
            dummyObjects.add(signerException.getCause());
            LOG.debug("Exception occured:", signerException.getCause());
        }
        return this.displayAndSendErrorCode(signerException.getErrorCode(), message, showRedundant, dummyObjects.toArray());
    }

    @Override
    public ErrorObject reportError(ErrorObject errorObj, boolean showRedundant) {
        String message = errorObj.getErrorMessage();
        LOG.info(message);
        return this.displayAndSendErrorCode(errorObj.getErrorCode(), message, showRedundant, new Object[0]);
    }

    @Override
    public ErrorObject reportError(ErrorCode errorCode, boolean showRedundant, Object ... inObjects) {
        String message = errorCode == null ? "" : errorCode.getDescription();
        LOG.trace("ErrorCode : {} : {}", (Object)errorCode, (Object)message);
        return this.displayAndSendErrorCode(errorCode, message, showRedundant, inObjects);
    }

    @Override
    public ErrorObject reportError(int ec, boolean showRedundant, Object ... inObjects) {
        LOG.trace("");
        ErrorCode errorCode = ErrorCode.getErrorCodeByID(ec);
        return this.reportError(errorCode, showRedundant, inObjects);
    }

    @Override
    public void displayErrorMessages(Component parent, String dialogKey, String detailMessage) {
        LOG.trace("");
        String message = Messages.getString("dialog." + dialogKey + ".message");
        this.displayErrorMessages(parent, dialogKey, message, detailMessage);
    }

    protected abstract ErrorObject displayAndSendErrorCode(ErrorCode var1, String var2, boolean var3, Object ... var4);

    public abstract int displayRedundantMessages(Component var1, String var2, String var3, String var4, int var5, int var6, Icon var7, boolean var8, boolean var9);
}

