/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.process.RootProcessName;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.JDICSubsequentProcess;
import de.bos_bremen.ecard.client.model.ProcessSubsequentProcess;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubsequentProcessFactory {
    private static final Logger LOG = LogManager.getLogger(SubsequentProcessFactory.class);
    private static final String SUBSEQUENT_PROCESS_KEY = "subsequent_process";
    private static final String PROCESS_KEY = "process";
    private static final String PROCESS_MANUAL_KEY = "processmanual";
    private static final String DEFAULT_PARAM_KEY = "default_param";
    private static int createNONEProcess = -1;
    private static int lastProcessCounter = -1;

    private SubsequentProcessFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static List<SubsequentProcess> loadSubsequentProcess(XMLProperties properties) {
        XMLProperties providerProperties = properties.getPropertiesForNode(SUBSEQUENT_PROCESS_KEY);
        HashMap<String, SubsequentProcess> processHashMap = SubsequentProcessFactory.createSubsequentProcessFromProperties(providerProperties);
        SubsequentProcessFactory.fillSubsequentProcessWithParameter(providerProperties, processHashMap);
        ArrayList<SubsequentProcess> list = new ArrayList<SubsequentProcess>(processHashMap.values());
        SubsequentProcessFactory.fillInDefaultSubsequentProcess(list);
        return list;
    }

    public static List<SubsequentProcess> loadDefaultSubsequentProcess() {
        return SubsequentProcessFactory.loadSubsequentProcess(new XMLProperties());
    }

    private static void fillSubsequentProcessWithParameter(XMLProperties providerProperties, HashMap<String, SubsequentProcess> processHashMap) {
        for (Map.Entry<Object, Object> entry : providerProperties.entrySet()) {
            try {
                int dotIndex = ((String)entry.getKey()).indexOf("/");
                if (dotIndex < 0) continue;
                String counterStr = ((String)entry.getKey()).substring(0, dotIndex);
                if (counterStr.indexOf("_") != -1) {
                    counterStr = counterStr.substring(counterStr.indexOf("_") + 1);
                }
                if (entry.getKey().toString().indexOf(DEFAULT_PARAM_KEY) == -1) continue;
                SubsequentProcess subsecuentProcess = processHashMap.get(counterStr);
                String subsequentProcessKey = (String)entry.getKey();
                String property = providerProperties.getProperty(subsequentProcessKey);
                if (property == null || property.isEmpty()) continue;
                String string = new String(Base64.getDecoder().decode(property), StandardCharsets.UTF_8);
                subsecuentProcess.setDefaultProcessParam(string);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
    }

    private static HashMap<String, SubsequentProcess> createSubsequentProcessFromProperties(XMLProperties providerProperties) {
        HashMap<String, SubsequentProcess> processHashMap = new HashMap<String, SubsequentProcess>();
        for (Object key : providerProperties.keySet()) {
            try {
                int dotIndex = ((String)key).indexOf("/");
                if (dotIndex == -1) continue;
                String counterStr = ((String)key).substring(0, dotIndex);
                counterStr = counterStr.substring(counterStr.lastIndexOf("_") + 1);
                SubsequentProcess subsecuentProcess = processHashMap.get(counterStr);
                int processCounter = Integer.parseInt(counterStr);
                if (processCounter > lastProcessCounter) {
                    lastProcessCounter = processCounter;
                }
                if (subsecuentProcess == null) {
                    subsecuentProcess = new SubsequentProcess("COUNTER_" + counterStr);
                }
                if (key.toString().indexOf(PROCESS_MANUAL_KEY) != -1) {
                    str = providerProperties.getProperty((String)key);
                    str = str.replaceAll("[\r\n]", "");
                    processStr = new String(Base64.getDecoder().decode(str), StandardCharsets.UTF_8);
                    subsecuentProcess.setProcess(processStr);
                } else {
                    if (key.toString().indexOf(PROCESS_KEY) == -1) continue;
                    str = providerProperties.getProperty((String)key);
                    str = str.replaceAll("[\r\n]", "");
                    processStr = new String(Base64.getDecoder().decode(str), StandardCharsets.UTF_8);
                    ProcessI process = null;
                    if ("none".equalsIgnoreCase(processStr)) {
                        subsecuentProcess = new ProcessSubsequentProcess(RootProcessName.getInstance(), "COUNTER_" + counterStr);
                    } else {
                        process = Document.getInstance().getProcessFactory().getProcess(processStr);
                        if (process != null) {
                            subsecuentProcess = new ProcessSubsequentProcess(process.getProcessName(), "COUNTER_" + counterStr);
                        } else {
                            JDICSubsequentProcess.JDICFunction jdicFunction = null;
                            try {
                                jdicFunction = JDICSubsequentProcess.JDICFunction.valueOf(processStr);
                            }
                            catch (Exception ex) {
                                LOG.debug(ex.getMessage());
                            }
                            if (jdicFunction != null) {
                                subsecuentProcess = new JDICSubsequentProcess(jdicFunction, "COUNTER_" + counterStr);
                            } else {
                                LOG.info("Unbekannter Process {} kann nicht eingelsen werden", (Object)processStr);
                                continue;
                            }
                        }
                    }
                }
                processHashMap.put(counterStr, subsecuentProcess);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return processHashMap;
    }

    private static void fillInDefaultSubsequentProcess(List<SubsequentProcess> subsequentlist) {
        boolean containsJDICEmailProcess = false;
        boolean containsJDICPrintProcess = false;
        boolean containsJDICOpenProcess = false;
        boolean containsNONEProcess = false;
        ArrayList<ProcessName> allProcesses = new ArrayList<ProcessName>();
        List<ProcessI> processes = Document.getInstance().getProcessFactory().getProcesses();
        for (ProcessI process : processes) {
            allProcesses.add(process.getProcessName());
        }
        for (SubsequentProcess subsequentProcess : subsequentlist) {
            if (subsequentProcess instanceof ProcessSubsequentProcess) {
                ProcessSubsequentProcess processSubsequentProcess = (ProcessSubsequentProcess)subsequentProcess;
                if ("none".equalsIgnoreCase(processSubsequentProcess.getProcessName().getName())) {
                    containsNONEProcess = true;
                }
                allProcesses.remove(((ProcessSubsequentProcess)subsequentProcess).getProcessName());
                continue;
            }
            if (!(subsequentProcess instanceof JDICSubsequentProcess)) continue;
            JDICSubsequentProcess jDICSubsequentProcess = (JDICSubsequentProcess)subsequentProcess;
            switch (jDICSubsequentProcess.getJDICFunction()) {
                case EMAIL: {
                    containsJDICEmailProcess = true;
                    break;
                }
                case OPEN: {
                    containsJDICOpenProcess = true;
                    break;
                }
                case PRINT: {
                    containsJDICPrintProcess = true;
                    break;
                }
            }
        }
        for (ProcessName processName : allProcesses) {
            if (!Document.getInstance().getProductFunctions().getLicence("process/" + processName.getName()).isEditable()) continue;
            subsequentlist.add(new ProcessSubsequentProcess(processName, "COUNTER_" + ++lastProcessCounter));
        }
        if (!containsJDICEmailProcess) {
            subsequentlist.add(new JDICSubsequentProcess(JDICSubsequentProcess.JDICFunction.EMAIL, "COUNTER_" + ++lastProcessCounter));
        }
        if (!containsJDICOpenProcess) {
            subsequentlist.add(new JDICSubsequentProcess(JDICSubsequentProcess.JDICFunction.OPEN, "COUNTER_" + ++lastProcessCounter));
        }
        if (!containsJDICPrintProcess) {
            subsequentlist.add(new JDICSubsequentProcess(JDICSubsequentProcess.JDICFunction.PRINT, "COUNTER_" + ++lastProcessCounter));
        }
        if (!containsNONEProcess) {
            createNONEProcess = ++lastProcessCounter;
            subsequentlist.add(new ProcessSubsequentProcess(RootProcessName.getInstance(), "COUNTER_" + lastProcessCounter));
        }
    }

    public static XMLProperties saveSubsequentProcess(List<SubsequentProcess> subsequentProcessList, XMLProperties properties) {
        XMLProperties processProperties = new XMLProperties();
        for (int i = 0; subsequentProcessList != null && i < subsequentProcessList.size(); ++i) {
            SubsequentProcess subsecuentProcess = subsequentProcessList.get(i);
            SubsequentProcessFactory.storePropertiesProcess(processProperties, subsecuentProcess);
        }
        properties.addAll(SUBSEQUENT_PROCESS_KEY, processProperties);
        return properties;
    }

    protected static void storePropertiesProcess(XMLProperties properties, SubsequentProcess process) {
        if (process == null) {
            return;
        }
        XMLProperties processProperties = new XMLProperties();
        if (process instanceof ProcessSubsequentProcess) {
            ProcessSubsequentProcess processSubsequentProcess = (ProcessSubsequentProcess)process;
            processProperties.put(PROCESS_KEY, Base64.getEncoder().encodeToString(processSubsequentProcess.getProcessName().toString().getBytes(StandardCharsets.UTF_8)));
        } else if (process instanceof JDICSubsequentProcess) {
            JDICSubsequentProcess jDICSubsequentProcess = (JDICSubsequentProcess)process;
            processProperties.put(PROCESS_KEY, Base64.getEncoder().encodeToString(jDICSubsequentProcess.getJDICFunction().toString().getBytes(StandardCharsets.UTF_8)));
        } else {
            processProperties.put(PROCESS_MANUAL_KEY, process.getProcess() != null ? Base64.getEncoder().encodeToString(process.getProcess().getBytes(StandardCharsets.UTF_8)) : Base64.getEncoder().encodeToString("".getBytes(StandardCharsets.UTF_8)));
        }
        processProperties.put(DEFAULT_PARAM_KEY, process.getDefaultProcessParam() != null ? Base64.getEncoder().encodeToString(process.getDefaultProcessParam().getBytes(StandardCharsets.UTF_8)) : Base64.getEncoder().encodeToString("".getBytes(StandardCharsets.UTF_8)));
        properties.addAll(process.getUniqueId(), processProperties);
    }

    public static int getNextProcessCounter() {
        return ++lastProcessCounter;
    }

    public static boolean createdNONEProcess() {
        return createNONEProcess != -1;
    }

    public static String getNONEProcessUID() {
        return "COUNTER_" + createNONEProcess;
    }
}

