/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubsequentProcess {
    protected static final Logger LOG = LogManager.getLogger(SubsequentProcess.class);
    private String process;
    private String defaultProcessParam;
    private String uniqueId;

    public SubsequentProcess(String process, String defaultProcessParam, String uID) {
        this.defaultProcessParam = defaultProcessParam;
        this.uniqueId = uID;
        this.process = process;
    }

    public SubsequentProcess(String uID) {
        this.uniqueId = uID;
    }

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getDefaultProcessParam() {
        return this.defaultProcessParam;
    }

    public void setDefaultProcessParam(String defaultProcessParam) {
        this.defaultProcessParam = defaultProcessParam;
    }

    public void callSubsequentProcess(List<File> files) {
        for (File file : files) {
            this.callSubsequentProcess(file);
        }
    }

    protected void callSubsequentProcess(final File fileToOpen) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(SubsequentProcess.this.getProcess());
                if (SubsequentProcess.this.getDefaultProcessParam() != null) {
                    cmd.add(SubsequentProcess.this.getDefaultProcessParam());
                }
                cmd.add(fileToOpen.getAbsolutePath());
                BufferedReader inS = null;
                try {
                    Process runtimeProcess = Runtime.getRuntime().exec(cmd.toArray(new String[0]));
                    inS = new BufferedReader(new InputStreamReader(runtimeProcess.getErrorStream(), StandardCharsets.UTF_8));
                    String readLine = null;
                    while ((readLine = inS.readLine()) != null) {
                        LOG.info(readLine);
                    }
                    LOG.info((Object)runtimeProcess.exitValue());
                }
                catch (IOException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                finally {
                    if (inS != null) {
                        try {
                            inS.close();
                        }
                        catch (IOException e) {
                            LOG.debug("");
                        }
                    }
                }
            }
        };
        t.start();
    }

    public String toString() {
        return this.getProcess();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.process == null ? 0 : this.process.hashCode());
        result = 31 * result + (this.uniqueId == null ? 0 : this.uniqueId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubsequentProcess other = (SubsequentProcess)obj;
        if (this.process == null ? other.process != null : !this.process.equals(other.process)) {
            return false;
        }
        return !(this.uniqueId == null ? other.uniqueId != null : !this.uniqueId.equals(other.uniqueId));
    }
}

