/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model;

import de.bos_bremen.ecard.client.model.HashedFile;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import java.io.File;

public class PropertyHashedFile
extends HashedFile {
    public static final String PROTOCOL_TYPE_HTML = "html";
    public static final String PROTOCOL_TYPE_PDF = "pdf";
    private static final long serialVersionUID = -7326694791237258260L;
    private HashedFileStatus hashedFileStatus = HashedFileStatus.YELLOW;
    private String protocolType = "html";

    public PropertyHashedFile(File orgFile, byte[] orgFileHash, MajorTotalResult result, String protocolType) {
        super(orgFile, orgFileHash);
        this.protocolType = protocolType;
        this.setHashedFileStatus(result);
    }

    public PropertyHashedFile(File orgFile, String protocolType) {
        super(orgFile);
        this.protocolType = protocolType;
    }

    public HashedFileStatus getHashedFileStatus() {
        return this.hashedFileStatus;
    }

    private void setHashedFileStatus(MajorTotalResult major) {
        if (major == null) {
            this.hashedFileStatus = HashedFileStatus.YELLOW;
            return;
        }
        this.hashedFileStatus = major == MajorTotalResult.TOTAL_PASSED ? HashedFileStatus.GREEN : (major == MajorTotalResult.TOTAL_FAILED ? HashedFileStatus.RED : HashedFileStatus.YELLOW);
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static enum HashedFileStatus {
        GREEN,
        YELLOW,
        RED;

    }
}

